/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui.common;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jdbcacsess.gui.common.ComponentProperty;

public abstract class JFrameBase
extends JFrame {
    private static final long serialVersionUID = 1007026627927273468L;
    private static Vector<JFrameBase> jframeBases = new Vector();
    private ComponentProperty cp;

    public final ComponentProperty init() {
        this.cp = new ComponentProperty();
        this.cp.restoreWindowPosition(this, this.getSize().width, this.getSize().height);
        this.initialFrame();
        return this.cp;
    }

    public final ComponentProperty init(String attrKey, String attrValue) {
        this.cp = new ComponentProperty();
        this.cp.appendCondition(attrKey, attrValue);
        this.cp.restoreWindowPosition(this, this.getSize().width, this.getSize().height);
        this.initialFrame();
        return this.cp;
    }

    private void initialFrame() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFrameBase.this.closeFrame();
            }
        });
        jframeBases.add(this);
    }

    public final void closeFrame() {
        this.cp.storeWindowPosition(this);
        jframeBases.remove(this);
        this.dispose();
        this.frameClosing();
    }

    public void frameClosing() {
    }

    public static final void changeUI() {
        for (JFrameBase item : jframeBases) {
            SwingUtilities.updateComponentTreeUI(item);
        }
    }

    public final void closeAnotherFrame() {
        ArrayList<JFrameBase> tmp = new ArrayList<JFrameBase>(jframeBases);
        for (JFrameBase item : tmp) {
            if (item == this) continue;
            item.closeFrame();
        }
    }
}

