/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jdbcacsess.PrefixStringBuffer;
import jdbcacsess.createdata.JFrameCreateDataSetting;
import jdbcacsess.gui.CellRendererDataBaseObject;
import jdbcacsess.gui.JFrameCreateSqlFromTree;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JPopupMenuCnageUI;
import jdbcacsess.gui.common.PopupKeybordAndMouse;
import jdbcacsess.sql.ColumnInfoParameter;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.DBObject;
import jdbcacsess.sql.DBObjectCatalogs;
import jdbcacsess.sql.DBObjectProcedures;
import jdbcacsess.sql.DBObjectSchemas;
import jdbcacsess.sql.DBObjectTableTypes;
import jdbcacsess.sql.DBObjectTables;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeDataBaseObjects
extends JTree
implements Observer {
    private static final long serialVersionUID = -294660305476207747L;
    private DefaultMutableTreeNode defaultMutableTreeNode;
    private JTextPaneSqlStatement sqlStatement;
    private JPopupMenuCnageUI jPopupMenuTable = null;
    private JMenuItem jMenuItemOrderPrimeKey = null;
    private JMenuItem jMenuItemNoOrder = null;
    private JMenuItem jMenuItemTreeUpdate = null;
    private DefaultTreeModel treeModel;
    private JMenuItem jMenuItemCreateData = null;
    private JMenuItem jMenuItemName = null;
    private JMenuItem jMenuItemEditSql = null;
    private JFrameCreateSqlFromTree csft = null;

    @Override
    public void update(Observable o, Object sqlStatement) {
        this.sqlStatement = (JTextPaneSqlStatement)sqlStatement;
        if (this.csft != null) {
            this.csft.setSqlStatement(this.sqlStatement);
        }
    }

    public JTreeDataBaseObjects() {
        this.initialize();
    }

    private void initialize() {
        this.setRowHeight(this.getFontMetrics(CellRendererDataBaseObject.treeFontPrim).getHeight());
        this.setModel(null);
        this.setToggleClickCount(2);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                JTreeDataBaseObjects.this.expandColumnName(e.getPath());
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 2) {
                    JTreeDataBaseObjects.this.transColumnName(JTreeDataBaseObjects.this.getSelectionPaths());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
            }
        });
        this.setCellRenderer(new CellRendererDataBaseObject());
        new PopupKeybordAndMouse(this, (JPopupMenu)this.getJPopupMenuTable());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.jPopupMenuTable.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                if (JTreeDataBaseObjects.this.getSelectionCount() == 0) {
                    JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemName.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(false);
                    return;
                }
                JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemName.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(true);
                boolean tblFlg = false;
                boolean colFlg = false;
                TreePath[] treePathArray = JTreeDataBaseObjects.this.getSelectionPaths();
                int n = 0;
                int n2 = treePathArray.length;
                while (n < n2) {
                    TreePath treePath = treePathArray[n];
                    if (JTreeDataBaseObjects.this.isDBObject(treePath, DBObjectTables.DBObjectTable.class)) {
                        tblFlg = true;
                    }
                    if (JTreeDataBaseObjects.this.isDBObject(treePath, ColumnInfoTable.class)) {
                        colFlg = true;
                    }
                    ++n;
                }
                if (!(tblFlg | colFlg)) {
                    JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemName.setEnabled(false);
                }
                if (!tblFlg) {
                    JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(false);
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }
        });
    }

    protected void transColumnName(TreePath[] treePaths) {
        if (treePaths == null) {
            return;
        }
        PrefixStringBuffer psb = new PrefixStringBuffer(" ", ", ");
        int i = 0;
        while (i < treePaths.length) {
            TreePath treePath = treePaths[i];
            String selectItem = "";
            if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class)) {
                selectItem = this.getLastPathUserObject(treePath).toString();
            }
            if (this.isDBObject(treePath, ColumnInfoTable.class)) {
                selectItem = this.getTableColunName(treePath);
            }
            psb.appendItem(selectItem);
            ++i;
        }
        this.sqlStatement.insertCurrentPosition(psb.getString());
    }

    private String getTableColunName(TreePath columnTreePath) {
        ColumnInfoTable cit = (ColumnInfoTable)this.getLastPathUserObject(columnTreePath);
        DBObjectTables.DBObjectTable table = (DBObjectTables.DBObjectTable)this.getDBObject(columnTreePath, DBObjectTables.DBObjectTable.class);
        return String.valueOf(table.getTableName()) + "." + cit.getColumnName();
    }

    private Object getLastPathUserObject(TreePath treePath) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return treeNode.getUserObject();
    }

    private boolean isDBObject(TreePath treePath, Class cls) {
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return symbol.getUserObject().getClass() == cls;
    }

    private void expandColumnName(TreePath treePath) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class) || this.isDBObject(treePath, DBObjectProcedures.DBObjectProcedure.class)) {
            DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode dummyChild = (DefaultMutableTreeNode)symbol.getFirstChild();
            if (dummyChild.getUserObject() != null) {
                return;
            }
            DBObjectSchemas.DBObjectSchema dbObjectSchema = (DBObjectSchemas.DBObjectSchema)this.getDBObject(treePath, DBObjectSchemas.DBObjectSchema.class);
            try {
                if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class)) {
                    DBObjectTables.DBObjectTable dbObjectTable = (DBObjectTables.DBObjectTable)symbol.getUserObject();
                    for (ColumnInfoTable col : SqlExec.getColumnMames(dbObjectSchema == null ? "" : dbObjectSchema.getSchemaName(), dbObjectTable.getTableName())) {
                        symbol.add(new DefaultMutableTreeNode(col));
                    }
                }
                if (this.isDBObject(treePath, DBObjectProcedures.DBObjectProcedure.class)) {
                    DBObjectCatalogs.DBObjectCatalog dBObjectCatalog = (DBObjectCatalogs.DBObjectCatalog)this.getDBObject(treePath, DBObjectCatalogs.DBObjectCatalog.class);
                    DBObjectProcedures.DBObjectProcedure dBObjectProcedure = (DBObjectProcedures.DBObjectProcedure)symbol.getUserObject();
                    for (ColumnInfoParameter cip : SqlExec.getProcedureColumns(dBObjectCatalog == null ? "" : dBObjectCatalog.getCatalogName(), dbObjectSchema == null ? "" : dbObjectSchema.getSchemaName(), dBObjectProcedure.getProcedureName())) {
                        symbol.add(new DefaultMutableTreeNode(cip));
                    }
                }
            }
            catch (SQLException e1) {
                JDialogMessage.sqlErrorDialog(e1, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
            }
            symbol.remove(dummyChild);
            this.treeModel.reload(symbol);
        }
    }

    public void setTables() throws SQLException {
        this.defaultMutableTreeNode = new DefaultMutableTreeNode(SqlExec.getDatabaseProductName());
        DatabaseMetaData dmd = SqlExec.getDatabaseMetaData();
        DBObjectCatalogs catalogs = new DBObjectCatalogs(dmd);
        for (DBObject catalog : catalogs.getDBObjects()) {
            DefaultMutableTreeNode catalogNode = this.createNode(catalog);
            this.defaultMutableTreeNode.add(catalogNode);
            DBObjectSchemas schemas = new DBObjectSchemas(dmd);
            for (DBObject schema : schemas.getDBObjects()) {
                DefaultMutableTreeNode schemaNode = this.createNode(schema);
                catalogNode.add(schemaNode);
                DBObjectTableTypes tableTypes = new DBObjectTableTypes(dmd);
                for (DBObject tableType : tableTypes.getDBObjects()) {
                    DBObjectTables tables = new DBObjectTables((DBObjectCatalogs.DBObjectCatalog)catalog, (DBObjectSchemas.DBObjectSchema)schema, (DBObjectTableTypes.DBObjectTableType)tableType, dmd);
                    if (tables.getDBObjects().size() == 0) continue;
                    DefaultMutableTreeNode tableTypeNode = this.createNode(tableType);
                    schemaNode.add(tableTypeNode);
                    for (DBObject table : tables.getDBObjects()) {
                        DefaultMutableTreeNode tableNode = this.createNode(table);
                        tableNode.add(this.createNode(null));
                        tableTypeNode.add(tableNode);
                    }
                }
                DBObjectProcedures procedurs = new DBObjectProcedures((DBObjectCatalogs.DBObjectCatalog)catalog, (DBObjectSchemas.DBObjectSchema)schema, dmd);
                if (procedurs.getDBObjects().size() == 0) continue;
                DefaultMutableTreeNode procedureHeadNode = this.createNode("PROCEDURE");
                schemaNode.add(procedureHeadNode);
                for (DBObject procedure : procedurs.getDBObjects()) {
                    DefaultMutableTreeNode procedureNode = this.createNode(procedure);
                    procedureNode.add(this.createNode(null));
                    procedureHeadNode.add(procedureNode);
                }
            }
        }
        this.treeModel = new DefaultTreeModel(this.defaultMutableTreeNode);
        this.setModel(this.treeModel);
        this.setSelectionRow(0);
    }

    private DefaultMutableTreeNode createNode(Object userObject) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        node.setUserObject(userObject);
        return node;
    }

    private Object getDBObject(TreePath treePath, Class cls) {
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object[] obj = symbol.getUserObjectPath();
        if (obj.length - 2 < 0) {
            return null;
        }
        int i = obj.length - 2;
        while (i >= 0) {
            if (obj[i].getClass() == cls) {
                return obj[i];
            }
            --i;
        }
        return null;
    }

    private SchemaTableName getSchemaTable(TreePath tableTreePath) {
        DBObjectSchemas.DBObjectSchema schema = (DBObjectSchemas.DBObjectSchema)this.getDBObject(tableTreePath, DBObjectSchemas.DBObjectSchema.class);
        DBObjectTables.DBObjectTable table = (DBObjectTables.DBObjectTable)this.getLastPathUserObject(tableTreePath);
        SchemaTableName stn = new SchemaTableName(schema.getSchemaName(), table.getTableName());
        return stn;
    }

    private ArrayList<SchemaTableName> getSelectSchemaTables() {
        ArrayList<SchemaTableName> list = new ArrayList<SchemaTableName>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            ColumnInfoTable ci;
            SchemaTableName stn;
            TreePath treePath = treePathArray[n];
            if (this.isDBObject(treePath, ColumnInfoTable.class) && list.indexOf(stn = (ci = (ColumnInfoTable)this.getLastPathUserObject(treePath)).getSchemaTableName()) == -1) {
                list.add(stn);
            }
            if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class) && list.indexOf(stn = this.getSchemaTable(treePath)) == -1) {
                list.add(stn);
            }
            ++n;
        }
        return list;
    }

    private ArrayList<String> getSelectColumns() {
        ArrayList<String> list = new ArrayList<String>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath tp = treePathArray[n];
            if (this.isDBObject(tp, ColumnInfoTable.class)) {
                list.add(this.getTableColunName(tp));
            }
            ++n;
        }
        return list;
    }

    private StringBuffer getSelColumsListPhrase(ArrayList<String> columns) {
        StringBuffer str = new StringBuffer("");
        if (columns.size() == 0) {
            str.append("*");
            return str;
        }
        boolean first = true;
        for (String column : columns) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(column);
        }
        return str;
    }

    private StringBuffer getFromPhrase(ArrayList<SchemaTableName> list) {
        if (list.size() > 2) {
            JOptionPane.showMessageDialog(null, "2\u3064\u4ee5\u4e0a\u306e\u30c6\u30fc\u30d6\u30eb\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f\u3002\nJOIN\u6761\u4ef6\u4f5c\u6210\u3067\u306f\u6700\u521d\u306e2\u30c6\u30fc\u30d6\u30eb\u304c\u6709\u52b9\u3067\u3059");
        }
        StringBuffer str = new StringBuffer("\nFROM ");
        boolean first = true;
        for (SchemaTableName stn : list) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(stn.getCompleteTableName());
        }
        return str;
    }

    private String getWherePhrase(ArrayList<SchemaTableName> list) {
        if (list.size() < 2) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        ArrayList<String> editKey = new ArrayList<String>();
        this.createPrimaryAndColumn(editKey, str, list.get(0), list.get(1));
        this.createPrimaryAndColumn(editKey, str, list.get(1), list.get(0));
        if (editKey.size() == 0) {
            return "";
        }
        return "\nWHERE " + str.substring(5);
    }

    private void createPrimaryAndColumn(ArrayList<String> editKey, StringBuffer str, SchemaTableName primStn, SchemaTableName colStn) {
        ArrayList<String> primList = null;
        ArrayList<ColumnInfoTable> colList = null;
        try {
            primList = SqlExec.getPrimaryKeys(primStn.getSchemaName(), primStn.getTableName());
            colList = SqlExec.getColumnMames(colStn.getSchemaName(), colStn.getTableName());
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u30ab\u30e9\u30e0\u60c5\u5831\u53d6\u5f97\u3067\u5931\u6557");
            return;
        }
        for (ColumnInfoTable col : colList) {
            for (String prim : primList) {
                if (!col.getColumnName().equals(prim) || editKey.contains(col.getColumnName())) continue;
                str.append(" AND " + primStn.getTableName() + "." + prim + " = " + colStn.getTableName() + "." + col.getColumnName());
                editKey.add(col.getColumnName());
            }
        }
    }

    private StringBuffer getOrdeByPhrase(ArrayList<SchemaTableName> list) {
        StringBuffer text = new StringBuffer();
        boolean first = true;
        for (SchemaTableName stn : list) {
            try {
                for (String key : SqlExec.getPrimaryKeys(stn.getSchemaName(), stn.getTableName())) {
                    if (first) {
                        first = false;
                        text.append("\nORDER BY ");
                    } else {
                        text.append(", ");
                    }
                    text.append(stn.getTableName()).append(".").append(key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return text;
    }

    private void actionPerformedSelect(boolean isOrderBy) {
        if (this.sqlStatement == null) {
            return;
        }
        ArrayList<SchemaTableName> schemaTables = this.getSelectSchemaTables();
        ArrayList<String> columns = this.getSelectColumns();
        StringBuffer text = new StringBuffer("SELECT ");
        text.append(this.getSelColumsListPhrase(columns));
        text.append(this.getFromPhrase(schemaTables));
        text.append(this.getWherePhrase(schemaTables));
        if (isOrderBy) {
            text.append(this.getOrdeByPhrase(schemaTables));
        }
        text.append("\n");
        this.sqlStatement.setText(text.toString());
        this.sqlStatement.requestFocus();
    }

    private JPopupMenuCnageUI getJPopupMenuTable() {
        if (this.jPopupMenuTable == null) {
            this.jPopupMenuTable = new JPopupMenuCnageUI();
            this.jPopupMenuTable.add(this.getJMenuItemOrderPrimeKey());
            this.jPopupMenuTable.add(this.getJMenuItemNoOrder());
            this.jPopupMenuTable.add(this.getJMenuItemEditSql());
            this.jPopupMenuTable.add(this.getJMenuItemName());
            this.jPopupMenuTable.addSeparator();
            this.jPopupMenuTable.add(this.getJMenuItemCreateData());
            this.jPopupMenuTable.addSeparator();
            this.jPopupMenuTable.add(this.getJMenuItemTreeUpdate());
        }
        return this.jPopupMenuTable;
    }

    private JMenuItem getJMenuItemOrderPrimeKey() {
        if (this.jMenuItemOrderPrimeKey == null) {
            this.jMenuItemOrderPrimeKey = new JMenuItem();
            this.jMenuItemOrderPrimeKey.setText("\u5168\u4ef6\u691c\u7d22\u6587\uff08\u4e3b\u30ad\u30fc\u9806\uff09");
            this.jMenuItemOrderPrimeKey.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(true);
                }
            });
        }
        return this.jMenuItemOrderPrimeKey;
    }

    private JMenuItem getJMenuItemNoOrder() {
        if (this.jMenuItemNoOrder == null) {
            this.jMenuItemNoOrder = new JMenuItem();
            this.jMenuItemNoOrder.setText("\u5168\u4ef6\u691c\u7d22\u6587\uff08\u7121\u6307\u5b9a\u9806\uff09");
            this.jMenuItemNoOrder.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(false);
                }
            });
        }
        return this.jMenuItemNoOrder;
    }

    private JMenuItem getJMenuItemTreeUpdate() {
        if (this.jMenuItemTreeUpdate == null) {
            this.jMenuItemTreeUpdate = new JMenuItem();
            this.jMenuItemTreeUpdate.setText("\u5b9a\u7fa9\u518d\u53d6\u8fbc");
            this.jMenuItemTreeUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JTreeDataBaseObjects.this.setTables();
                    }
                    catch (SQLException e1) {
                        JDialogMessage.sqlErrorDialog(e1, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
                    }
                }
            });
        }
        return this.jMenuItemTreeUpdate;
    }

    private JMenuItem getJMenuItemCreateData() {
        if (this.jMenuItemCreateData == null) {
            this.jMenuItemCreateData = new JMenuItem();
            this.jMenuItemCreateData.setText("\u30c7\u30fc\u30bf\u751f\u6210\u2026");
            this.jMenuItemCreateData.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedCreateData(e);
                }
            });
        }
        return this.jMenuItemCreateData;
    }

    private void actionPerformedCreateData(ActionEvent e) {
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath treePath = treePathArray[n];
            if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class)) {
                JFrameCreateDataSetting dlg = new JFrameCreateDataSetting(this.getSchemaTable(treePath));
                dlg.setVisible(true);
            }
            ++n;
        }
    }

    private JMenuItem getJMenuItemName() {
        if (this.jMenuItemName == null) {
            this.jMenuItemName = new JMenuItem();
            this.jMenuItemName.setText("\u5b9a\u7fa9\u540d\u3000\u3000\u3000\u3000\u3000\u4e2d\u30dc\u30bf\u30f3");
            this.jMenuItemName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.transColumnName(JTreeDataBaseObjects.this.getSelectionPaths());
                }
            });
        }
        return this.jMenuItemName;
    }

    private JMenuItem getJMenuItemEditSql() {
        if (this.jMenuItemEditSql == null) {
            this.jMenuItemEditSql = new JMenuItem();
            this.jMenuItemEditSql.setText("\u691c\u7d22\u6587\u751f\u6210\u2026");
            this.jMenuItemEditSql.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedEditSql();
                }
            });
        }
        return this.jMenuItemEditSql;
    }

    protected void actionPerformedEditSql() {
        if (this.csft == null) {
            this.csft = new JFrameCreateSqlFromTree();
            this.csft.setSqlStatement(this.sqlStatement);
        }
        TreePath[] tps = this.getSelectionPaths();
        TreeMap<SchemaTableName, ArrayList<ColumnInfoTable>> map = new TreeMap<SchemaTableName, ArrayList<ColumnInfoTable>>();
        int i = 0;
        while (i < tps.length) {
            SchemaTableName stn;
            if (this.isDBObject(tps[i], DBObjectTables.DBObjectTable.class)) {
                stn = this.getSchemaTable(tps[i]);
                if (map.get(stn) == null) {
                    map.put(stn, new ArrayList());
                }
            } else if (this.isDBObject(tps[i], ColumnInfoTable.class)) {
                ColumnInfoTable cit = (ColumnInfoTable)this.getLastPathUserObject(tps[i]);
                stn = cit.getSchemaTableName();
                ArrayList<ColumnInfoTable> list = map.get(stn);
                if (list == null) {
                    list = new ArrayList();
                    map.put(stn, list);
                }
                list.add(cit);
            }
            ++i;
        }
        this.csft.setTablemap(map);
        this.csft.setVisible(true);
    }
}

