/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.gui.JTableSqlModel;

public class CellRendererSqlTable
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 7761617446993569948L;
    public static final Font tableFont = new Font("Dialog", 0, 12);
    private int autoResizeWidth = JFrameSetting.getAutoResizeWidth();

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Array) {
            try {
                Object[] o = (Object[])((Array)((Object)value)).getArray();
                value = Arrays.asList(o);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!(table.getModel() instanceof JTableSqlModel)) {
            return this;
        }
        JTableSqlModel sqlTableModel = (JTableSqlModel)table.getModel();
        CellMode mode = sqlTableModel.getMode(row, column);
        if (!isSelected) {
            switch (mode) {
                case CELL_UPDATE: {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.RED);
                    break;
                }
                case CELL_UPDATE_COMPLETE: {
                    this.setForeground(Color.RED);
                    this.setBackground(Color.WHITE);
                    break;
                }
                case CELL_DELETE: {
                    this.setForeground(Color.LIGHT_GRAY);
                    this.setBackground(Color.BLACK);
                    break;
                }
                case CELL_DELETE_COMPLETE: {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.LIGHT_GRAY);
                    break;
                }
                case CELL_INSERT: {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLUE);
                    break;
                }
                case CELL_INSERT_COMPLETE: {
                    this.setForeground(Color.BLUE);
                    this.setBackground(Color.WHITE);
                    break;
                }
                case CELL_DENYEDIT_IN_CELL: {
                    this.setForeground(Color.MAGENTA);
                    this.setBackground(Color.WHITE);
                    break;
                }
                default: {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.WHITE);
                }
            }
        }
        String msg = String.valueOf(sqlTableModel.getColumnInfo(column).getColumnComment()) + "  [" + sqlTableModel.getColumnInfo(column).getColumnClass().getName() + "]";
        if (mode == CellMode.CELL_DENYEDIT_IN_CELL) {
            if (value instanceof JdbcacsessException) {
                this.setToolTipText("<html>" + msg + "<br>ResultSet\u304b\u3089get\u3057\u305f\u6642\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002<br>" + value + "<br>\u5024\u3092\u5909\u66f4\u3059\u308b\u6642\u306f\u3001\u4e00\u65e6\u300eNULL\u306b\u66f4\u65b0\u300f\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002" + "</html>");
            } else {
                this.setToolTipText("<html>" + msg + "<br>\u30bb\u30eb\u66f4\u65b0\u51fa\u6765\u307e\u305b\u3093\u3002\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u304b\u306e\u5834\u5408\u3067\u3059\u3002<ol>" + "<li>\u30d0\u30a4\u30ca\u30ea\u8aad\u8fbc\u91cf\u3092\u8d85\u3048\u3066\u3044\u308b\uff1a\u30d0\u30a4\u30ca\u30ea\u8aad\u8fbc\u91cf\u3092\u4e0a\u3052\u3066\u518d\u691c\u7d22\u3057\u3066\u4e0b\u3055\u3044</li>" + "<li>\u6539\u884c\u3092\u542b\u3093\u3067\u3044\u308b\u30c6\u30ad\u30b9\u30c8\uff1a\u30c6\u30ad\u30b9\u30c8\u7de8\u96c6\u753b\u9762\u3067\u66f4\u65b0\u3057\u3066\u4e0b\u3055\u3044</li>" + "<li>\u300e\u30ab\u30e9\u30e0\u66f4\u65b0(\u30d5\u30a1\u30a4\u30eb\u304b\u3089)\u300f\u76f4\u5f8c\uff1a\u518d\u691c\u7d22\u3057\u3066\u4e0b\u3055\u3044</li>" + "<li>toString()\u3092\u5b9f\u88c5\u3057\u3066\u306a\u3044\uff1aResultSet\u306egetter\u3092\u5909\u66f4\u3059\u308b\u304b\u3001\u72ec\u81ea\u30af\u30e9\u30b9\u3092\u7528\u610f\u3059\u308b</li>" + "</ol></html>");
            }
        } else {
            this.setToolTipText("<html>" + msg + "</html>");
        }
        this.setFont(tableFont);
        if (sqlTableModel.getColumnInfo(column).isPrimaryKey()) {
            this.setFont(this.getFont().deriveFont(3));
        } else {
            this.setFont(this.getFont().deriveFont(0));
        }
        if (value == null) {
            this.setValue("#NULL#");
            this.setFont(this.getFont().deriveFont(this.getFont().getStyle(), 10.0f));
            this.setHorizontalAlignment(0);
        } else if (value instanceof JdbcacsessException) {
            this.setValue("#ERROR#");
            this.setFont(this.getFont().deriveFont(this.getFont().getStyle(), 10.0f));
            this.setHorizontalAlignment(0);
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        if (sqlTableModel.isDefaultInsert(row, column)) {
            this.setValue("#DEFAULT#");
            this.setFont(this.getFont().deriveFont(this.getFont().getStyle(), 10.0f));
            this.setHorizontalAlignment(0);
        }
        if (this.autoResizeWidth != 0) {
            String s = this.autoResizeWidth < this.getText().length() ? this.getText().substring(0, this.autoResizeWidth - 1) : this.getText();
            TableColumn tc = table.getColumnModel().getColumn(column);
            int width = this.getFontMetrics(this.getFont()).stringWidth(s) + 4;
            if (tc.getPreferredWidth() < width) {
                tc.setPreferredWidth(width);
            }
        }
        return this;
    }
}

