/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import jdbcacsess.csv.CSVLine;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.gui.common.ConstItemHeader;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlAnalyze;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExport
implements QueryExecuteListener {
    private CsvInfo csvInfo;
    private BufferedWriter ot;

    public CsvExport(CsvInfo info) {
        this.csvInfo = info;
    }

    @Override
    public void init() throws IOException, FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(this.csvInfo.getFileName());
        this.ot = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.csvInfo.getEncoding().getValue()));
    }

    @Override
    public void setResultHeader(ArrayList<ColumnInfoResult> rowData, SqlAnalyze sqlAnalyze) throws IOException {
        if (this.csvInfo.getItemHeader() == ConstItemHeader.TRUE) {
            this.setResultDetail(rowData);
        }
    }

    public void setResultDetail(ArrayList rowData) throws IOException {
        CSVLine csvline = new CSVLine();
        csvline.setToken(this.csvInfo.getColumnDelimiter().getValue());
        String nullValue = JFrameSetting.getColumnOutNullValue();
        int i = 0;
        while (i < rowData.size()) {
            Object o = rowData.get(i);
            if (o != null) {
                csvline.addItem(o.toString());
            } else {
                csvline.addItem(nullValue);
            }
            ++i;
        }
        String str = String.valueOf(csvline.getLine()) + this.csvInfo.getLineSeparator().getValue();
        this.ot.write(str, 0, str.length());
    }

    @Override
    public void completeQuery(QueryExecuteStatus breakStatus) {
        try {
            if (this.ot != null) {
                this.ot.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!breakStatus.isErr()) {
            SchemaTableName stn = this.csvInfo.getPropTableName();
            if (!stn.getCompleteTableName().equals("")) {
                this.csvInfo.currentDataSave();
                JDialogMessage.infoDialog(String.valueOf(breakStatus.getCnt()) + "\u4ef6\u51fa\u529b\u3057\u307e\u3057\u305f\n\u4eca\u56de\u306e\u51fa\u529b\u6761\u4ef6\u3092CSV\u5165\u529b\u5c65\u6b74\u306b\u8f09\u305b\u307e\u3057\u305f\u3002", "CSV\u51fa\u529b\u7d42\u4e86\u3057\u307e\u3057\u305f " + this.csvInfo.getPropTableName());
            } else {
                JDialogMessage.infoDialog(String.valueOf(breakStatus.getCnt()) + "\u4ef6\u51fa\u529b\u3057\u307e\u3057\u305f\n\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u51fa\u529b\u7d50\u679c\u306a\u306e\u3067\u3001\n" + "\u4eca\u56de\u306e\u51fa\u529b\u6761\u4ef6\u306fCSV\u5165\u529b\u5c65\u6b74\u306b\u8f09\u305b\u307e\u3093", "CSV\u51fa\u529b\u7d42\u4e86\u3057\u307e\u3057\u305f");
            }
        }
    }

    @Override
    public void status(QueryExecuteStatus breakStatus) {
    }

    @Override
    public void errorException(Exception ex) {
    }
}

