/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jdbcacsess.ConvertToCommponent2;
import jdbcacsess.SettingFile;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.gui.common.JDialogMessage;
import org.w3c.dom.Element;

public class JdbcAcsess {
    public static final String major = "1";
    public static final String minor = "4";
    public static final String date = "2007/07/04";

    public static void main(String[] args) {
        try {
            JdbcAcsess.setLogger();
            JdbcAcsess.checkSettingFile();
            ToolTipManager.sharedInstance().setDismissDelay(60000);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JdbcAcsess.setUIManager();
                    new JFrameMain();
                }
            });
            JdbcAcsess.envDisplay();
        }
        catch (RuntimeException err) {
            JDialogMessage.errorDialog(err);
        }
    }

    private static void setLogger() {
        try {
            FileHandler fh = new FileHandler(SettingFile.getInstance().getFileName("message.log"));
            fh.setFormatter(new SimpleFormatter());
            Logger.global.addHandler(fh);
            Logger.global.setLevel(JFrameSetting.getLoggerLevel());
            Logger.global.info("\u30ed\u30b0\u30ec\u30d9\u30eb\u3092" + JFrameSetting.getLoggerLevel() + "\u306b\u8a2d\u5b9a\u3057\u307e\u3057\u305f");
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static void setUIManager() {
        String className = new ComponentProperty().getToString(UIManager.class, "className");
        if (!"".equals(className)) {
            boolean flg = false;
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = 0;
            int n2 = lookAndFeelInfoArray.length;
            while (n < n2) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n];
                if (info.getClassName().equals(className)) {
                    flg = true;
                    break;
                }
                ++n;
            }
            if (!flg) {
                className = "";
            }
        }
        if ("".equals(className)) {
            className = UIManager.getSystemLookAndFeelClassName();
            new ComponentProperty().put(UIManager.class, "className", className);
        }
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    private static void checkSettingFile() {
        SettingFile sf = SettingFile.getInstance();
        Element element = sf.getRootElement("version");
        String major = major;
        String minor = "0";
        if (element.getAttributes().getLength() != 0) {
            major = element.getAttribute("major");
            minor = element.getAttribute("minor");
        }
        if (major.equals(major) && minor.equals("0")) {
            Logger.global.info("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e<component>\u3092<component2>\u3078\u5909\u63db\u3057\u307e\u3059\u3002");
            new ConvertToCommponent2();
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(major));
        if (Double.valueOf(stringBuilder.append(".").append(minor).toString()) < Double.valueOf("1.4")) {
            Logger.global.info("\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u3059");
            element.setAttribute("major", major);
            element.setAttribute("minor", minor);
        }
        Logger.global.info("\u30d0\u30fc\u30b8\u30e7\u30f3\u30c1\u30a7\u30c3\u30af\u7d42\u4e86");
    }

    private static void envDisplay() {
    }
}

