/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.StringTokenizer;
import jdbcacsess.InfoListSetting;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMappingInfo
extends InfoListSetting<SqlMappingInfo> {
    public static final String BASETABNAME = "sqlmappinginfo";
    String cellEditorClassName;
    String cellRendererClassName;
    String dbms;
    String getResultSetClassName;
    String resultSetMethodName;
    String type;
    Boolean enable = true;

    public static String editKey(String dbms, String type) {
        return String.valueOf(dbms) + "#$#" + type;
    }

    public SqlMappingInfo() {
        Element e = this.topElement();
        if (e.getElementsByTagName(this.getBaseTagName()).getLength() == 0) {
            this.save("Oracle", "BINARY_DOUBLE", "getDouble", "");
            this.save("Oracle", "BINARY_FLOAT", "getFloat", "");
            this.save("Oracle", "DATE", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
            this.save("Oracle", "TIMESTAMP", "getTimestamp", "");
            this.save("Oracle", "TIMESTAMPTZ", "getString", "");
            this.save("Oracle", "TIMESTAMPLTZ", "", "jdbcacsess.sql.column.GetColumnOracleTIMESTAMPLTZ");
            this.save("MySQL", "BIT", "", "jdbcacsess.sql.column.GetColumnBytesOrBinaryStream");
            this.save("MySQL", "DATETIME", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
            this.save("MySQL", "TIMESTAMP", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
            this.save("MySQL", "YEAR", "", "jdbcacsess.sql.column.GetColumnDateYYYY");
            this.save("PostgreSQL", "bit", "getString", "");
            this.save("PostgreSQL", "cidr", "getString", "");
            this.save("PostgreSQL", "inet", "getString", "");
            this.save("PostgreSQL", "interval", "getString", "");
            this.save("PostgreSQL", "macaddr", "getString", "");
            this.save("PostgreSQL", "timestamptz", "getString", "");
            this.save("PostgreSQL", "varbit", "getString", "");
        }
    }

    private void save(String dbms, String type, String method, String cls) {
        this.setKey(dbms, type);
        this.setResultSetMethodName(method);
        this.setGetResultSetClassName(cls);
        this.currentDataSave();
    }

    @Override
    public void addToElement(Element element) {
        element.setAttribute("dbms", this.getDbms());
        element.setAttribute("type", this.getType());
        element.setAttribute("getResultSetClassName", this.getGetResultSetClassName());
        element.setAttribute("methodName", this.getResultSetMethodName());
        element.setAttribute("cellRendererClassName", this.getCellRendererClassName());
        element.setAttribute("cellEditorClassName", this.getCellEditorClassName());
        element.setAttribute("enable", this.getEnable().toString());
    }

    @Override
    protected String getBaseTagName() {
        return BASETABNAME;
    }

    public Class getCellEditorClass() throws ClassNotFoundException {
        if (this.cellEditorClassName.equals("")) {
            return null;
        }
        return Class.forName(this.cellEditorClassName);
    }

    public String getCellEditorClassName() {
        return this.cellEditorClassName;
    }

    public Class getCellRendererClass() throws ClassNotFoundException {
        if (this.cellRendererClassName.equals("")) {
            return null;
        }
        return Class.forName(this.cellRendererClassName);
    }

    public String getCellRendererClassName() {
        return this.cellRendererClassName;
    }

    public String getDbms() {
        return this.dbms;
    }

    public Class getGetResultSetClass() throws ClassNotFoundException {
        if (this.getResultSetClassName.equals("")) {
            return null;
        }
        return Class.forName(this.getResultSetClassName);
    }

    public String getGetResultSetClassName() {
        return this.getResultSetClassName;
    }

    @Override
    protected SqlMappingInfo getInstance() {
        return new SqlMappingInfo();
    }

    @Override
    public String getKeyValue() {
        return SqlMappingInfo.editKey(this.getDbms(), this.getType());
    }

    public Method getResultSetMethod() throws SecurityException, NoSuchMethodException {
        if (this.getResultSetMethodName().equals("")) {
            return null;
        }
        Method rtn = ResultSet.class.getMethod(this.getResultSetMethodName(), Integer.TYPE);
        return rtn;
    }

    public String getResultSetMethodName() {
        return this.resultSetMethodName;
    }

    public String getType() {
        return this.type;
    }

    public void setCellEditorClassName(String cellEditorClass) {
        this.cellEditorClassName = cellEditorClass;
    }

    public void setCellRendererClassName(String cellRendererClass) {
        this.cellRendererClassName = cellRendererClass;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    @Override
    public void setFromElement(Element element) {
        this.setDbms(element.getAttribute("dbms"));
        this.setType(element.getAttribute("type"));
        this.setGetResultSetClassName(element.getAttribute("getResultSetClassName"));
        this.setResultSetMethodName(element.getAttribute("methodName"));
        this.setCellRendererClassName(element.getAttribute("cellRendererClassName"));
        this.setCellEditorClassName(element.getAttribute("cellEditorClassName"));
        this.setEnable(new Boolean(element.getAttribute("enable")));
    }

    public void setGetResultSetClassName(String getResultSetClass) {
        this.getResultSetClassName = getResultSetClass;
    }

    @Override
    protected void setKeyValue(String key) {
        StringTokenizer st = new StringTokenizer(key, "#$#");
        if (st.hasMoreTokens()) {
            this.setDbms(st.nextToken());
            if (st.hasMoreTokens()) {
                this.setType(st.nextToken());
            }
        }
    }

    public void setKey(String dbms, String type) {
        this.setDbms(dbms);
        this.setType(type);
    }

    public void setResultSetMethodName(String method) {
        this.resultSetMethodName = method;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }
}

