/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.JFrameResultSetMD;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.SqlMappingInfo;
import jdbcacsess.sql.column.CellEditorBinary;
import jdbcacsess.sql.column.CellRendererSqlTableArray;
import jdbcacsess.sql.column.GetColumnBinary;
import jdbcacsess.sql.column.GetColumnBlob;
import jdbcacsess.sql.column.GetColumnBytesOrBinaryStream;
import jdbcacsess.sql.column.GetColumnResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecuteBase {
    private int cnt;
    private ResultSet rs = null;
    private Statement stmt = null;
    private Object source;
    private SqlAnalyze sqlAnalyze;
    private Connection con = null;
    private Vector<ColumnInfoResult> selectColmunInfos;
    private ArrayList<QueryExecuteListener> listeners = new ArrayList();
    private int binaryDataSize;
    private Map<String, SqlMappingInfo> sqlMapping;
    private static Map<String, Class<?>> primitiveMap = new HashMap();
    Vector<Object> rowData;

    static {
        primitiveMap.put("byte", Byte.class);
        primitiveMap.put("short", Short.class);
        primitiveMap.put("int", Integer.class);
        primitiveMap.put("long", Long.class);
        primitiveMap.put("float", Float.class);
        primitiveMap.put("double", Double.class);
        primitiveMap.put("char", Character.class);
        primitiveMap.put("boolean", Boolean.class);
    }

    protected QueryExecuteBase(Object source, SqlAnalyze sqlAnalyze, Connection con, int binaryDataSize) {
        this.source = source;
        this.sqlAnalyze = sqlAnalyze;
        this.con = con;
        this.binaryDataSize = binaryDataSize;
        this.sqlMapping = new SqlMappingInfo().getInfoMap();
    }

    public void addQueryExecuteListener(QueryExecuteListener listener) {
        this.listeners.add(listener);
    }

    protected void initProc() throws Exception {
        this.cnt = 0;
        for (QueryExecuteListener listener : this.listeners) {
            listener.init();
        }
        this.openSqlCursor(this.sqlAnalyze.getSqlStatement());
        this.sqlAnalyze.setSelectColmunInfo(this.selectColmunInfos);
        for (QueryExecuteListener listener : this.listeners) {
            listener.setResultHeader(this.selectColmunInfos, this.sqlAnalyze);
        }
    }

    protected void resultProc() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException, IOException {
        this.getQueryReslut();
        for (QueryExecuteListener listener : this.listeners) {
            listener.setResultDetail(this.rowData);
        }
    }

    protected boolean queryNext() throws SQLException {
        if (this.rs == null) {
            return false;
        }
        if (this.rs.next()) {
            return true;
        }
        this.closeSqlCursor();
        return false;
    }

    protected void endProc(boolean runner, boolean err) {
        QueryExecuteStatus bs = new QueryExecuteStatus(this.source, this.cnt, runner, this.sqlAnalyze, err);
        for (QueryExecuteListener listener : this.listeners) {
            listener.completeQuery(bs);
        }
        try {
            this.closeSqlCursor();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void errorProc(Exception e) {
        e.printStackTrace();
        for (QueryExecuteListener listener : this.listeners) {
            listener.errorException(e);
        }
    }

    protected void statusProc(boolean runner, boolean err) {
        for (QueryExecuteListener listener : this.listeners) {
            listener.status(new QueryExecuteStatus(this.source, this.cnt, runner, this.sqlAnalyze, err));
        }
    }

    private void openSqlCursor(String sqlStatement) throws Exception {
        this.selectColmunInfos = new Vector();
        this.stmt = this.con.createStatement();
        this.rs = this.stmt.executeQuery(sqlStatement);
        int col = this.rs.getMetaData().getColumnCount();
        ResultSetMetaData rsm = this.rs.getMetaData();
        int i = 1;
        while (i <= col) {
            TableCellRenderer tableCellRenderer = null;
            TableCellEditor tableCellEditor = null;
            Class<Object> columnClass = null;
            GetColumnResultSet getColumnResultSet = null;
            Method method = null;
            String key = SqlMappingInfo.editKey(SqlExec.getDatabaseProductName(), rsm.getColumnTypeName(i));
            SqlMappingInfo smi = this.sqlMapping.get(key);
            if (smi != null && smi.getEnable().booleanValue()) {
                Constructor c;
                if (smi.getGetResultSetClass() != null) {
                    method = null;
                    columnClass = smi.getGetResultSetClass();
                } else {
                    method = smi.getResultSetMethod();
                    columnClass = method.getReturnType();
                }
                if (smi.getCellRendererClass() != null) {
                    c = smi.getCellRendererClass().getConstructor(new Class[0]);
                    tableCellRenderer = (TableCellRenderer)c.newInstance(new Object[0]);
                }
                if (smi.getCellEditorClass() != null) {
                    c = smi.getCellEditorClass().getConstructor(new Class[0]);
                    tableCellEditor = (TableCellEditor)c.newInstance(new Object[0]);
                }
            } else if (this.isBinary(i) || GetColumnBinary.isBinaryType(rsm.getColumnType(i))) {
                columnClass = rsm.getColumnType(i) == 2004 ? GetColumnBlob.class : GetColumnBytesOrBinaryStream.class;
            } else {
                try {
                    columnClass = Class.forName(this.getResultSetClassName(i));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    columnClass = Object.class;
                }
            }
            if (Array.class.isAssignableFrom(columnClass)) {
                tableCellRenderer = new CellRendererSqlTableArray();
            }
            if (GetColumnBinary.class.isAssignableFrom(columnClass)) {
                tableCellEditor = new CellEditorBinary();
            }
            if (columnClass == GetColumnBlob.class) {
                getColumnResultSet = new GetColumnBlob(this.binaryDataSize);
            } else if (columnClass == GetColumnBytesOrBinaryStream.class) {
                getColumnResultSet = new GetColumnBytesOrBinaryStream(this.binaryDataSize);
            } else if (GetColumnResultSet.class.isAssignableFrom(columnClass)) {
                getColumnResultSet = (GetColumnResultSet)columnClass.newInstance();
            }
            if (columnClass.isPrimitive() && !columnClass.isArray()) {
                String str = columnClass.getName();
                columnClass = primitiveMap.get(str);
            }
            ColumnInfoResult colInfo = new ColumnInfoResult(i, rsm.getColumnName(i), rsm.getColumnType(i), rsm.getColumnTypeName(i), rsm.isNullable(i), columnClass, rsm.getPrecision(i), rsm.getScale(i));
            colInfo.setCellTableInfo(tableCellRenderer, tableCellEditor, getColumnResultSet, method);
            this.selectColmunInfos.add(colInfo);
            ++i;
        }
        this.rowData = new Vector(this.selectColmunInfos.size());
    }

    private boolean isBinary(int i) throws SQLException {
        String name = this.getResultSetClassName(i);
        return name.equals("byte[]") || name.equals("[B");
    }

    private void getQueryReslut() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException {
        ++this.cnt;
        this.rowData.clear();
        int i = 1;
        while (i <= this.rs.getMetaData().getColumnCount()) {
            if (JFrameMain.debugMode && this.cnt == 1) {
                JFrameResultSetMD a = JFrameResultSetMD.getInstance();
                a.setData(this.rs);
            }
            try {
                if (this.rs.getMetaData().getColumnType(i) == 2005 || this.selectColmunInfos.get(i - 1).getColumnClass() == Reader.class) {
                    Clob clob = this.rs.getClob(i);
                    if (!this.isAddNull(this.rowData, clob)) {
                        this.rowData.add(clob.getSubString(1L, (int)clob.length()));
                    }
                } else {
                    GetColumnResultSet gcrs = this.selectColmunInfos.get(i - 1).getGetColumnResultSet();
                    if (gcrs != null) {
                        this.rowData.add(gcrs.getData(this.rs, i));
                    } else {
                        Object obj;
                        Method method = this.selectColmunInfos.get(i - 1).getMethodOfResultSet();
                        if (method != null) {
                            obj = method.invoke((Object)this.rs, i);
                            if (!this.isAddNull(this.rowData, obj)) {
                                this.rowData.add(obj);
                            }
                        } else {
                            obj = this.rs.getObject(i);
                            if (!this.isAddNull(this.rowData, obj)) {
                                this.rowData.add(obj);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                this.rowData.add(new JdbcacsessException(e));
            }
            ++i;
        }
    }

    private boolean isAddNull(Vector<Object> rowData, Object data) throws SQLException {
        if (this.rs.wasNull() || data == null) {
            rowData.add(null);
            return true;
        }
        return false;
    }

    private void closeSqlCursor() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    private String getResultSetClassName(int i) throws SQLException {
        String s = this.rs.getMetaData().getColumnClassName(i);
        if (s == null) {
            return "java.lang.Object";
        }
        return s;
    }
}

