/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui.cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jdbcacsess.gui.cell.ExceptionNoimplements;
import jdbcacsess.gui.cell.JTableHexViewerModel;
import jdbcacsess.gui.cell.OutputHandler;
import jdbcacsess.gui.common.ColumnWidth;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JFrameBase;
import jdbcacsess.gui.common.JPopupMenuNoEdit;

public class JFrameViewerHex
extends JFrameBase
implements OutputHandler,
ClipboardOwner {
    private static final long serialVersionUID = -6595776140691157849L;
    private static final String TITLE = "\uff11\uff16\u9032\u30c0\u30f3\u30d7";
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTableHexViewer = null;
    private static JFrameViewerHex jFrameViewer = null;
    private JTableHexViewerModel model;
    private InputStream is;
    private JLabel jLabel = null;
    private long dataSize = -1L;

    public static JFrameViewerHex getInstance() {
        if (jFrameViewer == null) {
            jFrameViewer = new JFrameViewerHex();
        }
        return jFrameViewer;
    }

    private JFrameViewerHex() {
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(TITLE);
        this.setSize(new Dimension(600, 400));
        super.init();
        JPopupMenuNoEdit jpmne = new JPopupMenuNoEdit(this.jTableHexViewer);
        jpmne.SelectAllAddActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameViewerHex.this.jTableHexViewer.selectAll();
            }
        });
        jpmne.CopyAddActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameViewerHex.this.copyToClipbord();
            }
        });
    }

    private void copyToClipbord() {
        String lineSeparator = System.getProperty("line.separator");
        int countCol = this.jTableHexViewer.getColumnCount();
        int countRow = this.jTableHexViewer.getSelectedRowCount();
        int[] selRows = this.jTableHexViewer.getSelectedRows();
        StringBuffer selectString = new StringBuffer();
        int idxCol = 0;
        while (idxCol < countCol) {
            if (idxCol != 0) {
                selectString.append('\t');
            }
            selectString.append(this.model.getColumnName(idxCol));
            ++idxCol;
        }
        selectString.append(lineSeparator);
        int idxRow = 0;
        while (idxRow < countRow) {
            StringBuffer line = new StringBuffer();
            int idxCol2 = 0;
            while (idxCol2 < countCol) {
                Object o = this.jTableHexViewer.getValueAt(selRows[idxRow], idxCol2);
                if (o != null) {
                    if (idxCol2 != 0) {
                        line.append('\t');
                    }
                    line.append(o.toString());
                }
                ++idxCol2;
            }
            selectString.append(line).append(lineSeparator);
            ++idxRow;
        }
        this.getToolkit().getSystemClipboard().setContents(new StringSelection(selectString.toString()), null);
    }

    public void frameClosing() {
        jFrameViewer = null;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        if (this.model != null) {
            this.model.clear();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("JLabel");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.jLabel, "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableHexViewer());
        }
        return this.jScrollPane;
    }

    private JTable getJTableHexViewer() {
        if (this.jTableHexViewer == null) {
            this.jTableHexViewer = new JTable();
            this.jTableHexViewer.setCellSelectionEnabled(true);
            this.jTableHexViewer.setColumnSelectionAllowed(false);
            this.jTableHexViewer.getTableHeader().setReorderingAllowed(false);
        }
        return this.jTableHexViewer;
    }

    public void output() {
        this.model = new JTableHexViewerModel(this.is, this.dataSize, this);
        this.jTableHexViewer.setModel(this.model);
        this.jTableHexViewer.getColumnModel().getColumn(0).setCellRenderer(this.jTableHexViewer.getTableHeader().getDefaultRenderer());
        ColumnWidth.setHeaderWidthResizeOff(this.jTableHexViewer, 7);
        int w = this.jTableHexViewer.getColumn("0F").getPreferredWidth();
        this.jTableHexViewer.getColumn("0F").setPreferredWidth((int)((double)w * 1.5));
        this.setVisible(true);
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
        String msg = "";
        if (dataSize == -1L) {
            msg = "\u5168\u4f53\u30d0\u30a4\u30c8\u6570\u306f\u4e0d\u660e\u3067\u3059";
        } else {
            long kByte = dataSize / 1024L;
            msg = String.valueOf(dataSize) + "\u30d0\u30a4\u30c8 " + (kByte > 0L ? "(" + dataSize / 1024L + "KB)" : "");
            msg = String.valueOf(msg) + "   0x" + Long.toHexString(dataSize).toUpperCase() + "\u30d0\u30a4\u30c8 " + (kByte > 0L ? "(0x" + Long.toHexString(dataSize / 1024L).toUpperCase() + "KB)" : "");
        }
        this.jLabel.setText(msg);
    }

    public void setInputStream(InputStream is) {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        this.is = is;
    }

    public void setReader(Reader r) {
        throw new ExceptionNoimplements();
    }

    public void setDataSource(String sqlStatement) {
        this.setTitle("\uff11\uff16\u9032\u30c0\u30f3\u30d7 [" + sqlStatement + "]");
    }

    public void setOutputFile(File file) {
        throw new ExceptionNoimplements();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

