/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jdbcacsess.PrefixStringBuffer;
import jdbcacsess.createdata.JFrameCreateDataSetting;
import jdbcacsess.gui.CellRendererDataBaseObject;
import jdbcacsess.gui.JFrameCreateSqlFromTree;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JPopupMenuCnageUI;
import jdbcacsess.gui.common.PopupKeybordAndMouse;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeDataBaseObjects
extends JTree
implements Observer {
    private static final long serialVersionUID = -294660305476207747L;
    private DefaultMutableTreeNode defaultMutableTreeNode;
    private JTextPaneSqlStatement sqlStatement;
    private JPopupMenuCnageUI jPopupMenuTable = null;
    private JMenuItem jMenuItemOrderPrimeKey = null;
    private JMenuItem jMenuItemNoOrder = null;
    private JMenuItem jMenuItemTreeUpdate = null;
    private DefaultTreeModel treeModel;
    private JMenuItem jMenuItemCreateData = null;
    private JMenuItem jMenuItemName = null;
    private JMenuItem jMenuItemEditSql = null;
    private JFrameCreateSqlFromTree csft = null;

    @Override
    public void update(Observable o, Object sqlStatement) {
        this.sqlStatement = (JTextPaneSqlStatement)sqlStatement;
        if (this.csft != null) {
            this.csft.setSqlStatement(this.sqlStatement);
        }
    }

    public JTreeDataBaseObjects() {
        this.initialize();
    }

    private void initialize() {
        this.setRowHeight(13);
        this.setModel(null);
        this.setToggleClickCount(2);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                if (JTreeDataBaseObjects.this.isTableTreePath(e.getPath())) {
                    JTreeDataBaseObjects.this.expandColumnName(e.getPath());
                }
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 2) {
                    JTreeDataBaseObjects.this.transColumnName(JTreeDataBaseObjects.this.getSelectionPaths());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
            }
        });
        this.setCellRenderer(new CellRendererDataBaseObject());
        new PopupKeybordAndMouse(this, (JPopupMenu)this.getJPopupMenuTable());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.jPopupMenuTable.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                if (JTreeDataBaseObjects.this.getSelectionCount() == 0) {
                    JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemName.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(false);
                    return;
                }
                JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemName.setEnabled(true);
                JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(true);
                boolean tblFlg = false;
                boolean colFlg = false;
                TreePath[] treePathArray = JTreeDataBaseObjects.this.getSelectionPaths();
                int n = 0;
                int n2 = treePathArray.length;
                while (n < n2) {
                    TreePath tp = treePathArray[n];
                    if (JTreeDataBaseObjects.this.isTableTreePath(tp)) {
                        tblFlg = true;
                    }
                    if (JTreeDataBaseObjects.this.isColumnTreePath(tp)) {
                        colFlg = true;
                    }
                    ++n;
                }
                if (!(tblFlg | colFlg)) {
                    JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemName.setEnabled(false);
                }
                if (!tblFlg) {
                    JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(false);
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }
        });
    }

    private String transColumnName(TreePath treePath) {
        String selectItem = "";
        if (this.isTableTreePath(treePath)) {
            selectItem = this.getObjectName(treePath);
        }
        if (this.isColumnTreePath(treePath)) {
            selectItem = this.getObjectNamePrefixParent(treePath);
        }
        return selectItem;
    }

    protected void transColumnName(TreePath[] treePaths) {
        if (treePaths == null) {
            return;
        }
        PrefixStringBuffer psb = new PrefixStringBuffer(" ", ", ");
        int i = 0;
        while (i < treePaths.length) {
            psb.appendItem(this.transColumnName(treePaths[i]));
            ++i;
        }
        this.sqlStatement.insertCurrentPosition(psb.getString());
    }

    private String getObjectNamePrefixParent(TreePath treePath) {
        DefaultMutableTreeNode symbolParent = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 2);
        return String.valueOf(symbolParent.getUserObject().toString()) + "." + this.getObjectName(treePath);
    }

    private String getObjectName(TreePath treePath) {
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return symbol.getUserObject().toString();
    }

    private boolean isCatalogTreePath(TreePath treePath) {
        return treePath.getPathCount() == 1;
    }

    private boolean isSchemaTreePath(TreePath treePath) {
        return treePath.getPathCount() == 2;
    }

    private boolean isTableTreePath(TreePath treePath) {
        return treePath.getPathCount() == 3;
    }

    private boolean isColumnTreePath(TreePath treePath) {
        return treePath.getPathCount() == 4;
    }

    private void expandColumnName(TreePath treePath) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode dummyChild = (DefaultMutableTreeNode)symbol.getFirstChild();
        if (dummyChild.getUserObject() != null) {
            return;
        }
        SchemaTableName stn = new SchemaTableName(this.getObjectNamePrefixParent(treePath));
        try {
            ArrayList<String> primKeys = SqlExec.getPrimaryKeys(stn.getSchemaName(), stn.getTableName());
            for (ColumnInfoTable col : SqlExec.getColumnMames(stn.getSchemaName(), stn.getTableName())) {
                DefaultMutableTreeNode columnTreeNode = new DefaultMutableTreeNode(col);
                if (primKeys.contains(col.getColumnName())) {
                    col.setPrimaryKey(true);
                }
                symbol.add(columnTreeNode);
            }
            symbol.remove(dummyChild);
            this.treeModel.reload(symbol);
        }
        catch (SQLException e1) {
            JDialogMessage.sqlErrorDialog(e1, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
        }
    }

    public void setTables() throws SQLException {
        this.defaultMutableTreeNode = new DefaultMutableTreeNode(SqlExec.getCatalog());
        for (String sch : SqlExec.getSchemaNames()) {
            DefaultMutableTreeNode schemaTreeNode = new DefaultMutableTreeNode(sch);
            for (String tbl : SqlExec.getSimpleTableNames(sch)) {
                DefaultMutableTreeNode tableTreeNode = new DefaultMutableTreeNode(tbl);
                tableTreeNode.add(new DefaultMutableTreeNode());
                schemaTreeNode.add(tableTreeNode);
            }
            if (schemaTreeNode.getChildCount() == 0) continue;
            this.defaultMutableTreeNode.add(schemaTreeNode);
        }
        this.treeModel = new DefaultTreeModel(this.defaultMutableTreeNode);
        this.setModel(this.treeModel);
        this.setSelectionRow(0);
    }

    private SchemaTableName getSchemaTable(TreePath tableTreePath) {
        SchemaTableName stn = new SchemaTableName(this.getObjectNamePrefixParent(tableTreePath));
        return stn;
    }

    private ArrayList<SchemaTableName> getSelectSchemaTables() {
        ArrayList<SchemaTableName> list = new ArrayList<SchemaTableName>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            DefaultMutableTreeNode symbol;
            ColumnInfoTable ci;
            SchemaTableName stn;
            TreePath tp = treePathArray[n];
            if (this.isColumnTreePath(tp) && list.indexOf(stn = (ci = (ColumnInfoTable)(symbol = (DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()).getSchemaTableName()) == -1) {
                list.add(stn);
            }
            if (this.isTableTreePath(tp) && list.indexOf(stn = this.getSchemaTable(tp)) == -1) {
                list.add(stn);
            }
            ++n;
        }
        return list;
    }

    private ArrayList<String> getSelectColumns() {
        ArrayList<String> list = new ArrayList<String>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath tp = treePathArray[n];
            if (this.isColumnTreePath(tp)) {
                list.add(this.getObjectNamePrefixParent(tp));
            }
            ++n;
        }
        return list;
    }

    private StringBuffer getSelColumsListPhrase(ArrayList<String> columns) {
        StringBuffer str = new StringBuffer("");
        if (columns.size() == 0) {
            str.append("*");
            return str;
        }
        boolean first = true;
        for (String column : columns) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(column);
        }
        return str;
    }

    private StringBuffer getFromPhrase(ArrayList<SchemaTableName> list) {
        if (list.size() > 2) {
            JOptionPane.showMessageDialog(null, "2\u3064\u4ee5\u4e0a\u306e\u30c6\u30fc\u30d6\u30eb\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f\u3002\nJOIN\u6761\u4ef6\u4f5c\u6210\u3067\u306f\u6700\u521d\u306e2\u30c6\u30fc\u30d6\u30eb\u304c\u6709\u52b9\u3067\u3059");
        }
        StringBuffer str = new StringBuffer("\nFROM ");
        boolean first = true;
        for (SchemaTableName stn : list) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(stn.getCompleteTableName());
        }
        return str;
    }

    private String getWherePhrase(ArrayList<SchemaTableName> list) {
        if (list.size() < 2) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        ArrayList<String> editKey = new ArrayList<String>();
        this.createPrimaryAndColumn(editKey, str, list.get(0), list.get(1));
        this.createPrimaryAndColumn(editKey, str, list.get(1), list.get(0));
        if (editKey.size() == 0) {
            return "";
        }
        return "\nWHERE " + str.substring(5);
    }

    private void createPrimaryAndColumn(ArrayList<String> editKey, StringBuffer str, SchemaTableName primStn, SchemaTableName colStn) {
        ArrayList<String> primList = null;
        ArrayList<ColumnInfoTable> colList = null;
        try {
            primList = SqlExec.getPrimaryKeys(primStn.getSchemaName(), primStn.getTableName());
            colList = SqlExec.getColumnMames(colStn.getSchemaName(), colStn.getTableName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (ColumnInfoTable col : colList) {
            for (String prim : primList) {
                if (!col.getColumnName().equals(prim) || editKey.contains(col.getColumnName())) continue;
                str.append(" AND " + primStn.getTableName() + "." + prim + " = " + colStn.getTableName() + "." + col.getColumnName());
                editKey.add(col.getColumnName());
            }
        }
    }

    private StringBuffer getOrdeByPhrase(ArrayList<SchemaTableName> list) {
        StringBuffer text = new StringBuffer();
        boolean first = true;
        for (SchemaTableName stn : list) {
            try {
                for (String key : SqlExec.getPrimaryKeys(stn.getSchemaName(), stn.getTableName())) {
                    if (first) {
                        first = false;
                        text.append("\nORDER BY ");
                    } else {
                        text.append(", ");
                    }
                    text.append(stn.getTableName()).append(".").append(key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return text;
    }

    private void actionPerformedSelect(boolean isOrderBy) {
        if (this.sqlStatement == null) {
            return;
        }
        ArrayList<SchemaTableName> schemaTables = this.getSelectSchemaTables();
        ArrayList<String> columns = this.getSelectColumns();
        StringBuffer text = new StringBuffer("SELECT ");
        text.append(this.getSelColumsListPhrase(columns));
        text.append(this.getFromPhrase(schemaTables));
        text.append(this.getWherePhrase(schemaTables));
        if (isOrderBy) {
            text.append(this.getOrdeByPhrase(schemaTables));
        }
        text.append("\n");
        this.sqlStatement.setText(text.toString());
        this.sqlStatement.requestFocus();
    }

    private JPopupMenuCnageUI getJPopupMenuTable() {
        if (this.jPopupMenuTable == null) {
            this.jPopupMenuTable = new JPopupMenuCnageUI();
            this.jPopupMenuTable.add(this.getJMenuItemOrderPrimeKey());
            this.jPopupMenuTable.add(this.getJMenuItemNoOrder());
            this.jPopupMenuTable.add(this.getJMenuItemEditSql());
            this.jPopupMenuTable.add(this.getJMenuItemName());
            this.jPopupMenuTable.addSeparator();
            this.jPopupMenuTable.add(this.getJMenuItemCreateData());
            this.jPopupMenuTable.addSeparator();
            this.jPopupMenuTable.add(this.getJMenuItemTreeUpdate());
        }
        return this.jPopupMenuTable;
    }

    private JMenuItem getJMenuItemOrderPrimeKey() {
        if (this.jMenuItemOrderPrimeKey == null) {
            this.jMenuItemOrderPrimeKey = new JMenuItem();
            this.jMenuItemOrderPrimeKey.setText("\u5168\u4ef6\u691c\u7d22\u6587\uff08\u4e3b\u30ad\u30fc\u9806\uff09");
            this.jMenuItemOrderPrimeKey.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(true);
                }
            });
        }
        return this.jMenuItemOrderPrimeKey;
    }

    private JMenuItem getJMenuItemNoOrder() {
        if (this.jMenuItemNoOrder == null) {
            this.jMenuItemNoOrder = new JMenuItem();
            this.jMenuItemNoOrder.setText("\u5168\u4ef6\u691c\u7d22\u6587\uff08\u7121\u6307\u5b9a\u9806\uff09");
            this.jMenuItemNoOrder.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(false);
                }
            });
        }
        return this.jMenuItemNoOrder;
    }

    private JMenuItem getJMenuItemTreeUpdate() {
        if (this.jMenuItemTreeUpdate == null) {
            this.jMenuItemTreeUpdate = new JMenuItem();
            this.jMenuItemTreeUpdate.setText("\u5b9a\u7fa9\u518d\u53d6\u8fbc");
            this.jMenuItemTreeUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JTreeDataBaseObjects.this.setTables();
                    }
                    catch (SQLException e1) {
                        JDialogMessage.sqlErrorDialog(e1, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
                    }
                }
            });
        }
        return this.jMenuItemTreeUpdate;
    }

    private JMenuItem getJMenuItemCreateData() {
        if (this.jMenuItemCreateData == null) {
            this.jMenuItemCreateData = new JMenuItem();
            this.jMenuItemCreateData.setText("\u30c7\u30fc\u30bf\u751f\u6210\u2026");
            this.jMenuItemCreateData.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedCreateData(e);
                }
            });
        }
        return this.jMenuItemCreateData;
    }

    private void actionPerformedCreateData(ActionEvent e) {
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath path = treePathArray[n];
            if (this.isTableTreePath(path)) {
                JFrameCreateDataSetting dlg = new JFrameCreateDataSetting(this.getSchemaTable(path));
                dlg.setVisible(true);
            }
            ++n;
        }
    }

    private JMenuItem getJMenuItemName() {
        if (this.jMenuItemName == null) {
            this.jMenuItemName = new JMenuItem();
            this.jMenuItemName.setText("\u5b9a\u7fa9\u540d\u3000\u3000\u3000\u3000\u3000\u4e2d\u30dc\u30bf\u30f3");
            this.jMenuItemName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.transColumnName(JTreeDataBaseObjects.this.getSelectionPaths());
                }
            });
        }
        return this.jMenuItemName;
    }

    private JMenuItem getJMenuItemEditSql() {
        if (this.jMenuItemEditSql == null) {
            this.jMenuItemEditSql = new JMenuItem();
            this.jMenuItemEditSql.setText("\u691c\u7d22\u6587\u751f\u6210\u2026");
            this.jMenuItemEditSql.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedEditSql();
                }
            });
        }
        return this.jMenuItemEditSql;
    }

    protected void actionPerformedEditSql() {
        if (this.csft == null) {
            this.csft = new JFrameCreateSqlFromTree();
            this.csft.setSqlStatement(this.sqlStatement);
        }
        TreePath[] tps = this.getSelectionPaths();
        TreeMap<SchemaTableName, ArrayList<ColumnInfoTable>> map = new TreeMap<SchemaTableName, ArrayList<ColumnInfoTable>>();
        int i = 0;
        while (i < tps.length) {
            if (this.isTableTreePath(tps[i])) {
                SchemaTableName stn = this.getSchemaTable(tps[i]);
                if (map.get(stn) == null) {
                    map.put(stn, new ArrayList());
                }
            } else if (this.isColumnTreePath(tps[i])) {
                DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)tps[i].getPathComponent(tps[i].getPathCount() - 1);
                SchemaTableName parent = this.getSchemaTable(tps[i].getParentPath());
                ArrayList<ColumnInfoTable> list = map.get(parent);
                if (list == null) {
                    list = new ArrayList();
                    map.put(parent, list);
                }
                list.add((ColumnInfoTable)symbol.getUserObject());
            }
            ++i;
        }
        this.csft.setTablemap(map);
        this.csft.setVisible(true);
    }
}

