/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jdbcacsess.csv.CsvExport;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.gui.ComanndBuffer;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.JTableSql;
import jdbcacsess.gui.JTableSqlModel;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.TabWinManager;
import jdbcacsess.gui.common.ActionBase;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.QueryExecute;
import jdbcacsess.sql.QueryExecuteAdapter;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.SqlStatementCatgoly;

public class JPanelExecSql
extends JPanel {
    private static final long serialVersionUID = -2404983650883644746L;
    private ComanndBuffer cmdBuff;
    private JTableSqlModel jTableSqlModel;
    private JButton jButtonCsvExport = null;
    private JButton jButtonClear = null;
    private JButton jButtonExecSql = null;
    private JButton jButtonNext = null;
    private JButton jButtonPrev = null;
    private JButton jButtonSelectAbort = null;
    private JButton jButtonSelectContinue = null;
    private JLabel jLabelPageNo = null;
    private JPanel jPanelCommand = null;
    private JPanel jPanelSalStatement = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanelSqlInput = null;
    private JScrollPane jScrollPaneResults = null;
    private JTableSql jTableResults = null;
    private JTextPaneSqlStatement jTextPaneSqlStatement = null;
    private QueryExecute queryExecute;
    private JScrollPane jScrollPane = null;
    private JLabel jLabelMessage = null;
    private JButton jButtonClose = null;
    private TabWinManager parent = null;
    private Connection execSqlConnection;
    private JButton jButtonCommit = null;
    private JButton jButtonRollBack = null;
    private String paneName;
    private boolean autoCommit;
    private JPanel jPanelMessage = null;
    private JLabel jLabelLocation = null;
    private JPanelExecSql myself = this;
    private ActionExecSql actionExecSql;
    private ActionCsvExport actionCsvExport;
    private ActionSelectContinue actionSelectContinue;
    private ActionSelectAbort actionSelectAbort;

    public JPanelExecSql(TabWinManager parent, boolean autoCommit) {
        this.parent = parent;
        this.autoCommit = autoCommit;
        this.myself = this;
        this.actionExecSql = new ActionExecSql();
        this.actionCsvExport = new ActionCsvExport();
        this.actionSelectContinue = new ActionSelectContinue();
        this.actionSelectAbort = new ActionSelectAbort();
        this.initialize();
        if (autoCommit) {
            this.jButtonCommit.setEnabled(false);
            this.jButtonRollBack.setEnabled(false);
        } else {
            this.jButtonCommit.setEnabled(true);
            this.jButtonRollBack.setEnabled(true);
        }
        this.paneName = "";
    }

    private void initialize() {
        this.getJSplitPane();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        this.add((Component)this.getJSplitPane(), "Center");
        this.add((Component)this.getJPanelMessage(), "South");
        this.add((Component)this.getJPanelCommand(), "North");
        this.cmdBuff = new ComanndBuffer();
        this.displayIdx();
        this.jTextPaneSqlStatement.insertMenuItem(this.getJMenu(), 0);
        this.jTextPaneSqlStatement.insertMenuItem(new JPopupMenu.Separator(), 1);
        this.jTableResults.insertMenuItem(this.getJMenu(), 0);
        this.jTableResults.insertMenuItem(new JPopupMenu.Separator(), 1);
    }

    JMenu getJMenu() {
        JMenu rtn = new JMenu("SQL");
        rtn.add(new JMenuItem(this.actionExecSql));
        rtn.add(new JMenuItem(this.actionCsvExport));
        rtn.add(new JMenuItem(this.actionSelectContinue));
        rtn.add(new JMenuItem(this.actionSelectAbort));
        return rtn;
    }

    public JTextPaneSqlStatement getSqlStatement() {
        return this.jTextPaneSqlStatement;
    }

    private void setMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelExecSql.this.jLabelMessage.setText(msg);
            }
        });
        Logger.global.fine(msg);
    }

    private void resetButton() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelExecSql.this.actionSelectAbort.setEnabled(false);
                JPanelExecSql.this.actionSelectContinue.setEnabled(false);
                JPanelExecSql.this.actionCsvExport.setEnabled(true);
                JPanelExecSql.this.actionExecSql.setEnabled(true);
            }
        });
    }

    private void displayIdx() {
        this.jLabelPageNo.setText("\u5c65\u6b74[" + (this.cmdBuff.getIdx() + 1) + "/" + this.cmdBuff.size() + "]");
    }

    private void actionPerformedClear(ActionEvent e) {
        this.jTextPaneSqlStatement.setText("");
    }

    void actionPerformedNext(ActionEvent e) {
        this.jTextPaneSqlStatement.setText(this.cmdBuff.next());
        this.displayIdx();
    }

    void actionPerformedPrev(ActionEvent e) {
        this.jTextPaneSqlStatement.setText(this.cmdBuff.prev());
        this.displayIdx();
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setDividerSize(7);
            this.jSplitPane.setDividerLocation(120);
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setTopComponent(this.getJPanelSqlInput());
            this.jSplitPane.setBottomComponent(this.getJScrollPaneResults());
        }
        return this.jSplitPane;
    }

    private JButton getJButtonClear() {
        if (this.jButtonClear == null) {
            this.jButtonClear = new JButton();
            this.jButtonClear.setText("\u30af\u30ea\u30a2");
            this.jButtonClear.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonClear.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059");
            this.jButtonClear.setFont(new Font("Dialog", 0, 12));
            this.jButtonClear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedClear(e);
                }
            });
        }
        return this.jButtonClear;
    }

    private JButton getJButtonExecSql() {
        if (this.jButtonExecSql == null) {
            this.jButtonExecSql = new JButton(this.actionExecSql);
            this.jButtonExecSql.setText(this.actionExecSql.getName());
            this.jButtonExecSql.setHorizontalAlignment(2);
            this.jButtonExecSql.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonExecSql.setToolTipText("<HTML>\u5165\u529b\u3055\u308c\u305fSQL\u6587\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002<BR>\u691c\u7d22\u7cfb\u306e\u5834\u5408\u306fSwing\u3068\u7570\u306a\u308b\u30b9\u30ec\u30c3\u30c9\u3067\u5b9f\u884c\u3068\u7d50\u679c\u53d6\u5f97\u304c\u884c\u308f\u308c\u3001\u691c\u7d22\u7d50\u679c\u3092\u9806\u6b21\u753b\u9762\u8868\u793a\u3057\u307e\u3059<BR>\u66f4\u65b0\u7cfb\u306e\u5834\u5408\u306fSwing\u3068\u540c\u4e00\u30b9\u30ec\u30c3\u30c9\u3067\u5b9f\u884c\u3055\u308c\u3001\u66f4\u65b0\u30c7\u30fc\u30bf\u306f\u8868\u793a\u3057\u307e\u305b\u3093</HTML>");
            this.jButtonExecSql.setFont(new Font("Dialog", 0, 12));
        }
        return this.jButtonExecSql;
    }

    private JButton getJButtonCsvExport() {
        if (this.jButtonCsvExport == null) {
            this.jButtonCsvExport = new JButton(this.actionCsvExport);
            this.jButtonCsvExport.setText(this.actionCsvExport.getName());
            this.jButtonCsvExport.setHorizontalAlignment(10);
            this.jButtonCsvExport.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonCsvExport.setToolTipText("\u5165\u529b\u3055\u308c\u305f\u691c\u7d22SQL\u6587\u3092\u5b9f\u884c\u3057\u3001\u7d50\u679c\u3092CSV\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u307e\u3059\u3002\u753b\u9762\u306f\u66f4\u65b0\u3055\u308c\u307e\u305b\u3093");
            this.jButtonCsvExport.setFont(new Font("Dialog", 0, 12));
        }
        return this.jButtonCsvExport;
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setText("\uff1e");
            this.jButtonNext.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonNext.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u3092\u672a\u6765\u65b9\u5411\u306b\u9032\u3081\u3066\u8868\u793a\u3057\u307e\u3059");
            this.jButtonNext.setFont(new Font("Dialog", 0, 12));
            this.jButtonNext.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedNext(e);
                }
            });
        }
        return this.jButtonNext;
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setText("\uff1c");
            this.jButtonPrev.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonPrev.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u3092\u904e\u53bb\u65b9\u5411\u306b\u9061\u3063\u3066\u8868\u793a\u3057\u307e\u3059");
            this.jButtonPrev.setFont(new Font("Dialog", 0, 12));
            this.jButtonPrev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedPrev(e);
                }
            });
        }
        return this.jButtonPrev;
    }

    private JButton getJButtonSelectAbort() {
        if (this.jButtonSelectAbort == null) {
            this.jButtonSelectAbort = new JButton(this.actionSelectAbort);
            this.jButtonSelectAbort.setText(this.actionSelectAbort.getName());
            this.jButtonSelectAbort.setFont(new Font("Dialog", 0, 12));
            this.jButtonSelectAbort.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonSelectAbort.setToolTipText("\u5927\u91cf\u691c\u7d22\u7d50\u679c\u306e\u70ba\u53d6\u5f97\u3092\u4e2d\u65ad\u3057\u3066\u3044\u308b\u6642\u306b\u4e2d\u6b62\u3057\u307e\u3059");
            this.actionSelectAbort.setEnabled(false);
        }
        return this.jButtonSelectAbort;
    }

    private JButton getJButtonSelectContinue() {
        if (this.jButtonSelectContinue == null) {
            this.jButtonSelectContinue = new JButton(this.actionSelectContinue);
            this.jButtonSelectContinue.setText(this.actionSelectContinue.getName());
            this.jButtonSelectContinue.setFont(new Font("Dialog", 0, 12));
            this.jButtonSelectContinue.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonSelectContinue.setToolTipText("\u5927\u91cf\u691c\u7d22\u7d50\u679c\u306e\u70ba\u4e2d\u65ad\u3057\u3066\u3044\u308b\u6642\u306b\u7d9a\u304d\u3092\u53d6\u5f97\u3057\u307e\u3059");
            this.actionSelectContinue.setEnabled(false);
        }
        return this.jButtonSelectContinue;
    }

    private JLabel getJLabelPageNo() {
        if (this.jLabelPageNo == null) {
            this.jLabelPageNo = new JLabel();
            this.jLabelPageNo.setFont(new Font("Dialog", 0, 12));
            this.jLabelPageNo.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u306e\u73fe\u5728\u4f4d\u7f6e\u3067\u3059\u3002");
            this.jLabelPageNo.setText("");
        }
        return this.jLabelPageNo;
    }

    private JPanel getJPanelCommand() {
        if (this.jPanelCommand == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.jPanelCommand = new JPanel();
            this.jPanelCommand.setLayout(flowLayout);
            this.jPanelCommand.add((Component)this.getJButtonExecSql(), null);
            this.jPanelCommand.add((Component)this.getJLabelPageNo(), null);
            this.jPanelCommand.add((Component)this.getJButtonPrev(), null);
            this.jPanelCommand.add((Component)this.getJButtonNext(), null);
            this.jPanelCommand.add((Component)this.getJButtonSelectContinue(), null);
            this.jPanelCommand.add((Component)this.getJButtonSelectAbort(), null);
            this.jPanelCommand.add((Component)this.getJButtonCsvExport(), null);
            this.jPanelCommand.add((Component)this.getJButtonClear(), null);
            this.jPanelCommand.add((Component)this.getJButtonClose(), null);
            this.jPanelCommand.add((Component)this.getJButtonCommit(), null);
            this.jPanelCommand.add((Component)this.getJButtonRollBack(), null);
        }
        return this.jPanelCommand;
    }

    private JPanel getJPanelSqlInput() {
        if (this.jPanelSqlInput == null) {
            this.jPanelSqlInput = new JPanel();
            this.jPanelSqlInput.setLayout(new BorderLayout());
            this.jPanelSqlInput.add((Component)this.getJPanelSalStatement(), "Center");
        }
        return this.jPanelSqlInput;
    }

    private JScrollPane getJScrollPaneResults() {
        if (this.jScrollPaneResults == null) {
            this.jScrollPaneResults = new JScrollPane();
            this.jScrollPaneResults.setVerticalScrollBarPolicy(20);
            this.jScrollPaneResults.setHorizontalScrollBarPolicy(30);
            this.jScrollPaneResults.setViewportView(this.getJTableResults());
        }
        return this.jScrollPaneResults;
    }

    private JTableSql getJTableResults() {
        if (this.jTableResults == null) {
            this.jTableResults = new JTableSql();
            this.jTableResults.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    JPanelExecSql.this.jLabelLocation.setText(JPanelExecSql.this.getCurrentCellPosition());
                }
            });
            this.jTableResults.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    JPanelExecSql.this.jLabelLocation.setText(JPanelExecSql.this.getCurrentCellPosition());
                }
            });
        }
        return this.jTableResults;
    }

    private String getCurrentCellPosition() {
        return String.valueOf(this.jTableResults.getSelectedColumn() + 1) + " : " + (this.jTableResults.getSelectedRow() + 1) + "  ";
    }

    private JTextPaneSqlStatement getJTextPaneSqlStatement() {
        if (this.jTextPaneSqlStatement == null) {
            this.jTextPaneSqlStatement = new JTextPaneSqlStatement();
        }
        return this.jTextPaneSqlStatement;
    }

    private JPanel getJPanelSalStatement() {
        if (this.jPanelSalStatement == null) {
            this.jPanelSalStatement = new JPanel();
            this.jPanelSalStatement.setLayout(new BorderLayout());
            this.jPanelSalStatement.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanelSalStatement.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanelSalStatement;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setViewportView(this.getJTextPaneSqlStatement());
        }
        return this.jScrollPane;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setText("\u9589\u3058\u308b");
            this.jButtonClose.setFont(new Font("Dialog", 0, 12));
            this.jButtonClose.setToolTipText("SQL\u5b9f\u884c\u753b\u9762\u3092\u9589\u3058\u307e\u3059");
            this.jButtonClose.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedSelectClose();
                }
            });
        }
        return this.jButtonClose;
    }

    private void actionPerformedSelectClose() {
        this.disconnect();
        this.parent.disposePane(this);
    }

    public void disconnect() {
        this.actionSelectAbort.actionPerformed(null);
        SqlExec.disconnect(this.execSqlConnection);
    }

    private JButton getJButtonCommit() {
        if (this.jButtonCommit == null) {
            this.jButtonCommit = new JButton();
            this.jButtonCommit.setText("Commit");
            this.jButtonCommit.setFont(new Font("Dialog", 0, 12));
            this.jButtonCommit.setToolTipText("commit\u3057\u307e\u3059\u3002\u4f46\u3057\u3001ManualCommit\u3067SQL\u5b9f\u884c\u753b\u9762\u3092\u958b\u3044\u305f\u6642\u306e\u307f\u6709\u52b9\u3067\u3059");
            this.jButtonCommit.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonCommit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedCommit();
                }
            });
        }
        return this.jButtonCommit;
    }

    private void actionPerformedCommit() {
        if (this.execSqlConnection != null) {
            this.setMessage("Commit\u3092\u958b\u59cb\u3057\u307e\u3059... ");
            new Thread(){

                public void run() {
                    try {
                        JPanelExecSql.this.execSqlConnection.commit();
                        JPanelExecSql.this.setMessage("Commit\u3057\u307e\u3057\u305f");
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "Commit\u3067\u30a8\u30e9\u30fc\u767a\u751f");
                    }
                }
            }.start();
        }
    }

    private void actionPerformedRollBack() {
        if (this.execSqlConnection != null) {
            this.setMessage("RollBack\u3092\u958b\u59cb\u3057\u307e\u3059... ");
            new Thread(){

                public void run() {
                    try {
                        JPanelExecSql.this.execSqlConnection.rollback();
                        JPanelExecSql.this.setMessage("RollBack\u3057\u307e\u3057\u305f");
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "RollBack\u3067\u30a8\u30e9\u30fc\u767a\u751f");
                    }
                }
            }.start();
        }
    }

    private JButton getJButtonRollBack() {
        if (this.jButtonRollBack == null) {
            this.jButtonRollBack = new JButton();
            this.jButtonRollBack.setText("RollBack");
            this.jButtonRollBack.setFont(new Font("Dialog", 0, 12));
            this.jButtonRollBack.setToolTipText("rollback\u3057\u307e\u3059\u3002\u4f46\u3057\u3001ManualCommit\u3067SQL\u5b9f\u884c\u753b\u9762\u3092\u958b\u3044\u305f\u6642\u306e\u307f\u6709\u52b9\u3067\u3059");
            this.jButtonRollBack.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonRollBack.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedRollBack();
                }
            });
        }
        return this.jButtonRollBack;
    }

    public void setPaneName(String paneName) {
        this.paneName = paneName;
    }

    public String getTitleName() {
        if (this.jTableSqlModel != null) {
            return "(" + this.paneName + ")" + this.jTableSqlModel.getTableName().getTableName();
        }
        return "(" + this.paneName + ")";
    }

    private JPanel getJPanelMessage() {
        if (this.jPanelMessage == null) {
            this.jLabelLocation = new JLabel();
            this.jLabelLocation.setText("");
            this.jLabelMessage = new JLabel();
            this.jLabelMessage.setText(" ");
            this.jLabelMessage.setFont(new Font("Dialog", 0, 14));
            this.jPanelMessage = new JPanel();
            this.jPanelMessage.setLayout(new BorderLayout());
            this.jPanelMessage.add((Component)this.jLabelLocation, "West");
            this.jPanelMessage.add((Component)this.jLabelMessage, "Center");
        }
        return this.jPanelMessage;
    }

    class ReciveStatus
    extends QueryExecuteAdapter {
        ReciveStatus() {
        }

        private String msg(QueryExecuteStatus breakStatus) {
            if (breakStatus.getSource() == JPanelExecSql.this.actionCsvExport) {
                return "";
            }
            JPanelExecSql.this.parent.setTitle(JPanelExecSql.this.myself, JPanelExecSql.this.getTitleName());
            if (breakStatus.getSqlAnalyze().isSelectUpdatable()) {
                return "\u7d50\u679c\u66f4\u65b0\u53ef\u80fd\uff1a";
            }
            return String.valueOf(breakStatus.getSqlAnalyze().getErrorReasonMsg()) + "\uff1a";
        }

        public void completeQuery(QueryExecuteStatus breakStatus) {
            Logger.global.fine("BreakStatus\u53d7\u4fe1" + breakStatus.toString());
            if (breakStatus.isComplete()) {
                JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + breakStatus.getCnt() + "\u30ec\u30b3\u30fc\u30c9\u691c\u7d22\u3057\u307e\u3057\u305f");
            } else {
                JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + breakStatus.getCnt() + "\u30ec\u30b3\u30fc\u30c9\u3067\u7d50\u679c\u53d6\u5f97\u3068SQL\u5b9f\u884c\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f");
            }
            JPanelExecSql.this.resetButton();
        }

        public void status(QueryExecuteStatus breakStatus) {
            Logger.global.fine("BreakStatus\u53d7\u4fe1" + breakStatus.toString());
            JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + "\u691c\u7d22\u4e2d..." + breakStatus.getCnt() + "\u4ef6");
        }

        public void errorException(Exception obj) {
            if (obj instanceof SQLException) {
                JDialogMessage.sqlErrorDialog((SQLException)obj, "\u691c\u7d22\u7d50\u679c\u53d6\u5f97");
            } else {
                JDialogMessage.errorDialog(obj);
            }
            JPanelExecSql.this.resetButton();
        }
    }

    abstract class ActioinExecute
    extends ActionBase {
        private static final long serialVersionUID = -243818453050400696L;

        ActioinExecute(String name) {
            super(name);
        }

        public final void actionPerformed(ActionEvent e) {
            JPanelExecSql.this.execSqlConnection = this.checkConnect();
            if (JPanelExecSql.this.execSqlConnection == null) {
                return;
            }
            JPanelExecSql.this.setMessage(" ");
            SqlAnalyze sa = this.checkStatement(this.getSqlStatementCatgolys());
            if (sa == null) {
                return;
            }
            if (!this.execute(sa)) {
                return;
            }
            JPanelExecSql.this.cmdBuff.add(sa.getSqlStatement());
            JPanelExecSql.this.displayIdx();
            JPanelExecSql.this.jTextPaneSqlStatement.undoDiscard();
        }

        abstract boolean execute(SqlAnalyze var1);

        abstract SqlStatementCatgoly[] getSqlStatementCatgolys();

        private Connection checkConnect() {
            if (!SqlExec.isConnect()) {
                JDialogMessage.notConnectErrorDialog();
                JPanelExecSql.this.execSqlConnection = null;
                return null;
            }
            if (JPanelExecSql.this.execSqlConnection == null) {
                try {
                    JPanelExecSql.this.execSqlConnection = SqlExec.getNewConnection();
                    JPanelExecSql.this.execSqlConnection.setAutoCommit(JPanelExecSql.this.autoCommit);
                }
                catch (SQLException e1) {
                    JDialogMessage.sqlErrorDialog(e1, "connect\u5931\u6557");
                    return null;
                }
            }
            return JPanelExecSql.this.execSqlConnection;
        }

        private SqlAnalyze checkStatement(SqlStatementCatgoly[] sqlStatementCatgolys) {
            SqlAnalyze sa = new SqlAnalyze(JPanelExecSql.this.jTextPaneSqlStatement.getText());
            boolean flg = false;
            int i = 0;
            while (i < sqlStatementCatgolys.length) {
                if (sqlStatementCatgolys[i].equals((Object)sa.getSqlStatementCatgoly())) {
                    flg = true;
                    break;
                }
                ++i;
            }
            if (!flg) {
                String str = "";
                int i2 = 0;
                while (i2 < sqlStatementCatgolys.length) {
                    if (i2 != 0) {
                        str = String.valueOf(str) + ' ';
                    }
                    str = String.valueOf(str) + (Object)((Object)sqlStatementCatgolys[i2]);
                    ++i2;
                }
                JDialogMessage.errorDialog(new Exception(String.valueOf(str) + " \u306e\u307f\u5b9f\u884c\u51fa\u6765\u307e\u3059"));
                return null;
            }
            return sa;
        }
    }

    class ActionExecSql
    extends ActioinExecute {
        private static final long serialVersionUID = -6660910166029768221L;

        ActionExecSql() {
            super("SQL\u5b9f\u884c");
        }

        SqlStatementCatgoly[] getSqlStatementCatgolys() {
            SqlStatementCatgoly[] sql = new SqlStatementCatgoly[]{SqlStatementCatgoly.SELECT, SqlStatementCatgoly.INSERT, SqlStatementCatgoly.DELETE, SqlStatementCatgoly.UPDATE};
            return sql;
        }

        boolean execute(SqlAnalyze sa) {
            if (sa.getSqlStatementCatgoly() == SqlStatementCatgoly.SELECT) {
                JPanelExecSql.this.jButtonExecSql.setEnabled(false);
                JPanelExecSql.this.jTableSqlModel = new JTableSqlModel(JPanelExecSql.this.execSqlConnection);
                JPanelExecSql.this.queryExecute = new QueryExecute(this, sa, JPanelExecSql.this.execSqlConnection, JFrameMain.binaryDataSize);
                JPanelExecSql.this.queryExecute.addQueryExecuteListener(new ReciveStatus());
                JPanelExecSql.this.jTableResults.setModel(JPanelExecSql.this.jTableSqlModel);
                JPanelExecSql.this.queryExecute.addQueryExecuteListener(JPanelExecSql.this.jTableSqlModel);
                JPanelExecSql.this.queryExecute.addQueryExecuteListener(JPanelExecSql.this.jTableResults.new JTableSql.registCellRendererAndEditor());
                JPanelExecSql.this.actionSelectAbort.setEnabled(true);
                JPanelExecSql.this.actionSelectContinue.setEnabled(true);
                new Thread(JPanelExecSql.this.queryExecute).start();
                JPanelExecSql.this.actionCsvExport.setEnabled(false);
                JPanelExecSql.this.actionExecSql.setEnabled(false);
                return true;
            }
            int cnt = 0;
            try {
                cnt = SqlExec.execUpdate(sa.getSqlStatement(), JPanelExecSql.this.execSqlConnection);
            }
            catch (SQLException ex) {
                JDialogMessage.sqlErrorDialog(ex, "RollBack\u3057\u307e\u3057\u305f\u3002\u691c\u7d22\u7cfb\u4ee5\u5916\u306e\u30b3\u30de\u30f3\u30c9\u5b9f\u884c");
                return false;
            }
            if (cnt >= 0) {
                JPanelExecSql.this.setMessage(String.valueOf(cnt) + "\u30ec\u30b3\u30fc\u30c9\u66f4\u65b0\u3057\u307e\u3057\u305f");
            }
            return true;
        }
    }

    class ActionCsvExport
    extends ActioinExecute {
        private static final long serialVersionUID = -6872871029493035488L;

        public ActionCsvExport() {
            super("CSV\u51fa\u529b...");
        }

        boolean execute(SqlAnalyze sa) {
            CsvInfo csvInfo = new CsvInfo();
            csvInfo.currentDataLoad();
            csvInfo.setPropTableName(sa.getSchemaTableName());
            JDialogCsv dlg = new JDialogCsv(CsvMode.EXPORT, csvInfo);
            csvInfo = dlg.getCsvInfo();
            if (csvInfo == null) {
                return false;
            }
            QueryExecute queryExecuteCsv = null;
            queryExecuteCsv = new QueryExecute(this, sa, JPanelExecSql.this.execSqlConnection, 0);
            queryExecuteCsv.addQueryExecuteListener(new CsvExport(csvInfo));
            queryExecuteCsv.addQueryExecuteListener(new ReciveStatus());
            new Thread(queryExecuteCsv).start();
            JPanelExecSql.this.actionCsvExport.setEnabled(false);
            JPanelExecSql.this.actionExecSql.setEnabled(false);
            return true;
        }

        SqlStatementCatgoly[] getSqlStatementCatgolys() {
            SqlStatementCatgoly[] sql = new SqlStatementCatgoly[]{SqlStatementCatgoly.SELECT};
            return sql;
        }
    }

    class ActionSelectAbort
    extends ActionBase {
        private static final long serialVersionUID = 3905192537275202747L;

        ActionSelectAbort() {
            super("\u7d99\u7d9a\u4e2d\u6b62");
        }

        public void actionPerformed(ActionEvent e) {
            if (JPanelExecSql.this.queryExecute != null) {
                JPanelExecSql.this.queryExecute.setCancelFlg();
            }
            if (JPanelExecSql.this.jTableSqlModel != null) {
                JPanelExecSql.this.jTableSqlModel.nextSearch();
            }
        }
    }

    class ActionSelectContinue
    extends ActionBase {
        private static final long serialVersionUID = 6826069816727830380L;

        ActionSelectContinue() {
            super("\u7d99\u7d9a\u53d6\u5f97");
        }

        public void actionPerformed(ActionEvent e) {
            if (JPanelExecSql.this.jTableSqlModel != null) {
                JPanelExecSql.this.jTableSqlModel.nextSearch();
            }
        }
    }
}

