/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.ProgressMonitorInputStream;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.csv.CSVTokenizer;
import jdbcacsess.csv.CsvBufferedReader;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.gui.common.JDialogMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvInput {
    protected CsvInfo csvInfo;
    protected CsvBufferedReader in;
    protected int inputCnt;

    public CsvInput(CsvInfo info) {
        this.csvInfo = info;
    }

    protected void openInputFile() throws JdbcacsessException {
        try {
            ProgressMonitorInputStream fos = new ProgressMonitorInputStream(new JDialog(), String.valueOf(this.csvInfo.getPropTableName().getCompleteTableName()) + "  import... ", new FileInputStream(this.csvInfo.getFileName()));
            this.in = new CsvBufferedReader(new InputStreamReader((InputStream)fos, this.csvInfo.getEncoding()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new JdbcacsessException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new JdbcacsessException(e);
        }
    }

    protected void closeInputFile() {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
        }
    }

    protected Vector<String> readFile() throws IOException {
        Vector<String> v = new Vector<String>();
        String rec = null;
        rec = this.in.readCsvLine();
        if (rec == null) {
            return null;
        }
        ++this.inputCnt;
        CSVTokenizer csvt = new CSVTokenizer(rec);
        csvt.setToken(this.csvInfo.getColumnDelimiter());
        while (csvt.hasMoreTokens()) {
            v.add(csvt.nextToken());
        }
        return v;
    }
}

