/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.createdata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.createdata.JPanelCreateData;
import jdbcacsess.createdata.JPanelDateTime;
import jdbcacsess.createdata.JPanelDefault;
import jdbcacsess.createdata.JPanelSequence;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SchemaTableColumnName;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1421584187171950474L;
    private ArrayList<ColumnInfoTable> columnInfoTables;
    private ArrayList<JPanelCreateData> jPanelCreateDatas = new ArrayList();
    private ArrayList<QueryExecuteListener> outputListenners = new ArrayList();

    public void addOutputQueryExecuteListener(QueryExecuteListener listener) {
        this.outputListenners.add(listener);
    }

    public void removeOutputQueryExecuteListeners() {
        this.outputListenners.clear();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "\u751f\u6210\u5148\u30ab\u30e9\u30e0\u540d";
            }
            case 1: {
                return "\u5c5e\u6027";
            }
            case 2: {
                return "\u6841\u30fb\u30d0\u30a4\u30c8";
            }
            case 3: {
                return "\u5c0f\u6570\u70b9\u4ee5\u4e0b";
            }
            case 4: {
                return "\u751f\u6210\u624b\u9806";
            }
            case 5: {
                return "\uff11\u4ef6\u76ee\u30d7\u30ec\u30d3\u30e5\u30fc";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.columnInfoTables.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.columnInfoTables.get(rowIndex).getColumnName();
            }
            case 1: {
                return this.columnInfoTables.get(rowIndex).getColumnTypeName();
            }
            case 2: {
                return this.columnInfoTables.get(rowIndex).getColumnSize();
            }
            case 3: {
                return this.columnInfoTables.get(rowIndex).getDecimalDigits();
            }
            case 4: {
                return this.jPanelCreateDatas.get(rowIndex);
            }
            case 5: {
                JPanelCreateData jpcd = this.jPanelCreateDatas.get(rowIndex);
                jpcd.dataInitial();
                Object rtn = jpcd.dataNext();
                jpcd.dataFinal();
                return rtn;
            }
        }
        return null;
    }

    public JPanelCreateData getJPanelCreateData(int rowIndex) {
        return (JPanelCreateData)this.getValueAt(rowIndex, 4);
    }

    public void setJPanelCreateData(int rowIndex, JPanelCreateData aValue) {
        aValue.debugPrint();
        this.jPanelCreateDatas.set(rowIndex, aValue);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void initOutput() throws IOException, FileNotFoundException {
        for (JPanelCreateData jpcd : this.jPanelCreateDatas) {
            jpcd.dataInitial();
        }
        for (QueryExecuteListener listener : this.outputListenners) {
            listener.init();
        }
        Vector<ColumnInfoResult> head = new Vector<ColumnInfoResult>();
        int columnIdx = 0;
        while (columnIdx < this.columnInfoTables.size()) {
            if (!(this.jPanelCreateDatas.get(columnIdx) instanceof JPanelDefault)) {
                head.add(new ColumnInfoResult(this.columnInfoTables.get(columnIdx)));
            }
            ++columnIdx;
        }
        for (QueryExecuteListener listener : this.outputListenners) {
            listener.setResultHeader(head, null);
        }
    }

    public void detailOutput() throws IOException {
        Vector<Object> detail = new Vector<Object>();
        for (JPanelCreateData jpcd : this.jPanelCreateDatas) {
            if (jpcd instanceof JPanelDefault) continue;
            detail.add(jpcd.dataNext());
        }
        for (QueryExecuteListener listener : this.outputListenners) {
            listener.setResultDetail(detail);
        }
    }

    public void endOutput(int creatCnt) {
        QueryExecuteStatus qes = new QueryExecuteStatus(this, creatCnt, true, null, false);
        for (QueryExecuteListener listener : this.outputListenners) {
            listener.completeQuery(qes);
        }
        for (JPanelCreateData jpcd : this.jPanelCreateDatas) {
            jpcd.dataInitial();
        }
    }

    public Map getCreateDataMap() {
        HashMap<String, JPanelCreateData> map = new HashMap<String, JPanelCreateData>();
        int i = 0;
        while (i < this.columnInfoTables.size()) {
            map.put(this.columnInfoTables.get(i).getColumnName(), this.jPanelCreateDatas.get(i));
            ++i;
        }
        return map;
    }

    public void setCreateDataMap(Map<String, JPanelCreateData> map) {
        int i = 0;
        while (i < this.columnInfoTables.size()) {
            JPanelCreateData value = map.get(this.columnInfoTables.get(i).getColumnName());
            if (value != null) {
                this.jPanelCreateDatas.set(i, value);
            }
            ++i;
        }
    }

    public void setTableName(SchemaTableName tableName) throws SQLException {
        this.columnInfoTables = SqlExec.getColumnMames(tableName);
        int i = 0;
        while (i < this.columnInfoTables.size()) {
            ColumnInfoTable columnInfoTable = this.columnInfoTables.get(i);
            SchemaTableColumnName stcn = new SchemaTableColumnName(columnInfoTable.getSchemaTableName(), columnInfoTable.getColumnName());
            JPanelCreateData jpcd = null;
            switch (columnInfoTable.getColumnType()) {
                case 91: 
                case 92: 
                case 93: {
                    jpcd = new JPanelDateTime();
                    break;
                }
                default: {
                    jpcd = new JPanelSequence(stcn);
                }
            }
            this.jPanelCreateDatas.add(jpcd);
            ++i;
        }
    }

    public ColumnInfoTable getColumnInfo(int row) {
        return this.columnInfoTables.get(row);
    }
}

