/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingFile {
    private static SettingFile _instance = new SettingFile();
    private final String folderName = ".jdbcacsess";
    private Document doc;
    private Element root;
    private File file;

    private SettingFile() {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            this.setFile();
            this.doc = this.file.exists() ? builder.parse(this.file) : builder.getDOMImplementation().createDocument("", "root", null);
            this.root = this.doc.getDocumentElement();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static SettingFile getInstance() {
        return _instance;
    }

    public String getUserPath() {
        String userHome = System.getProperty("user.home");
        String userPath = String.valueOf(userHome) + System.getProperty("file.separator") + ".jdbcacsess";
        File path = new File(userPath);
        if (!path.isDirectory()) {
            path.mkdir();
        }
        return userPath;
    }

    public String getFileName(String name) {
        return String.valueOf(this.getUserPath()) + System.getProperty("file.separator") + name;
    }

    private void setFile() {
        String fileName = this.getFileName("setting.xml");
        this.file = new File(fileName);
    }

    public synchronized void save() throws TransformerException, IOException {
        TransformerFactory tff = TransformerFactory.newInstance();
        Transformer tf = tff.newTransformer();
        tf.transform(new DOMSource(this.doc), new StreamResult(this.file));
    }

    public synchronized Element getRootElement(String tagName) {
        return this.getElement(this.root, tagName);
    }

    public synchronized Element getElement(Element node, String tagName) {
        NodeList childNodes = node.getChildNodes();
        Element resultElement = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node order = childNodes.item(i);
            if (order.getNodeType() == 1 && order.getNodeName().equals(tagName)) {
                resultElement = (Element)order;
                break;
            }
            ++i;
        }
        if (resultElement == null) {
            resultElement = this.createElement(tagName);
            node.appendChild(resultElement);
        }
        return resultElement;
    }

    public synchronized Element createElement(String tagName) {
        return this.doc.createElement(tagName);
    }

    public File getFile() {
        return this.file;
    }

    public static Element getElementSearchingAttribute(Element elementTop, String tagName, String attrName, String attrValue) {
        Element guiElement = null;
        NodeList list = elementTop.getElementsByTagName(tagName);
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            if (list.item(i).getNodeType() == 1 && (element = (Element)list.item(i)).getAttribute(attrName).equals(attrValue)) {
                guiElement = element;
                break;
            }
            ++i;
        }
        return guiElement;
    }

    public static Element getElementSearchingAttribute2(Element elementTop, String tagName, String attrName1, String attrValue1, String attrName2, String attrValue2) {
        Element guiElement = null;
        NodeList list = elementTop.getElementsByTagName(tagName);
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            if (list.item(i).getNodeType() == 1 && (element = (Element)list.item(i)).getAttribute(attrName1).equals(attrValue1) && element.getAttribute(attrName2).equals(attrValue2)) {
                guiElement = element;
                break;
            }
            ++i;
        }
        return guiElement;
    }

    public static ArrayList<Element> getElements(Element element, String tagname) {
        ArrayList<Element> rtn = new ArrayList<Element>();
        NodeList list = element.getElementsByTagName(tagname);
        int i = 0;
        while (i < list.getLength()) {
            rtn.add((Element)list.item(i));
            ++i;
        }
        return rtn;
    }
}

