/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.TransformerException;
import jdbcacsess.SettingFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfoListSetting<T> {
    private SettingFile xml = SettingFile.getInstance();

    protected abstract String getKeyValue();

    protected abstract void setKeyValue(String var1);

    protected abstract String getBaseTagName();

    protected abstract T getInstance();

    public abstract void setFromElement(Element var1);

    public abstract void addToElement(Element var1);

    private Element topElement() {
        return this.xml.getRootElement(String.valueOf(this.getBaseTagName()) + "s");
    }

    public void currentDataLoad() {
        String key = this.topElement().getAttribute("current");
        if (key.equals("")) {
            return;
        }
        this.setKeyValue(key);
        Element element = this.getKeyElement(this.topElement(), this.getBaseTagName(), key);
        this.setFromElement(element);
    }

    public boolean keyDataLoad(String key) {
        Map<String, Element> map = this.getKeyMap(this.topElement(), this.getBaseTagName());
        Element element = map.get(key);
        if (element == null) {
            return false;
        }
        this.setKeyValue(key);
        this.setFromElement(element);
        System.out.println("#keyDataLoad()#" + this.toString());
        return true;
    }

    public void currentDataSave() {
        if (this.getKeyValue().equals("")) {
            return;
        }
        this.topElement().setAttribute("current", this.getKeyValue());
        Element element = this.getKeyElement(this.topElement(), this.getBaseTagName(), this.getKeyValue());
        this.addToElement(element);
        try {
            this.xml.save();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeParameter() {
        NodeList childNodes = this.topElement().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node temp;
            Node order = childNodes.item(i);
            if (order.getNodeType() == 1 && order.getNodeName().equals(this.getBaseTagName()) && (temp = order.getAttributes().getNamedItem("key")).getNodeValue().equals(this.getKeyValue())) {
                this.topElement().removeChild(order);
            }
            ++i;
        }
        this.setKeyValue("");
        this.topElement().setAttribute("current", this.getKeyValue());
        try {
            this.xml.save();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<T> getInfoList() {
        ArrayList<T> list = new ArrayList<T>();
        Map<String, Element> map = this.getKeyMap(this.topElement(), this.getBaseTagName());
        for (Map.Entry<String, Element> item : map.entrySet()) {
            T o = this.getInstance();
            ((InfoListSetting)o).setKeyValue(item.getKey());
            ((InfoListSetting)o).setFromElement(item.getValue());
            list.add(o);
        }
        return list;
    }

    public Map<String, T> getInfoMap() {
        HashMap<String, T> rtn = new HashMap<String, T>();
        Map<String, Element> map = this.getKeyMap(this.topElement(), this.getBaseTagName());
        for (Map.Entry<String, Element> item : map.entrySet()) {
            T o = this.getInstance();
            ((InfoListSetting)o).setKeyValue(item.getKey());
            ((InfoListSetting)o).setFromElement(item.getValue());
            rtn.put(item.getKey(), o);
        }
        return rtn;
    }

    private Element getKeyElement(Element element, String tagName, String keyValue) {
        NodeList childNodes = element.getChildNodes();
        Element resultElement = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node temp;
            Node order = childNodes.item(i);
            if (order.getNodeType() == 1 && order.getNodeName().equals(tagName) && (temp = order.getAttributes().getNamedItem("key")).getNodeValue().equals(keyValue)) {
                resultElement = (Element)order;
                break;
            }
            ++i;
        }
        if (resultElement == null) {
            resultElement = this.xml.createElement(tagName);
            resultElement.setAttribute("key", keyValue);
            element.appendChild(resultElement);
        }
        return resultElement;
    }

    private Map<String, Element> getKeyMap(Element element, String tagName) {
        NodeList childNodes = element.getChildNodes();
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node order = childNodes.item(i);
            if (order.getNodeType() == 1 && order.getNodeName().equals(tagName)) {
                Node temp = order.getAttributes().getNamedItem("key");
                map.put(temp.getNodeValue(), (Element)order);
            }
            ++i;
        }
        return map;
    }
}

