/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jdbcacsess.ComponentProperty;
import jdbcacsess.JFrameBase;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.Viewer;

public class JFrameViewerImage
extends JFrameBase
implements Viewer {
    private static final String FRAMESIZE_WIN = "win";
    private static final String FRAMESIZE_IMAGE = "image";
    private static final long serialVersionUID = -6212931542335612140L;
    private static final String TITLE = "\u753b\u50cf\u30d3\u30e5\u30fc\u30ef";
    private JPanel jContentPane = null;
    private static Viewer jFrameViewer = null;
    private InputStream is;
    private JLabel jLabelImage = null;
    private JPopupMenu jPopupMenu = null;
    private JRadioButtonMenuItem jRadioButtonMenuItemWinSize = null;
    private JRadioButtonMenuItem jRadioButtonMenuItemImageSize = null;
    private BufferedImage image;
    String frameSize;

    public static Viewer getInstance() {
        if (jFrameViewer == null) {
            jFrameViewer = new JFrameViewerImage();
        }
        return jFrameViewer;
    }

    private JFrameViewerImage() {
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(TITLE);
        this.setSize(new Dimension(600, 400));
        super.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFrameViewerImage.this.frameClosing();
            }
        });
        this.getJPopupMenu();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jRadioButtonMenuItemImageSize);
        bg.add(this.jRadioButtonMenuItemWinSize);
        this.jLabelImage.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                JFrameViewerImage.this.popupMenu(event);
            }

            public void mouseReleased(MouseEvent event) {
                JFrameViewerImage.this.popupMenu(event);
            }
        });
        ComponentProperty cp = new ComponentProperty();
        this.frameSize = cp.getToString(this.getClass(), "frameSize");
        if (this.frameSize.equals("")) {
            this.frameSize = FRAMESIZE_IMAGE;
        }
        this.setSelectedFrameSize(this.frameSize);
    }

    private void popupMenu(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.getJPopupMenu().show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private void setSelectedFrameSize(String size) {
        this.frameSize = size;
        if (size.equals(FRAMESIZE_IMAGE)) {
            this.jRadioButtonMenuItemImageSize.setSelected(true);
        }
        if (size.equals(FRAMESIZE_WIN)) {
            this.jRadioButtonMenuItemWinSize.setSelected(true);
        }
        this.resize();
    }

    private void frameClosing() {
        ComponentProperty cp = new ComponentProperty();
        cp.put(this.getClass(), "frameSize", this.frameSize);
        jFrameViewer = null;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
    }

    private void resize() {
        ImageIcon imageIcon = (ImageIcon)this.jLabelImage.getIcon();
        if (imageIcon != null) {
            if (this.frameSize.equals(FRAMESIZE_IMAGE)) {
                this.jRadioButtonMenuItemImageSize.setSelected(true);
                Insets insets = this.getInsets();
                this.setSize(new Dimension(this.image.getWidth() + insets.left + insets.right, this.image.getHeight() + insets.top + insets.bottom));
                imageIcon.setImage(this.image);
            }
            if (this.frameSize.equals(FRAMESIZE_WIN)) {
                this.jRadioButtonMenuItemWinSize.setSelected(true);
                double w = (double)this.image.getWidth() / (double)this.jLabelImage.getWidth();
                double h = (double)this.image.getHeight() / (double)this.jLabelImage.getHeight();
                Logger.global.fine("orgsize:" + this.image.getWidth() + "," + this.image.getHeight());
                Logger.global.fine("\u500d\u7387:" + w + "," + h);
                if (w > 1.0 || h > 1.0) {
                    int width = -1;
                    int height = -1;
                    if (w > h) {
                        width = (int)((double)this.image.getWidth() / w);
                    } else {
                        height = (int)((double)this.image.getHeight() / h);
                    }
                    Logger.global.fine("resize:" + width + "," + height);
                    imageIcon.setImage(this.image.getScaledInstance(width, height, 2));
                }
            }
        }
        this.setVisible(true);
    }

    public void setInputStream(InputStream is, long size, String title) throws IOException {
        this.setTitle("\u753b\u50cf\u30d3\u30e5\u30fc\u30ef [" + title + "]");
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        this.image = ImageIO.read(is);
        if (this.image == null) {
            throw new IOException("javax.imageio.ImageIO\u3067\u6271\u3048\u306a\u3044\u753b\u50cf\u30c7\u30fc\u30bf\u5f62\u5f0f\u3067\u3059");
        }
        this.jLabelImage.setIcon(new ImageIcon(this.image));
        this.resize();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelImage = new JLabel();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.jLabelImage, "Center");
        }
        return this.jContentPane;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJRadioButtonMenuItemWinSize());
            this.jPopupMenu.add(this.getJRadioButtonMenuItemImageSize());
        }
        return this.jPopupMenu;
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItemWinSize() {
        if (this.jRadioButtonMenuItemWinSize == null) {
            this.jRadioButtonMenuItemWinSize = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItemWinSize.setText("Windo\u30b5\u30a4\u30ba\u306b\u5408\u308f\u305b\u308b");
            this.jRadioButtonMenuItemWinSize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameViewerImage.this.setSelectedFrameSize(JFrameViewerImage.FRAMESIZE_WIN);
                }
            });
        }
        return this.jRadioButtonMenuItemWinSize;
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItemImageSize() {
        if (this.jRadioButtonMenuItemImageSize == null) {
            this.jRadioButtonMenuItemImageSize = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItemImageSize.setText("\u753b\u50cf\u30b5\u30a4\u30ba\u306b\u5408\u308f\u305b\u308b");
            this.jRadioButtonMenuItemImageSize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameViewerImage.this.setSelectedFrameSize(JFrameViewerImage.FRAMESIZE_IMAGE);
                }
            });
        }
        return this.jRadioButtonMenuItemImageSize;
    }
}

