/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SchemaTableColumnName;
import jdbcacsess.sql.SchemaTableName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExec {
    private static Connection _con;
    private static String _userId;
    private static String _passWord;
    private static String _jdbcUrl;
    private static boolean lower;
    private static boolean upper;
    private static Driver driver;
    private static String _driverClassName;
    static Map<String, ArrayList<String>> tableNamesMap;
    static Map<String, ArrayList<ColumnInfoTable>> columnInfoTableMap;

    static {
        tableNamesMap = new HashMap<String, ArrayList<String>>();
        columnInfoTableMap = new HashMap<String, ArrayList<ColumnInfoTable>>();
    }

    public static boolean isConnect() {
        if (_con == null) {
            return false;
        }
        try {
            return !_con.isClosed();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void connect(String userId, String passWord, String jdbcUrl, String driverClassName, URL driverUrlPath) throws SQLException, ClassNotFoundException, MalformedURLException, InstantiationException, IllegalAccessException {
        _userId = userId;
        _passWord = passWord;
        _jdbcUrl = jdbcUrl;
        _driverClassName = driverClassName;
        if (driverUrlPath == null) {
            driver = (Driver)Class.forName(_driverClassName).newInstance();
        } else {
            URL[] jarurl = new URL[]{driverUrlPath};
            URLClassLoader loader = new URLClassLoader(jarurl);
            driver = (Driver)Class.forName(_driverClassName, true, loader).newInstance();
        }
        SqlExec.disconnect();
        Properties info = new Properties();
        info.put("user", userId);
        info.put("password", passWord);
        _con = driver.connect(jdbcUrl, info);
        _con.setAutoCommit(true);
        lower = _con.getMetaData().storesLowerCaseIdentifiers();
        upper = _con.getMetaData().storesUpperCaseIdentifiers();
        tableNamesMap.clear();
        columnInfoTableMap.clear();
        Logger.global.info("URL:" + jdbcUrl.toString());
        Logger.global.info("\u30c9\u30e9\u30d0\u30af\u30e9\u30b9\u540d:" + driverClassName.toString());
        if (driverUrlPath != null) {
            Logger.global.info("\u30c9\u30e9\u30d0\u30e9\u30a4\u30d6\u30e9\u30ea\u30d1\u30b9:" + driverUrlPath.toString());
        }
    }

    public static void setAutoCommit(boolean flg) throws SQLException {
        if (SqlExec.isConnect()) {
            _con.setAutoCommit(flg);
        }
    }

    public static String getConnectString() {
        return String.valueOf(_jdbcUrl) + " [User=" + _userId + "]" + " " + _driverClassName;
    }

    public static void disconnect() {
        if (SqlExec.isConnect()) {
            try {
                _con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        _con = null;
    }

    public static void disconnect(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void rollbackError() {
        try {
            if (SqlExec.isConnect()) {
                System.out.println("SqlExec.rollbackError()");
                _con.rollback();
            }
        }
        catch (SQLException err) {
            System.out.println("\u30a8\u30e9\u30fc\u767a\u751f\u6642\u306e\u5f37\u5236RollBack\u3067\u30a8\u30e9\u30fc\u3001\u7121\u8996\u3057\u307e\u3059\u3002");
        }
    }

    public static int execUpdate(String sqlCommand, Connection con) throws SQLException {
        con.clearWarnings();
        System.out.println("SqlExec.execUpdate " + sqlCommand);
        Statement stmtUpdate = con.createStatement();
        int cnt = 0;
        try {
            stmtUpdate.executeUpdate(sqlCommand);
            cnt = stmtUpdate.getUpdateCount();
        }
        finally {
            stmtUpdate.close();
        }
        return cnt;
    }

    public static String getCatalog() throws SQLException {
        tableNamesMap = new HashMap<String, ArrayList<String>>();
        columnInfoTableMap = new HashMap<String, ArrayList<ColumnInfoTable>>();
        String catalog = _con.getCatalog();
        if (catalog == null) {
            return "\u30ab\u30bf\u30ed\u30b0\u7121\u3057";
        }
        return catalog;
    }

    public static ArrayList<String> getPrimaryKeys(String schemaName, String tableName) throws SQLException {
        TreeMap<Short, String> columnNamesMap = new TreeMap<Short, String>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getPrimaryKeys(null, schemaName, tableName);
        while (rs.next()) {
            columnNamesMap.put(rs.getShort(5), rs.getString(4));
        }
        rs.close();
        ArrayList<String> currentTablePrimkeys = new ArrayList<String>();
        for (Short idx : columnNamesMap.keySet()) {
            currentTablePrimkeys.add((String)columnNamesMap.get(idx));
        }
        return currentTablePrimkeys;
    }

    public static ArrayList<String> getSchemaNames() throws SQLException {
        ArrayList<String> schemaNames = new ArrayList<String>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getSchemas();
        while (rs.next()) {
            String schema = rs.getString(1);
            schemaNames.add(schema);
        }
        rs.close();
        if (schemaNames.isEmpty()) {
            schemaNames.add(" ");
        }
        return schemaNames;
    }

    public static ArrayList<String> getSimpleTableNames(String schema) throws SQLException {
        ArrayList<String> tableNames = tableNamesMap.get(schema);
        if (tableNames != null) {
            return tableNames;
        }
        tableNames = new ArrayList();
        DatabaseMetaData md = _con.getMetaData();
        String[] tableType = new String[]{"TABLE", "VIEW"};
        ResultSet rs = md.getTables(null, schema, null, tableType);
        while (rs.next()) {
            tableNames.add(rs.getString(3));
        }
        rs.close();
        tableNamesMap.put(schema, tableNames);
        return tableNames;
    }

    public static ArrayList<SchemaTableName> getCompleteTableNames(String schema) throws SQLException {
        ArrayList<SchemaTableName> completeTableNames = new ArrayList<SchemaTableName>();
        for (String table : SqlExec.getSimpleTableNames(schema)) {
            completeTableNames.add(new SchemaTableName(schema, table));
        }
        return completeTableNames;
    }

    public static ArrayList<ColumnInfoTable> getColumnMames(SchemaTableName schemaTable) throws SQLException {
        return SqlExec.getColumnMames(schemaTable.getSchemaName(), schemaTable.getTableName());
    }

    public static ArrayList<ColumnInfoTable> getColumnMames(String schema, String tableName) throws SQLException {
        ArrayList<ColumnInfoTable> columnNames = columnInfoTableMap.get(String.valueOf(schema) + tableName);
        if (columnNames != null) {
            return columnNames;
        }
        TreeMap<Integer, ColumnInfoTable> columnNamesMap = new TreeMap<Integer, ColumnInfoTable>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getColumns(null, schema, tableName, null);
        ArrayList<String> primaryKeys = SqlExec.getPrimaryKeys(schema, tableName);
        int no = 0;
        while (rs.next()) {
            ColumnInfoTable ci = new ColumnInfoTable(++no, rs.getString(4), rs.getInt(5), rs.getString(6), rs.getInt(11), new SchemaTableName(schema, rs.getString(3)), rs.getInt(7), rs.getInt(9), rs.getString(12));
            ci.setPrimaryKey(primaryKeys.contains(ci.getColumnName()));
            columnNamesMap.put(rs.getInt(17), ci);
        }
        rs.close();
        columnNames = new ArrayList();
        for (Integer idx : columnNamesMap.keySet()) {
            columnNames.add((ColumnInfoTable)columnNamesMap.get(idx));
        }
        columnInfoTableMap.put(String.valueOf(schema) + tableName, columnNames);
        return columnNames;
    }

    public static ColumnInfoTable getColumnInfoTable(SchemaTableColumnName stcn) throws SQLException {
        for (ColumnInfoTable cit : SqlExec.getColumnMames(stcn.getSchemaTableName())) {
            if (!cit.getColumnName().equals(stcn.getColumnName())) continue;
            return cit;
        }
        return null;
    }

    public static String convertStoresIdentifiers(String str) {
        if (lower) {
            return str.toLowerCase();
        }
        if (upper) {
            return str.toUpperCase();
        }
        return str;
    }

    public static Connection getNewConnection() throws SQLException {
        Properties info = new Properties();
        info.put("user", _userId);
        info.put("password", _passWord);
        Connection con = driver.connect(_jdbcUrl, info);
        con.setAutoCommit(_con.getAutoCommit());
        if (con.getMetaData().getDatabaseProductName().equals("Oracle")) {
            Statement stmt = con.createStatement();
            stmt.execute("ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'");
            stmt.close();
            Logger.global.info("Oracle\u306a\u306e\u3067\u3001NLS_DATE_FORMAT\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002select * from nls_session_parameters \u3067\u78ba\u8a8d\u3057\u3066\u4e0b\u3055\u3044 ");
            try {
                try {
                    stmt = con.createStatement();
                    stmt.execute("ALTER SESSION SET NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9'");
                    stmt.execute("ALTER SESSION SET NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9'");
                    Logger.global.info("Oracle\u306a\u306e\u3067\u3001NLS_TIMESTAMP_FORMAT\u3068NLS_TIMESTAMP_TZ_FORMAT\u3082\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002select * from nls_session_parameters \u3067\u78ba\u8a8d\u3057\u3066\u4e0b\u3055\u3044 ");
                }
                catch (SQLException e) {
                    Logger.global.log(Level.SEVERE, "TIMESTAMP_FORMAT\u306ealter sessionn \u5931\u6557", e);
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return con;
    }

    public static Driver getDriver() {
        return driver;
    }
}

