/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableCellRenderer;
import jdbcacsess.JTextFieldEdit;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.JFrameResultSetMD;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.column.Binary;
import jdbcacsess.sql.column.BinaryInputStream;
import jdbcacsess.sql.column.CellEditorBinary;
import jdbcacsess.sql.column.CellEditorOracleDate;
import jdbcacsess.sql.column.OracleDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecute
implements Runnable {
    private volatile boolean runner;
    private volatile int cnt;
    private ResultSet rs = null;
    private Statement stmt = null;
    private SqlAnalyze sqlAnalyze;
    private Connection con = null;
    private Vector<ColumnInfoResult> selectColmunInfos;
    private ArrayList<QueryExecuteListener> listeners = new ArrayList();
    private int binaryDataSize;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public void addQueryExecuteListener(QueryExecuteListener listener) {
        this.listeners.add(listener);
    }

    public QueryExecute(SqlAnalyze sqlAnalyze, Connection con, int binaryDataSize) {
        this.sqlAnalyze = sqlAnalyze;
        this.con = con;
        this.binaryDataSize = binaryDataSize;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[DOLOOP]], but top level block is 28[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCancelFlg() {
        this.runner = false;
    }

    private void openSqlCursor(String sqlStatement) throws SQLException, IOException {
        this.selectColmunInfos = new Vector();
        this.stmt = this.con.createStatement();
        this.rs = this.stmt.executeQuery(sqlStatement);
        int col = this.rs.getMetaData().getColumnCount();
        ResultSetMetaData rsm = this.rs.getMetaData();
        int i = 1;
        while (i <= col) {
            Class columnClass;
            TableCellRenderer tableCellRenderer = null;
            DefaultCellEditor tableCellEditor = null;
            if (this.isBinary(i)) {
                columnClass = Binary.class;
                tableCellEditor = new CellEditorBinary(new JTextFieldEdit(true));
            } else if (this.isOracleDate(i)) {
                columnClass = OracleDate.class;
                tableCellEditor = new CellEditorOracleDate(new JTextFieldEdit(true));
            } else if (this.isOracleTimeStamp(i)) {
                columnClass = Timestamp.class;
            } else {
                try {
                    columnClass = Class.forName(rsm.getColumnClassName(i));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    columnClass = Object.class;
                }
            }
            ColumnInfoResult colInfo = new ColumnInfoResult(i, rsm.getColumnName(i), rsm.getColumnType(i), rsm.getColumnTypeName(i), rsm.isNullable(i), columnClass, rsm.getPrecision(i), rsm.getScale(i), tableCellRenderer, tableCellEditor);
            this.selectColmunInfos.add(colInfo);
            ++i;
        }
    }

    private boolean hasQueryNext() throws SQLException {
        if (this.rs == null) {
            return false;
        }
        if (this.rs.next()) {
            return true;
        }
        this.rs.close();
        return false;
    }

    private boolean isOracleDate(int i) throws SQLException {
        return this.rs.getMetaData().getColumnType(i) == 91 && this.rs.getMetaData().getColumnClassName(i).equals("java.sql.Timestamp");
    }

    private boolean isOracleTimeStamp(int i) throws SQLException {
        return this.rs.getMetaData().getColumnClassName(i).equals("oracle.sql.TIMESTAMP") || this.rs.getMetaData().getColumnClassName(i).equals("oracle.sql.TIMESTAMPTZ") || this.rs.getMetaData().getColumnClassName(i).equals("oracle.sql.TIMESTAMPLTZ");
    }

    private boolean isBinary(int i) throws SQLException {
        String name = this.rs.getMetaData().getColumnClassName(i);
        return name.equals("byte[]") || name.equals("[B");
    }

    public Vector getQueryReslut() throws SQLException, IOException {
        ++this.cnt;
        Vector<Object> rowData = new Vector<Object>();
        int i = 1;
        while (i <= this.rs.getMetaData().getColumnCount()) {
            block14: {
                block19: {
                    boolean fullData;
                    byte[] b;
                    block21: {
                        block20: {
                            block18: {
                                block17: {
                                    block16: {
                                        Timestamp timeStamp;
                                        block15: {
                                            block13: {
                                                if (JFrameMain.debugMode && this.cnt == 1) {
                                                    JFrameResultSetMD a = JFrameResultSetMD.getInstance();
                                                    a.setData(this.rs);
                                                }
                                                if (this.selectColmunInfos.get(i - 1).getColumnClass() != OracleDate.class) break block13;
                                                Timestamp ts = this.rs.getTimestamp(i);
                                                if (!this.isAddNull(rowData, ts)) {
                                                    rowData.add(new OracleDate(ts.getTime()));
                                                }
                                                break block14;
                                            }
                                            if (!this.rs.getMetaData().getColumnClassName(i).equals("oracle.sql.TIMESTAMP")) break block15;
                                            timeStamp = this.rs.getTimestamp(i);
                                            if (!this.isAddNull(rowData, timeStamp)) {
                                                rowData.add(timeStamp);
                                            }
                                            break block14;
                                        }
                                        if (!this.rs.getMetaData().getColumnClassName(i).equals("oracle.sql.TIMESTAMPTZ") && !this.rs.getMetaData().getColumnClassName(i).equals("oracle.sql.TIMESTAMPLTZ")) break block16;
                                        timeStamp = this.rs.getTimestamp(i, Calendar.getInstance(TimeZone.getTimeZone("")));
                                        if (!this.isAddNull(rowData, timeStamp)) {
                                            rowData.add(timeStamp);
                                        }
                                        break block14;
                                    }
                                    if (this.rs.getMetaData().getColumnType(i) != 2004) break block17;
                                    Blob blob = this.rs.getBlob(i);
                                    if (!this.isAddNull(rowData, blob)) {
                                        int size;
                                        boolean fullData2 = true;
                                        if (this.binaryDataSize == 0) {
                                            size = (int)blob.length();
                                        } else {
                                            size = this.binaryDataSize;
                                            if ((long)this.binaryDataSize < blob.length()) {
                                                fullData2 = false;
                                            }
                                        }
                                        rowData.add(new Binary(blob.getBytes(1L, size), fullData2));
                                    }
                                    break block14;
                                }
                                if (this.rs.getMetaData().getColumnType(i) != 2005 && this.selectColmunInfos.get(i - 1).getColumnClass() != Reader.class) break block18;
                                Clob clob = this.rs.getClob(i);
                                if (!this.isAddNull(rowData, clob)) {
                                    rowData.add(clob.getSubString(1L, (int)clob.length()));
                                }
                                break block14;
                            }
                            if (this.selectColmunInfos.get(i - 1).getColumnClass() != Binary.class) break block19;
                            b = null;
                            fullData = true;
                            if (this.binaryDataSize != 0) break block20;
                            b = this.rs.getBytes(i);
                            if (!this.isAddNull(rowData, b)) break block21;
                            break block14;
                        }
                        InputStream is = this.rs.getBinaryStream(i);
                        if (this.isAddNull(rowData, is)) break block14;
                        BufferedInputStream bis = new BufferedInputStream(is);
                        b = BinaryInputStream.readBytes(bis, this.binaryDataSize);
                        if (bis.read() != -1) {
                            fullData = false;
                        }
                        is.close();
                    }
                    rowData.add(new Binary(b, fullData));
                    break block14;
                }
                rowData.add(this.rs.getObject(i));
            }
            ++i;
        }
        return rowData;
    }

    private boolean isAddNull(Vector<Object> rowData, Object data) throws SQLException {
        if (this.rs.wasNull() || data == null) {
            rowData.add(null);
            return true;
        }
        return false;
    }

    private void closeSqlCursor() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }
}

