/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.JDialogPrepareStatementLog;
import jdbcacsess.sql.column.Binary;
import jdbcacsess.sql.column.BinaryInputStream;
import jdbcacsess.sql.column.CharacterInputStream;

public class PrepareExecute {
    ArrayList<Object> parmList;
    private PreparedStatement pstmt = null;
    StringBuffer statement = new StringBuffer();

    public PrepareExecute() {
        this.parmList = new ArrayList();
    }

    public void addStm(String stm) {
        this.statement.append(stm);
    }

    public String getStm() {
        return this.statement.toString();
    }

    public void addParm(Object value) {
        this.parmList.add(value);
    }

    public void prepare(Connection con) throws SQLException {
        System.out.println(con + " " + this.statement.toString());
        this.pstmt = con.prepareStatement(this.statement.toString());
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet rs = null;
        try {
            try {
                this.setParm();
                rs = this.pstmt.executeQuery();
            }
            catch (OutOfMemoryError err) {
                throw new SQLException(err.getMessage());
            }
        }
        finally {
            this.clearParm();
        }
        return rs;
    }

    public int executeUpdate() throws SQLException {
        int cnt;
        try {
            try {
                this.setParm();
                cnt = this.pstmt.executeUpdate();
            }
            catch (OutOfMemoryError err) {
                throw new SQLException(err.getMessage());
            }
        }
        finally {
            this.clearParm();
        }
        return cnt;
    }

    private void setParm() throws SQLException {
        int i = 0;
        while (i < this.parmList.size()) {
            Object value = this.parmList.get(i);
            if (value == null) {
                this.pstmt.setNull(i + 1, 0);
            } else if (value instanceof BinaryInputStream) {
                BinaryInputStream bis = (BinaryInputStream)value;
                this.pstmt.setBinaryStream(i + 1, bis.getInputStream(), bis.getSize());
            } else if (value instanceof CharacterInputStream) {
                CharacterInputStream cis = (CharacterInputStream)value;
                this.pstmt.setCharacterStream(i + 1, cis.getReader(), cis.getSize());
            } else if (value instanceof Binary) {
                this.pstmt.setBytes(i + 1, ((Binary)value).getValue());
            } else {
                this.pstmt.setObject(i + 1, value);
            }
            ++i;
        }
        if (JFrameMain.debugMode) {
            StringBuilder sb = new StringBuilder("PrepareExecute:" + this.statement + "#");
            for (Object o : this.parmList) {
                sb.append(o == null ? "null" : o.toString());
                sb.append("$");
            }
            sb.append("\n");
            JDialogPrepareStatementLog a = JDialogPrepareStatementLog.getInstance();
            a.appendLog(sb);
        }
    }

    private void clearParm() {
        for (Object item : this.parmList) {
            if (item instanceof BinaryInputStream) {
                BinaryInputStream bis = (BinaryInputStream)item;
                try {
                    bis.getInputStream().close();
                }
                catch (IOException e) {
                    JDialogMessage.errorDialog(e);
                }
            }
            if (!(item instanceof CharacterInputStream)) continue;
            CharacterInputStream cis = (CharacterInputStream)item;
            try {
                cis.getReader().close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        this.parmList.clear();
    }

    public int prepareExecuteUpdate(Connection con) throws SQLException {
        this.prepare(con);
        return this.executeUpdate();
    }
}

