/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.gui.CellDataAccsess;
import jdbcacsess.gui.CellInfo;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JDialogTextEditer;
import jdbcacsess.gui.JFrameHexViewer;
import jdbcacsess.gui.RowInsertValueMode;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.PrepareExecute;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlAnalyze;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableSqlModel
extends AbstractTableModel
implements QueryExecuteListener {
    private static final long serialVersionUID = 1L;
    private List<String> headerList;
    private List<List<CellInfo>> detailList;
    private Vector<ColumnInfoResult> columnInfoResults;
    private SqlAnalyze sqlAnalyze;
    private int insertRowIndex = -1;
    private Connection con;
    PrepareExecute peu;
    int rowIndex;
    int colIndex;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public JTableSqlModel(Connection con) {
        this.init();
        this.con = con;
        this.sqlAnalyze = new SqlAnalyze("");
    }

    @Override
    public void init() {
        this.headerList = Collections.synchronizedList(new ArrayList());
        this.detailList = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void setResultHeader(Vector<ColumnInfoResult> headerData, SqlAnalyze sqlAnalyze) {
        this.columnInfoResults = headerData;
        for (ColumnInfoResult info : headerData) {
            this.headerList.add(info.getColumnName());
        }
        this.sqlAnalyze = sqlAnalyze;
        this.fireTableStructureChanged();
    }

    public ColumnInfoResult getColumnInfo(int idx) {
        return this.columnInfoResults.get(idx);
    }

    @Override
    public synchronized void setResultDetail(Vector detailData) {
        List<CellInfo> columnList = Collections.synchronizedList(new ArrayList());
        int i = 0;
        while (i < detailData.size()) {
            CellInfo cellInfo = new CellInfo();
            cellInfo.setInitialValue(detailData.get(i));
            columnList.add(cellInfo);
            ++i;
        }
        this.detailList.add(columnList);
        this.fireTableDataChanged();
        int cnt = this.detailList.size() % 5000;
        if (cnt == 0) {
            System.out.println("wait\u3057\u307e\u3059");
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                System.out.println("\u518d\u958b\u3057\u307e\u3059");
            }
        }
    }

    @Override
    public void completeQuery(QueryExecuteStatus breakStatus) {
        if (breakStatus.isErr()) {
            return;
        }
        if (this.detailList.isEmpty()) {
            List<CellInfo> newColumnList = Collections.synchronizedList(new ArrayList());
            newColumnList = Collections.synchronizedList(new ArrayList());
            int i = 0;
            while (i < this.columnInfoResults.size()) {
                CellInfo ci = new CellInfo();
                ci.setInitialValue("");
                ci.setMode(CellMode.CELL_DELETE);
                newColumnList.add(ci);
                ++i;
            }
            this.detailList.add(newColumnList);
            this.fireTableDataChanged();
        }
    }

    public SchemaTableName getTableName() {
        return this.sqlAnalyze.getSchemaTableName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnInfoResults.get(columnIndex).getColumnClass();
    }

    @Override
    public String getColumnName(int column) {
        return this.headerList.get(column);
    }

    @Override
    public int getColumnCount() {
        if (this.columnInfoResults == null) {
            return 0;
        }
        return this.columnInfoResults.size();
    }

    @Override
    public int getRowCount() {
        return this.detailList.size();
    }

    private CellInfo getCellInfo(int rowIndex, int columnIndex) {
        List<CellInfo> columnList = this.detailList.get(rowIndex);
        return columnList.get(columnIndex);
    }

    private void setCellInfo(int rowIdx, int colIdx, CellMode cellMode) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        cellInfo.setMode(cellMode);
    }

    private void setUpdateCompleteValue(int rowIdx, int colIdx, Object aValue) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        cellInfo.setUpdateCompleteValue(aValue);
        cellInfo.setDefaultInsert(false);
    }

    private void setInsertValue(int rowIdx, int colIdx, Object aValue) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        cellInfo.setInsertValue(aValue);
        cellInfo.setDefaultInsert(false);
    }

    @Override
    public Object getValueAt(int rowIdx, int colIdx) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        return cellInfo.getValue();
    }

    public CellMode getMode(int rowIndex, int columnIndex) {
        return this.getCellInfo(rowIndex, columnIndex).getMode();
    }

    public boolean isDefaultInsert(int rowIndex, int columnIndex) {
        return this.getCellInfo(rowIndex, columnIndex).isDefaultInsert();
    }

    public void setDefaultInsert(boolean defaultInsert, int rowIndex, int columnIndex) {
        this.getCellInfo(rowIndex, columnIndex).setDefaultInsert(defaultInsert);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.sqlAnalyze.isSelectUpdatable()) {
            return false;
        }
        return this.getCellInfo(rowIndex, columnIndex).isCellEditable();
    }

    public boolean isTableEditable() {
        return this.sqlAnalyze.isSelectUpdatable();
    }

    @Override
    public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
        if (this.getMode(rowIndex, columnIndex) == CellMode.CELL_INSERT) {
            this.setInsertValue(rowIndex, columnIndex, aValue);
            return;
        }
        final PrepareExecute peu = new PrepareExecute();
        peu.addStm("UPDATE " + this.sqlAnalyze.getSchemaTableName());
        peu.addStm(" SET " + this.columnInfoResults.get(columnIndex).getColumnName() + " = ?");
        peu.addParm(aValue);
        this.editWherePhrase(peu, rowIndex);
        this.setCellInfo(rowIndex, columnIndex, CellMode.CELL_UPDATE);
        this.fireTableCellUpdated(rowIndex, columnIndex);
        new Thread(){

            public void run() {
                try {
                    int cnt = peu.prepareExecuteUpdate(JTableSqlModel.this.con);
                    if (cnt != 1) {
                        throw new Exception("\u66f4\u65b0\u4ef6\u6570\u304c\uff11\u4ef6\u3067\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u4ef6\u6570=" + cnt);
                    }
                }
                catch (SQLException e) {
                    JDialogMessage.sqlErrorDialog(e, "\u30ab\u30e9\u30e0\u66f4\u65b0");
                    return;
                }
                catch (Exception e) {
                    JDialogMessage.errorDialog(e);
                    return;
                }
                JTableSqlModel.this.setUpdateCompleteValue(rowIndex, columnIndex, aValue);
                JTableSqlModel.this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }.start();
    }

    private void editWherePhrase(PrepareExecute peu, int rowIndex) {
        peu.addStm(" WHERE ");
        boolean isFirst = true;
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            ColumnInfoResult colInfo = this.columnInfoResults.get(i);
            if (colInfo.isPrimaryKey()) {
                if (isFirst) {
                    peu.addStm(" ");
                    isFirst = false;
                } else {
                    peu.addStm(" AND ");
                }
                peu.addStm(String.valueOf(colInfo.getColumnName()) + " = ?");
                peu.addParm(this.getCellInfo(rowIndex, i).getValue());
            }
            ++i;
        }
    }

    public void rowDelete(final int[] rowIndexs) {
        new Thread(){

            public void run() {
                int[] nArray = rowIndexs;
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    int rowIndex = nArray[n];
                    switch (JTableSqlModel.this.getMode(rowIndex, 0)) {
                        case CELL_INSERT: {
                            JTableSqlModel.this.insertRowIndex = -1;
                            JTableSqlModel.this.detailList.remove(rowIndex);
                            break;
                        }
                        case CELL_DELETE: 
                        case CELL_DELETE_COMPLETE: {
                            break;
                        }
                        default: {
                            for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(rowIndex)) {
                                cellInfo.setMode(CellMode.CELL_DELETE);
                            }
                            PrepareExecute peu = new PrepareExecute();
                            peu.addStm("DELETE FROM " + JTableSqlModel.this.sqlAnalyze.getSchemaTableName());
                            JTableSqlModel.this.editWherePhrase(peu, rowIndex);
                            try {
                                int cnt = peu.prepareExecuteUpdate(JTableSqlModel.this.con);
                                if (cnt != 1) {
                                    throw new Exception("\u524a\u9664\u4ef6\u6570\u304c\uff11\u4ef6\u3067\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u4ef6\u6570=" + cnt);
                                }
                            }
                            catch (SQLException e) {
                                JDialogMessage.sqlErrorDialog(e, "\u884c\u524a\u9664");
                                return;
                            }
                            catch (Exception e) {
                                JDialogMessage.errorDialog(e);
                                return;
                            }
                            for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(rowIndex)) {
                                cellInfo.setMode(CellMode.CELL_DELETE_COMPLETE);
                            }
                        }
                    }
                    JTableSqlModel.this.fireTableRowsDeleted(rowIndex, rowIndex);
                    ++n;
                }
            }
        }.start();
    }

    public void rowCopy(int orgRowIndex, RowInsertValueMode insertMode) {
        if (this.insertRowIndex != -1) {
            return;
        }
        List<CellInfo> newColumnList = Collections.synchronizedList(new ArrayList());
        switch (insertMode) {
            case VALUEROWNEW: {
                this.createInsertRowData(newColumnList);
                break;
            }
            case ALLNULLROWNEW: {
                this.createInsertRowNull(newColumnList);
                break;
            }
            case ROWCOPY: {
                for (CellInfo cellInfo : this.detailList.get(orgRowIndex)) {
                    newColumnList.add(cellInfo.copy());
                }
                break;
            }
        }
        this.insertRowIndex = orgRowIndex;
        this.detailList.add(this.insertRowIndex, newColumnList);
        this.fireTableDataChanged();
    }

    private void createInsertRowData(List<CellInfo> newColumnList) {
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            CellInfo ci = new CellInfo();
            Class<?> c = this.getColumnClass(i);
            try {
                if (String.class.isAssignableFrom(c)) {
                    ci.setInsertValue(this.getColumnInfo(i).isNullable() ? null : "a");
                } else if (Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
                    ci.setInsertValue(c.getConstructor(String.class).newInstance("0"));
                } else if (Date.class.isAssignableFrom(c)) {
                    ci.setInsertValue(c.getConstructor(Long.TYPE).newInstance(new Long(new Date().getTime())));
                } else if (Object.class == c) {
                    ci.setInsertValue(null);
                } else {
                    ci.setInsertValue(c.newInstance());
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            newColumnList.add(ci);
            ++i;
        }
    }

    private void createInsertRowNull(List<CellInfo> newColumnList) {
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            CellInfo ci = new CellInfo();
            ci.setInsertValue(null);
            newColumnList.add(ci);
            ++i;
        }
    }

    public void rowInsert(int selectRowIndex) {
        if (this.insertRowIndex == -1) {
            return;
        }
        System.out.println("Insert\u5bfe\u8c61\u884c:" + this.insertRowIndex + " " + "\u9078\u629e\u884c:" + selectRowIndex);
        if (selectRowIndex == this.insertRowIndex) {
            return;
        }
        final PrepareExecute peu = new PrepareExecute();
        peu.addStm("INSERT INTO " + this.sqlAnalyze.getSchemaTableName() + "(");
        int cnt = 0;
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            if (!this.isDefaultInsert(this.insertRowIndex, i)) {
                if (cnt != 0) {
                    peu.addStm(",");
                }
                peu.addStm(this.columnInfoResults.get(i).getColumnName());
                ++cnt;
            }
            ++i;
        }
        peu.addStm(") VALUES(");
        List<CellInfo> cellInfoList = this.detailList.get(this.insertRowIndex);
        cnt = 0;
        int i2 = 0;
        while (i2 < cellInfoList.size()) {
            if (!this.isDefaultInsert(this.insertRowIndex, i2)) {
                if (cnt != 0) {
                    peu.addStm(",");
                }
                peu.addStm("?");
                peu.addParm(cellInfoList.get(i2).getValue());
                ++cnt;
            }
            ++i2;
        }
        peu.addStm(")");
        new Thread(){

            public void run() {
                try {
                    int cnt = peu.prepareExecuteUpdate(JTableSqlModel.this.con);
                    if (cnt != 1) {
                        throw new Exception("\u633f\u5165\u4ef6\u6570\u304c\uff11\u4ef6\u3067\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u4ef6\u6570=" + cnt);
                    }
                }
                catch (SQLException e) {
                    JDialogMessage.sqlErrorDialog(e, "\u884c\u633f\u5165");
                    return;
                }
                catch (Exception e) {
                    JDialogMessage.errorDialog(e);
                    return;
                }
                for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(JTableSqlModel.this.insertRowIndex)) {
                    cellInfo.setMode(CellMode.CELL_INSERT_COMPLETE);
                }
                JTableSqlModel.this.insertRowIndex = -1;
                JTableSqlModel.this.fireTableDataChanged();
            }
        }.start();
    }

    public synchronized void nextSearch() {
        this.notify();
    }

    public boolean isAllCellEdit() {
        return this.sqlAnalyze.isSelectUpdatable();
    }

    @Override
    public void status(QueryExecuteStatus breakStatus) {
    }

    @Override
    public void errorException(Exception ex) {
    }

    private ResultSet selectUniqColumn(int rowIndex, int col) throws NoDataException, SQLException {
        this.peu = new PrepareExecute();
        this.peu.addStm("SELECT " + this.getColumnName(col) + " FROM " + this.sqlAnalyze.getSchemaTableName());
        this.editWherePhrase(this.peu, rowIndex);
        this.peu.prepare(this.con);
        ResultSet rs = this.peu.executeQuery();
        if (!rs.next()) {
            throw new NoDataException("\u30c7\u30fc\u30bf\u3092\u691c\u7d22\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        return rs;
    }

    private void checkNull(Object o) throws NullSelectException {
        if (o == null) {
            throw new NullSelectException("\u691c\u7d22\u7d50\u679c\u304cnull\u3067\u3057\u305f");
        }
    }

    public void hexViewer(int rowIndex, int colIndex, CellDataAccsess cellDataAccess) {
        ResultSet rs = null;
        try {
            try {
                rs = this.selectUniqColumn(rowIndex, colIndex);
                switch (cellDataAccess) {
                    case GETBYTES: {
                        byte[] bytes = rs.getBytes(1);
                        this.checkNull(bytes);
                        JFrameHexViewer.getInstance().setInputStream(new BufferedInputStream(new ByteArrayInputStream(bytes)), bytes.length, this.peu.getStm());
                        break;
                    }
                    case GETBINARYSTREAM: {
                        InputStream is = rs.getBinaryStream(1);
                        this.checkNull(is);
                        JFrameHexViewer.getInstance().setInputStream(new BufferedInputStream(is), -1L, this.peu.getStm());
                        break;
                    }
                    case GETBLOB: {
                        Blob blob = rs.getBlob(1);
                        this.checkNull(blob);
                        JFrameHexViewer.getInstance().setInputStream(new BufferedInputStream(blob.getBinaryStream()), (int)blob.length(), this.peu.getStm());
                        break;
                    }
                    case GETSTRING: {
                        String str = rs.getString(1);
                        this.checkNull(str);
                        JFrameHexViewer.getInstance().setInputStream(new ByteArrayInputStream(str.getBytes()), -1L, this.peu.getStm());
                    }
                }
            }
            catch (SQLException e) {
                JDialogMessage.sqlErrorDialog(e, "\u30d3\u30e5\u30fc\u30ef");
            }
            catch (Exception e) {
                JDialogMessage.errorDialog(e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    JDialogMessage.sqlErrorDialog(e, "\u7d50\u679c\u30bb\u30c3\u30c8\u306e\u30af\u30ed\u30fc\u30ba\u5931\u6557");
                }
            }
        }
    }

    public void outputFile(int rowIndex, int colIndex, CellDataAccsess cellDataAccess, File file) {
        ResultSet rs = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            try {
                rs = this.selectUniqColumn(rowIndex, colIndex);
                switch (cellDataAccess) {
                    case OUTPUTFILE_BINARY: {
                        int c;
                        InputStream is = rs.getBinaryStream(1);
                        this.checkNull(is);
                        bis = new BufferedInputStream(is);
                        bos = new BufferedOutputStream(new FileOutputStream(file));
                        while ((c = bis.read()) != -1) {
                            ((BufferedOutputStream)bos).write(c);
                        }
                        break;
                    }
                    case OUTPUTFILE_CHARACTER: {
                        int c;
                        Reader r = rs.getCharacterStream(1);
                        this.checkNull(r);
                        br = new BufferedReader(r);
                        bw = new BufferedWriter(new FileWriter(file));
                        while ((c = br.read()) != -1) {
                            bw.write(c);
                        }
                        break;
                    }
                }
            }
            catch (SQLException e) {
                JDialogMessage.sqlErrorDialog(e, "\u30d3\u30e5\u30fc\u30ef");
            }
            catch (Exception e) {
                JDialogMessage.errorDialog(e);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    JDialogMessage.sqlErrorDialog(e, "\u7d50\u679c\u30bb\u30c3\u30c8\u306e\u30af\u30ed\u30fc\u30ba\u5931\u6557");
                }
            }
        }
    }

    public void textEditer(int rowIndex, int colIndex) {
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        ResultSet rs = null;
        JDialogTextEditer textEditer = new JDialogTextEditer();
        try {
            try {
                rs = this.selectUniqColumn(rowIndex, colIndex);
                String text = rs.getString(1);
                textEditer.setText(text);
                textEditer.setUpdaer(this);
                textEditer.setVisible(true);
            }
            catch (SQLException e) {
                JDialogMessage.sqlErrorDialog(e, "\u30c6\u30ad\u30b9\u30c8\u7de8\u96c6");
            }
            catch (Exception e) {
                JDialogMessage.errorDialog(e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    JDialogMessage.sqlErrorDialog(e, "\u7d50\u679c\u30bb\u30c3\u30c8\u306e\u30af\u30ed\u30fc\u30ba\u5931\u6557");
                }
            }
            textEditer.dispose();
        }
    }

    public void currentCelUpdate(String str) {
        this.setValueAt(str, this.rowIndex, this.colIndex);
    }

    class NoDataException
    extends Exception {
        private static final long serialVersionUID = -4983600633439714974L;

        NoDataException(String s) {
            super(s);
        }
    }

    class NullSelectException
    extends Exception {
        private static final long serialVersionUID = 1430603401964015018L;

        NullSelectException(String s) {
            super(s);
        }
    }
}

