/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jdbcacsess.JPopupMenuCnageUI;
import jdbcacsess.csv.CSVLine;
import jdbcacsess.gui.CellDataAccsess;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.JTableSqlModel;
import jdbcacsess.gui.RowInsertValueMode;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.QueryExecuteAdapter;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.column.BinaryInputStream;
import jdbcacsess.sql.column.CharacterInputStream;

public class JTableSql
extends JTable
implements ClipboardOwner {
    private static final long serialVersionUID = -3304832537800845261L;
    private JPopupMenuCnageUI jPopupMenu = null;
    private JMenuItem jMenuItemSetNULL = null;
    private JMenuItem jMenuItemToClipRangeComma = null;
    private JMenuItem jMenuItemRowDelete = null;
    private JMenuItem jMenuItemRowInsert = null;
    private JMenuItem jMenuItemRowInsertNull = null;
    private JMenuItem jMenuItemRowCopy = null;
    private int row;
    private int col;
    private JMenuItem jMenuItemToClipRangeTab = null;
    private JMenuItem jMenuItemDefaultInsert = null;
    private JMenuItem jMenuItemSelectRow = null;
    private JMenuItem jMenuItemSelectAll = null;
    private JMenuItem jMenuItemViewerGetBinaryStream = null;
    private JMenu jMenuViewer = null;
    private JMenuItem jMenuItemViewerGetBlob = null;
    private JMenuItem jMenuItemViewerGetBytes;
    private JMenu jMenuInputFile = null;
    private JMenuItem jMenuItemInputFileBinary = null;
    private JMenuItem jMenuItemInputFileCharacter = null;
    private JMenu jMenuOutputFile = null;
    private JMenuItem jMenuItemOutputFileBinary = null;
    private JMenuItem jMenuItemOutputFileCharcter = null;
    private JMenuItem jMenuItemTextEditer = null;
    private JMenuItem jMenuItemViewerGetString = null;

    public JTableSql() {
        this.initialize();
    }

    private void initialize() {
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(1);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }
        });
        ListSelectionModel model = this.getSelectionModel();
        model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JTableSql.this.editTable_selectionvalueChanged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTableSql.this.actionPerformedPopuUp(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTableSql.this.actionPerformedPopuUp(e);
                }
            }
        });
        this.getJPopupMenu();
    }

    private void actionPerformedPopuUp(MouseEvent e) {
        this.row = this.rowAtPoint(e.getPoint());
        this.col = this.columnAtPoint(e.getPoint());
        if (!this.isCellSelected(this.row, this.col)) {
            this.setRowSelectionInterval(this.row, this.row);
            this.setColumnSelectionInterval(this.col, this.col);
        }
        JTableSqlModel model = (JTableSqlModel)this.getModel();
        CellMode cellMode = model.getMode(this.row, this.col);
        if (model.isCellEditable(this.row, this.col)) {
            this.jMenuItemRowDelete.setEnabled(true);
            this.jMenuItemRowCopy.setEnabled(true);
        } else {
            if (cellMode == CellMode.CELL_INSERT) {
                this.jMenuItemRowDelete.setEnabled(true);
            } else {
                this.jMenuItemRowDelete.setEnabled(false);
            }
            this.jMenuItemRowCopy.setEnabled(false);
        }
        this.jMenuItemSetNULL.setEnabled(false);
        if (model.isTableEditable()) {
            switch (cellMode) {
                case CELL_NON: 
                case CELL_UPDATE: 
                case CELL_UPDATE_COMPLETE: 
                case CELL_INSERT: 
                case CELL_INSERT_COMPLETE: 
                case CELL_DENYEDIT_IN_CELL: {
                    this.jMenuItemSetNULL.setEnabled(true);
                }
            }
        }
        this.jMenuViewer.setEnabled(false);
        this.jMenuInputFile.setEnabled(false);
        this.jMenuItemTextEditer.setEnabled(false);
        this.jMenuOutputFile.setEnabled(false);
        if (model.isTableEditable()) {
            switch (cellMode) {
                case CELL_NON: 
                case CELL_UPDATE: 
                case CELL_UPDATE_COMPLETE: 
                case CELL_INSERT_COMPLETE: 
                case CELL_DENYEDIT_IN_CELL: {
                    this.jMenuViewer.setEnabled(true);
                    this.jMenuInputFile.setEnabled(true);
                    this.jMenuItemTextEditer.setEnabled(true);
                    this.jMenuOutputFile.setEnabled(true);
                }
            }
        }
        if (cellMode == CellMode.CELL_INSERT) {
            this.jMenuItemDefaultInsert.setEnabled(true);
            if (model.isDefaultInsert(this.row, this.col)) {
                this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916\u3057\u306a\u3044");
            } else {
                this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916\u3059\u308b");
            }
        } else {
            this.jMenuItemDefaultInsert.setEnabled(false);
        }
        this.jPopupMenu.show(this, e.getX(), e.getY());
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u6240\u6709\u6a29\u3092\u5931\u3044\u307e\u3057\u305f");
    }

    private void actionPerformedCopyRange(char delim) {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        String lineSeparator = System.getProperty("line.separator");
        JTableSqlModel tbl = (JTableSqlModel)this.getModel();
        int countCol = this.getSelectedColumnCount();
        int countRow = this.getSelectedRowCount();
        int[] selCols = this.getSelectedColumns();
        int[] selRows = this.getSelectedRows();
        StringBuffer selectString = new StringBuffer();
        int idxCol = 0;
        while (idxCol < countCol) {
            if (idxCol != 0) {
                selectString.append(delim);
            }
            selectString.append(tbl.getColumnName(selCols[idxCol]));
            ++idxCol;
        }
        selectString.append(lineSeparator);
        int idxRow = 0;
        while (idxRow < countRow) {
            CellMode cellMode = tbl.getMode(idxRow, 0);
            if (cellMode != CellMode.CELL_DELETE_COMPLETE) {
                CSVLine csvline = new CSVLine();
                csvline.setToken(delim);
                int idxCol2 = 0;
                while (idxCol2 < countCol) {
                    Object o = tbl.getValueAt(selRows[idxRow], selCols[idxCol2]);
                    if (o != null) {
                        csvline.addItem(o.toString());
                    } else {
                        csvline.addItem(JFrameMain.CSVNULLVALUE);
                    }
                    ++idxCol2;
                }
                if (csvline.size() != 0) {
                    selectString.append(csvline.getLine()).append(lineSeparator);
                }
            }
            ++idxRow;
        }
        StringSelection ss = new StringSelection(selectString.toString());
        cb.setContents(ss, this);
    }

    private void actionPerformedSetNULL(ActionEvent e) {
        TableModel tbl = this.getModel();
        int[] nArray = this.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int row = nArray[n];
            int[] nArray2 = this.getSelectedColumns();
            int n3 = 0;
            int n4 = nArray2.length;
            while (n3 < n4) {
                int col = nArray2[n3];
                tbl.setValueAt(null, row, col);
                ++n3;
            }
            ++n;
        }
    }

    private void actionPerformedDefaultInsert(ActionEvent e) {
        JTableSqlModel tbl = (JTableSqlModel)this.getModel();
        int[] nArray = this.getSelectedColumns();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int col = nArray[n];
            tbl.setDefaultInsert(!tbl.isDefaultInsert(this.row, col), this.row, col);
            ++n;
        }
    }

    private void actionPerformedRowDelete(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowDelete(this.getSelectedRows());
    }

    private void actionPerformedRowInsert(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.VALUEROWNEW);
    }

    private void actionPerformedRowInsertNull(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.ALLNULLROWNEW);
    }

    private void actionPerformedRowCopy(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.ROWCOPY);
    }

    private void editTable_selectionvalueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getSelectedRow() == -1) {
            return;
        }
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowInsert(this.getSelectedRow());
    }

    protected void actionPerformedHexViewer(CellDataAccsess cellDataAccess) {
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            JDialogMessage.infoDialog("\uff11\u30bb\u30eb\u3060\u3051\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", "\u9078\u629e\u30bb\u30eb\u30a8\u30e9\u30fc");
            return;
        }
        int selectedRow = this.getSelectedRows()[0];
        int selectedCol = this.getSelectedColumns()[0];
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.hexViewer(selectedRow, selectedCol, cellDataAccess);
    }

    private void actionPerformedFileInputOutput(CellDataAccsess cellDataAccess) {
        int returnVal;
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            JDialogMessage.infoDialog("\uff11\u30bb\u30eb\u3060\u3051\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", "\u9078\u629e\u30bb\u30eb\u30a8\u30e9\u30fc");
            return;
        }
        int selectedRow = this.getSelectedRows()[0];
        int selectedCol = this.getSelectedColumns()[0];
        JFileChooser chooser = new JFileChooser();
        if (cellDataAccess == CellDataAccsess.INPUTFILE_BINARY || cellDataAccess == CellDataAccsess.INPUTFILE_CHARACTER) {
            chooser.setDialogTitle("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044");
            chooser.setDialogType(0);
            returnVal = chooser.showOpenDialog(this);
        } else {
            chooser.setDialogTitle("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044");
            chooser.setDialogType(1);
            returnVal = chooser.showSaveDialog(this);
        }
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
            try {
                switch (cellDataAccess) {
                    case INPUTFILE_BINARY: {
                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                        sqlTableModel.setValueAt(new BinaryInputStream(is, (int)f.length()), selectedRow, selectedCol);
                        break;
                    }
                    case INPUTFILE_CHARACTER: {
                        BufferedReader r = new BufferedReader(new FileReader(f));
                        sqlTableModel.setValueAt(new CharacterInputStream(r, (int)f.length()), selectedRow, selectedCol);
                        break;
                    }
                    default: {
                        sqlTableModel.outputFile(selectedRow, selectedCol, cellDataAccess, f);
                        break;
                    }
                }
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
    }

    protected void actionPerformedTextEditer() {
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            JDialogMessage.infoDialog("\uff11\u30bb\u30eb\u3060\u3051\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", "\u9078\u629e\u30bb\u30eb\u30a8\u30e9\u30fc");
            return;
        }
        int selectedRow = this.getSelectedRows()[0];
        int selectedCol = this.getSelectedColumns()[0];
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.textEditer(selectedRow, selectedCol);
    }

    private JPopupMenuCnageUI getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenuCnageUI();
            this.jPopupMenu.add(this.getJMenuItemSetNULL());
            this.jPopupMenu.add(this.getJMenuItemDefaultInsert());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowDelete());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowInsert());
            this.jPopupMenu.add(this.getJMenuItemRowInsertNull());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowCopy());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemToClipRangeComma());
            this.jPopupMenu.add(this.getJMenuItemToClipRangeTab());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemSelectRow());
            this.jPopupMenu.add(this.getJMenuItemSelectAll());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuViewer());
            this.jPopupMenu.add(this.getJMenuOutputFile());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemTextEditer());
            this.jPopupMenu.add(this.getJMenuInputFile());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemSetNULL() {
        if (this.jMenuItemSetNULL == null) {
            this.jMenuItemSetNULL = new JMenuItem();
            this.jMenuItemSetNULL.setText("NULL\u306b\u66f4\u65b0");
            this.jMenuItemSetNULL.setToolTipText("SQL\u306eNULL\u5024\u306b\u66f4\u65b0\u3057\u307e\u3059");
            this.jMenuItemSetNULL.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedSetNULL(e);
                }
            });
        }
        return this.jMenuItemSetNULL;
    }

    private JMenuItem getJMenuItemToClipRangeComma() {
        if (this.jMenuItemToClipRangeComma == null) {
            this.jMenuItemToClipRangeComma = new JMenuItem();
            this.jMenuItemToClipRangeComma.setText("\u30ab\u30f3\u30de\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc");
            this.jMenuItemToClipRangeComma.setToolTipText("<html>\u5404\u30ab\u30e9\u30e0\u3092\u30ab\u30f3\u30de\u3067\u7e4b\u3052\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u3078\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002<br>\uff11\u884c\u76ee\u306f\u30ab\u30e9\u30e0\u540d\u304c\u81ea\u52d5\u7684\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059\u3002</html>");
            this.jMenuItemToClipRangeComma.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedCopyRange(',');
                }
            });
        }
        return this.jMenuItemToClipRangeComma;
    }

    private JMenuItem getJMenuItemRowDelete() {
        if (this.jMenuItemRowDelete == null) {
            this.jMenuItemRowDelete = new JMenuItem();
            this.jMenuItemRowDelete.setText("\u884c\u524a\u9664");
            this.jMenuItemRowDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowDelete(e);
                }
            });
        }
        return this.jMenuItemRowDelete;
    }

    private JMenuItem getJMenuItemRowInsert() {
        if (this.jMenuItemRowInsert == null) {
            this.jMenuItemRowInsert = new JMenuItem();
            this.jMenuItemRowInsert.setText("\u5024\u8a2d\u5b9a\u6e08\u884c\u633f\u5165");
            this.jMenuItemRowInsert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowInsert(e);
                }
            });
        }
        return this.jMenuItemRowInsert;
    }

    private JMenuItem getJMenuItemRowInsertNull() {
        if (this.jMenuItemRowInsertNull == null) {
            this.jMenuItemRowInsertNull = new JMenuItem();
            this.jMenuItemRowInsertNull.setText("null\u5024\u884c\u633f\u5165");
            this.jMenuItemRowInsertNull.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowInsertNull(e);
                }
            });
        }
        return this.jMenuItemRowInsertNull;
    }

    private JMenuItem getJMenuItemRowCopy() {
        if (this.jMenuItemRowCopy == null) {
            this.jMenuItemRowCopy = new JMenuItem();
            this.jMenuItemRowCopy.setText("\u884c\u8907\u5199");
            this.jMenuItemRowCopy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowCopy(e);
                }
            });
        }
        return this.jMenuItemRowCopy;
    }

    private JMenuItem getJMenuItemToClipRangeTab() {
        if (this.jMenuItemToClipRangeTab == null) {
            this.jMenuItemToClipRangeTab = new JMenuItem();
            this.jMenuItemToClipRangeTab.setText("\u30bf\u30d6\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc");
            this.jMenuItemToClipRangeTab.setToolTipText("<html>\u5404\u30ab\u30e9\u30e0\u3092\u30bf\u30d6\u3067\u7e4b\u3052\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u3078\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002<br>\uff11\u884c\u76ee\u306f\u30ab\u30e9\u30e0\u540d\u304c\u81ea\u52d5\u7684\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059\u3002</html>");
            this.jMenuItemToClipRangeTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedCopyRange('\t');
                }
            });
        }
        return this.jMenuItemToClipRangeTab;
    }

    private JMenuItem getJMenuItemDefaultInsert() {
        if (this.jMenuItemDefaultInsert == null) {
            this.jMenuItemDefaultInsert = new JMenuItem();
            this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916");
            this.jMenuItemDefaultInsert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedDefaultInsert(e);
                }
            });
        }
        return this.jMenuItemDefaultInsert;
    }

    private JMenuItem getJMenuItemSelectRow() {
        if (this.jMenuItemSelectRow == null) {
            this.jMenuItemSelectRow = new JMenuItem();
            this.jMenuItemSelectRow.setText("\u884c\u9078\u629e");
            this.jMenuItemSelectRow.setToolTipText("\u30bb\u30eb\u9078\u629e\u3092\u884c\u9078\u629e\u3078\u62e1\u5927\u3057\u307e\u3059\u3002");
            this.jMenuItemSelectRow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.setColumnSelectionInterval(0, JTableSql.this.getColumnCount() - 1);
                }
            });
        }
        return this.jMenuItemSelectRow;
    }

    private JMenuItem getJMenuItemSelectAll() {
        if (this.jMenuItemSelectAll == null) {
            this.jMenuItemSelectAll = new JMenuItem();
            this.jMenuItemSelectAll.setText("\u5168\u3066\u9078\u629e");
            this.jMenuItemSelectAll.setToolTipText("<html>\u691c\u7d22\u53d6\u5f97\u6e08\u30c7\u30fc\u30bf\u306e\u5168\u3066\u3092\u9078\u629e\u3057\u307e\u3059\u3002<br>\u7d99\u7d9a\u53d6\u5f97\u3059\u3079\u304d\u30c7\u30fc\u30bf\u304c\u6b8b\u3063\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u305d\u306e\u5206\u306f\u9078\u629e\u3055\u308c\u307e\u305b\u3093\u3002</html>");
            this.jMenuItemSelectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.selectAll();
                }
            });
        }
        return this.jMenuItemSelectAll;
    }

    private JMenu getJMenuViewer() {
        if (this.jMenuViewer == null) {
            this.jMenuViewer = new JMenu();
            this.jMenuViewer.setText("\u30d0\u30a4\u30ca\u30ea\u30d3\u30e5\u30fc\u30ef\u753b\u9762\u3067\u8868\u793a");
            this.jMenuViewer.setToolTipText("<html>\uff11\uff16\u9032\u6587\u5b57\u5217\u3067\uff11\u30d0\u30a4\u30c8\u305a\u3064\u8868\u793a\u3057\u307e\u3059\u3002<br>\u66f4\u65b0\u306f\u753b\u9762\u304b\u3089\u306f\u51fa\u6765\u306a\u3044\u306e\u3067\u3001\u300e\u30ab\u30e9\u30e0\u66f4\u65b0(\u30d5\u30a1\u30a4\u30eb\u304b\u3089)\u300f\u3067\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002</html>");
            this.jMenuViewer.add(this.getJMenuItemViewerGetBinaryStream());
            this.jMenuViewer.add(this.getJMenuItemViewerGetBlob());
            this.jMenuViewer.add(this.getJMenuItemViewerGetBytes());
            this.jMenuViewer.add(this.getJMenuItemViewerGetString());
        }
        return this.jMenuViewer;
    }

    private JMenuItem getJMenuItemViewerGetBinaryStream() {
        if (this.jMenuItemViewerGetBinaryStream == null) {
            this.jMenuItemViewerGetBinaryStream = new JMenuItem();
            this.jMenuItemViewerGetBinaryStream.setText("\u30d0\u30a4\u30ca\u30ea[getBinaryStream()]...");
            this.jMenuItemViewerGetBinaryStream.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedHexViewer(CellDataAccsess.GETBINARYSTREAM);
                }
            });
        }
        return this.jMenuItemViewerGetBinaryStream;
    }

    private JMenuItem getJMenuItemViewerGetBlob() {
        if (this.jMenuItemViewerGetBlob == null) {
            this.jMenuItemViewerGetBlob = new JMenuItem();
            this.jMenuItemViewerGetBlob.setText("\u30d0\u30a4\u30ca\u30ea[getBlob()]...");
            this.jMenuItemViewerGetBlob.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedHexViewer(CellDataAccsess.GETBLOB);
                }
            });
        }
        return this.jMenuItemViewerGetBlob;
    }

    private JMenuItem getJMenuItemViewerGetBytes() {
        if (this.jMenuItemViewerGetBytes == null) {
            this.jMenuItemViewerGetBytes = new JMenuItem();
            this.jMenuItemViewerGetBytes.setText("\u30d0\u30a4\u30ca\u30ea[getBytes()]...");
            this.jMenuItemViewerGetBytes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedHexViewer(CellDataAccsess.GETBYTES);
                }
            });
        }
        return this.jMenuItemViewerGetBytes;
    }

    private JMenuItem getJMenuItemViewerGetString() {
        if (this.jMenuItemViewerGetString == null) {
            this.jMenuItemViewerGetString = new JMenuItem();
            this.jMenuItemViewerGetString.setText("\u30c6\u30ad\u30b9\u30c8[getString()]...");
            this.jMenuItemViewerGetString.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedHexViewer(CellDataAccsess.GETSTRING);
                }
            });
        }
        return this.jMenuItemViewerGetString;
    }

    private JMenu getJMenuOutputFile() {
        if (this.jMenuOutputFile == null) {
            this.jMenuOutputFile = new JMenu();
            this.jMenuOutputFile.setText("\u30ab\u30e9\u30e0\u51fa\u529b(\u30d5\u30a1\u30a4\u30eb\u3078)");
            this.jMenuOutputFile.setToolTipText("\uff11\u30ab\u30e9\u30e0select\u3092\u518d\u767a\u884c\u3057\u3066\u3001\u7d50\u679c\u3092\uff11\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u8fbc\u307f\u307e\u3059");
            this.jMenuOutputFile.add(this.getJMenuItemOutputFileBinary());
            this.jMenuOutputFile.add(this.getJMenuItemOutputFileCharcter());
        }
        return this.jMenuOutputFile;
    }

    private JMenuItem getJMenuItemOutputFileBinary() {
        if (this.jMenuItemOutputFileBinary == null) {
            this.jMenuItemOutputFileBinary = new JMenuItem();
            this.jMenuItemOutputFileBinary.setText("\u30d0\u30a4\u30ca\u30ea[getBinaryStream()]...");
            this.jMenuItemOutputFileBinary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedFileInputOutput(CellDataAccsess.OUTPUTFILE_BINARY);
                }
            });
        }
        return this.jMenuItemOutputFileBinary;
    }

    private JMenuItem getJMenuItemOutputFileCharcter() {
        if (this.jMenuItemOutputFileCharcter == null) {
            this.jMenuItemOutputFileCharcter = new JMenuItem();
            this.jMenuItemOutputFileCharcter.setText("\u30c6\u30ad\u30b9\u30c8[getCharacterStream()]...");
            this.jMenuItemOutputFileCharcter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedFileInputOutput(CellDataAccsess.OUTPUTFILE_CHARACTER);
                }
            });
        }
        return this.jMenuItemOutputFileCharcter;
    }

    private JMenuItem getJMenuItemTextEditer() {
        if (this.jMenuItemTextEditer == null) {
            this.jMenuItemTextEditer = new JMenuItem();
            this.jMenuItemTextEditer.setText("\u30c6\u30ad\u30b9\u30c8\u7de8\u96c6...");
            this.jMenuItemTextEditer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedTextEditer();
                }
            });
        }
        return this.jMenuItemTextEditer;
    }

    private JMenu getJMenuInputFile() {
        if (this.jMenuInputFile == null) {
            this.jMenuInputFile = new JMenu();
            this.jMenuInputFile.setText("\u30ab\u30e9\u30e0\u66f4\u65b0(\u30d5\u30a1\u30a4\u30eb\u304b\u3089)");
            this.jMenuInputFile.setToolTipText("\uff11\u30d5\u30a1\u30a4\u30eb\u5206\u306e\u5185\u5bb9\u5168\u4f53\u3067\u3001\uff11\u30ab\u30e9\u30e0update\u3092\u767a\u884c\u3057\u307e\u3059");
            this.jMenuInputFile.add(this.getJMenuItemInputFileBinary());
            this.jMenuInputFile.add(this.getJMenuItemInputFileCharacter());
        }
        return this.jMenuInputFile;
    }

    private JMenuItem getJMenuItemInputFileBinary() {
        if (this.jMenuItemInputFileBinary == null) {
            this.jMenuItemInputFileBinary = new JMenuItem();
            this.jMenuItemInputFileBinary.setText("\u30d0\u30a4\u30ca\u30ea[setBinaryStream()]...");
            this.jMenuItemInputFileBinary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedFileInputOutput(CellDataAccsess.INPUTFILE_BINARY);
                }
            });
        }
        return this.jMenuItemInputFileBinary;
    }

    private JMenuItem getJMenuItemInputFileCharacter() {
        if (this.jMenuItemInputFileCharacter == null) {
            this.jMenuItemInputFileCharacter = new JMenuItem();
            this.jMenuItemInputFileCharacter.setText("\u30c6\u30ad\u30b9\u30c8[setCharacterStream]...");
            this.jMenuItemInputFileCharacter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedFileInputOutput(CellDataAccsess.INPUTFILE_CHARACTER);
                }
            });
        }
        return this.jMenuItemInputFileCharacter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class registCellRendererAndEditor
    extends QueryExecuteAdapter {
        @Override
        public void setResultHeader(Vector<ColumnInfoResult> rowData, SqlAnalyze sqlAnalyze) {
            Enumeration<TableColumn> cols = JTableSql.this.getColumnModel().getColumns();
            int idx = 0;
            while (cols.hasMoreElements()) {
                TableColumn col = cols.nextElement();
                col.setCellRenderer(rowData.get(idx).getTableCellRenderer());
                col.setCellEditor(rowData.get(idx).getTableCellEditor());
                ++idx;
            }
        }
    }
}

