/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JFrameHexViewer;
import jdbcacsess.sql.column.Binary;
import jdbcacsess.sql.column.BinaryInputStream;

public class JTableHexViewerModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6789596886192425027L;
    private static final int ROWBYTE = 32;
    private static final int BLOCKCNT = 64;
    private InputStream in;
    private Vector<byte[]> buf;
    private int bufSize;
    private boolean endOfStream = false;
    private int readCnt;
    private int baseBufSize;
    private JFrameHexViewer jFrameHexViewer;

    public JTableHexViewerModel(InputStream inputStream, long size, JFrameHexViewer viewer) {
        this.in = inputStream;
        this.jFrameHexViewer = viewer;
        this.bufSize = 512;
        long blockCnt = 0L;
        if (size > 0L && (blockCnt = size / 2048L) < (long)this.bufSize) {
            this.bufSize = (int)blockCnt + 1;
        }
        this.buf = new Vector(this.bufSize, this.bufSize);
        System.out.println("size(byte)=" + size + " blockCnt=" + blockCnt + " bufSize=" + this.bufSize);
        this.baseBufSize = this.bufSize;
        this.readCnt = 0;
        try {
            this.read(this.bufSize);
        }
        catch (IOException e) {
            this.clear();
            JDialogMessage.errorDialog(e);
        }
        catch (OutOfMemoryError error) {
            this.clear();
            JDialogMessage.errorDialog(new Exception(error));
        }
    }

    public int getRowCount() {
        if (this.endOfStream) {
            return this.getRealRowCount();
        }
        return (this.buf.size() + this.bufSize) * 64;
    }

    public int getColumnCount() {
        return 33;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "\u76f8\u5bfe\u4f4d\u7f6e";
        }
        return String.format("%02X", column - 1);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.in == null) {
            return null;
        }
        if (columnIndex == 0) {
            return String.format("%04X", rowIndex * 32);
        }
        --columnIndex;
        int blockIndex = rowIndex / 64;
        try {
            this.read(blockIndex);
        }
        catch (IOException e) {
            this.clear();
            JDialogMessage.errorDialog(e);
            return null;
        }
        catch (OutOfMemoryError error) {
            this.clear();
            JDialogMessage.errorDialog(new Exception(error));
            return null;
        }
        if (this.buf.size() <= blockIndex) {
            return null;
        }
        int idx = rowIndex % 64 * 32 + columnIndex;
        byte[] blockData = this.buf.get(blockIndex);
        if (idx < blockData.length) {
            return Binary.byteToHexString(blockData[idx]);
        }
        return null;
    }

    private void read(int blockIndex) throws IOException {
        byte[] rowBuf;
        if (this.endOfStream) {
            return;
        }
        if (blockIndex < this.buf.size()) {
            return;
        }
        int lastIdx = this.getRealRowCount();
        while ((rowBuf = BinaryInputStream.readBytes(this.in, 2048)) != null) {
            this.buf.add(rowBuf);
            if (blockIndex < this.buf.size()) break;
        }
        ++this.readCnt;
        if (rowBuf == null) {
            this.endOfStream = true;
            this.in.close();
            this.jFrameHexViewer.setDataSize(this.getDataSize());
            System.out.println("\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86 buf.size()=" + this.buf.size() + " bufSize=" + this.bufSize);
        } else {
            System.out.println("\u8aad\u307f\u8fbc\u307fend buf.size()=" + this.buf.size() + " bufSize=" + this.bufSize);
        }
        this.fireTableRowsInserted(lastIdx, this.getRealRowCount());
        this.bufSize = this.baseBufSize * (this.readCnt / 3 + 1);
    }

    private int getRealRowCount() {
        if (this.buf.size() == 0) {
            return 0;
        }
        byte[] block = this.buf.get(this.buf.size() - 1);
        int rowCntInLastBlock = (block.length - 1) / 32 + 1;
        return (this.buf.size() - 1) * 64 + rowCntInLastBlock;
    }

    private long getDataSize() {
        if (this.buf.size() == 0) {
            return 0L;
        }
        byte[] block = this.buf.get(this.buf.size() - 1);
        return (this.buf.size() - 1) * 64 * 32 + block.length;
    }

    public void clear() {
        if (this.in != null) {
            try {
                this.in.close();
                this.in = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.buf != null) {
            this.buf.clear();
        }
    }
}

