/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.JTableSqlModel;

public class CellRendererSqlTable
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 7761617446993569948L;
    static /* synthetic */ Class class$0;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int width;
        TableColumnModel tcm;
        TableColumn tc;
        String s;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!(table.getModel() instanceof JTableSqlModel)) {
            return this;
        }
        JTableSqlModel sqlTableModel = (JTableSqlModel)table.getModel();
        CellMode mode = sqlTableModel.getMode(row, column);
        if (!isSelected) {
            switch (mode) {
                case CELL_UPDATE: {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.RED);
                    break;
                }
                case CELL_UPDATE_COMPLETE: {
                    this.setForeground(Color.RED);
                    this.setBackground(Color.WHITE);
                    break;
                }
                case CELL_DELETE: {
                    this.setForeground(Color.LIGHT_GRAY);
                    this.setBackground(Color.BLACK);
                    break;
                }
                case CELL_DELETE_COMPLETE: {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.LIGHT_GRAY);
                    break;
                }
                case CELL_INSERT: {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLUE);
                    break;
                }
                case CELL_INSERT_COMPLETE: {
                    this.setForeground(Color.BLUE);
                    this.setBackground(Color.WHITE);
                    break;
                }
                case CELL_DENYEDIT_IN_CELL: {
                    this.setForeground(Color.MAGENTA);
                    this.setBackground(Color.WHITE);
                    break;
                }
                default: {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.WHITE);
                }
            }
        }
        if (sqlTableModel.getColumnInfo(column).isPrimaryKey()) {
            this.setFont(new Font("Dialog", 3, 14));
        } else {
            this.setFont(new Font("Dialog", 0, 14));
        }
        if (Number.class.isAssignableFrom(sqlTableModel.getColumnClass(column))) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        String msg = sqlTableModel.getColumnInfo(column).getColumnComment();
        if (mode == CellMode.CELL_DENYEDIT_IN_CELL) {
            this.setToolTipText("<html>" + msg + "<br>\u30bb\u30eb\u66f4\u65b0\u51fa\u6765\u307e\u305b\u3093\u3002\u4ee5\u4e0b\u306e\u3044\u305a\u308c\u304b\u306e\u5834\u5408\u3067\u3059\u3002<ol>" + "<li>\u30d0\u30a4\u30ca\u30ea\u8aad\u8fbc\u91cf\u3092\u8d85\u3048\u3066\u3044\u308b\uff1a\u30d0\u30a4\u30ca\u30ea\u8aad\u8fbc\u91cf\u3092\u4e0a\u3052\u3066\u518d\u691c\u7d22\u3057\u3066\u4e0b\u3055\u3044</li>" + "<li>\u6539\u884c\u3092\u542b\u3093\u3067\u3044\u308b\u30c6\u30ad\u30b9\u30c8\uff1a\u30c6\u30ad\u30b9\u30c8\u7de8\u96c6\u753b\u9762\u3067\u66f4\u65b0\u3057\u3066\u4e0b\u3055\u3044</li>" + "<li>\u300e\u30ab\u30e9\u30e0\u66f4\u65b0(\u30d5\u30a1\u30a4\u30eb\u304b\u3089)\u300f\u76f4\u5f8c\uff1a\u518d\u691c\u7d22\u3057\u3066\u4e0b\u3055\u3044</li>" + "</ol>");
        } else {
            this.setToolTipText(msg);
        }
        if (value == null) {
            this.setValue("#NULL#");
            this.setFont(new Font("Dialog", this.getFont().getStyle(), 10));
            this.setHorizontalAlignment(0);
        }
        if (sqlTableModel.isDefaultInsert(row, column)) {
            this.setValue("#DEFAULT#");
            this.setFont(new Font("Dialog", this.getFont().getStyle(), 10));
            this.setHorizontalAlignment(0);
        }
        if ((s = this.getText()) != null && ((tc = (tcm = table.getColumnModel()).getColumn(column)).getPreferredWidth() == 75 && table.getTableHeader().getResizingColumn() == null || mode == CellMode.CELL_INSERT || mode == CellMode.CELL_UPDATE) && (width = s.length() * 8) < 500 && tc.getWidth() < width) {
            tc.setPreferredWidth(width);
        }
        return this;
    }
}

