/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.PrepareExecute;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.column.Binary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImportSqlExecute {
    private SchemaTableName tbl;
    private ArrayList<String> lowHeader;
    private ArrayList<String> primeKeys;
    private ArrayList<ColumnInfoTable> columnInfoTables;
    private ArrayList<Integer> primeIdxOnCsv;
    private ArrayList<Integer> primeIdxOnTable;
    private ArrayList<Integer> columnIdxOnTable;
    private Connection con;
    private PrepareExecute insertOvpCmd = null;
    private PrepareExecute insertCavCmd = null;
    private PrepareExecute updateCmd = null;
    private PrepareExecute selectCountCmd = null;

    public CsvImportSqlExecute(Connection con, SchemaTableName tbl, Vector<String> rowHeader) throws SQLException {
        int idx;
        this.con = con;
        this.tbl = tbl;
        this.lowHeader = new ArrayList();
        for (String str : rowHeader) {
            this.lowHeader.add(SqlExec.convertStoresIdentifiers(str));
        }
        this.columnInfoTables = SqlExec.getColumnMames(tbl.getSchemaName(), tbl.getTableName());
        if (this.columnInfoTables.isEmpty()) {
            throw new SQLException("\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093[" + tbl.toString() + "]");
        }
        this.primeKeys = SqlExec.getPrimaryKeys(tbl.getSchemaName(), tbl.getTableName());
        this.primeIdxOnCsv = new ArrayList();
        this.primeIdxOnTable = new ArrayList();
        for (String str : this.primeKeys) {
            idx = rowHeader.indexOf(str);
            if (idx != -1) {
                this.primeIdxOnCsv.add(idx);
            }
            if ((idx = this.indexOfcolumnInfoTables(str)) == -1) continue;
            this.primeIdxOnTable.add(idx);
        }
        this.columnIdxOnTable = new ArrayList();
        for (String str : rowHeader) {
            idx = this.indexOfcolumnInfoTables(str);
            if (idx == -1) continue;
            this.columnIdxOnTable.add(idx);
        }
    }

    private int indexOfcolumnInfoTables(String columnName) {
        int i = 0;
        while (i < this.columnInfoTables.size()) {
            ColumnInfoTable element = this.columnInfoTables.get(i);
            if (element.getColumnName().equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String hasAllColumn() {
        for (String str : this.lowHeader) {
            if (this.indexOfcolumnInfoTables(str) != -1) continue;
            return "\u30ab\u30e9\u30e0\u540d:[" + str + "] \u30c6\u30fc\u30d6\u30eb\u540d:[" + this.tbl + "]";
        }
        return "";
    }

    public String hasPrimeKey() {
        if (this.primeKeys.size() == 0) {
            return "\u4e3b\u30ad\u30fc\u304c\u7121\u3044\u30c6\u30fc\u30d6\u30eb\u306fupdate\u6307\u5b9a\u51fa\u6765\u307e\u305b\u3093";
        }
        for (String str : this.primeKeys) {
            if (this.lowHeader.indexOf(str) != -1) continue;
            return "\u30ab\u30e9\u30e0\u540d:[" + str + "] \u30c6\u30fc\u30d6\u30eb\u540d:[" + this.tbl + "]";
        }
        return "";
    }

    public int execInsertOnlyValuePhrase(Vector<String> items) throws SQLException {
        if (this.insertOvpCmd == null) {
            this.insertOvpCmd = new PrepareExecute();
            this.insertOvpCmd.addStm("INSERT INTO " + this.tbl.getCompleteTableName());
            this.insertOvpCmd.addStm(this.editValuesPhrase(items.size()));
            this.insertOvpCmd.prepare(this.con);
        }
        int columnInfoTableIdx = 0;
        while (columnInfoTableIdx < items.size()) {
            this.addItemValue(this.insertOvpCmd, items.get(columnInfoTableIdx), columnInfoTableIdx);
            ++columnInfoTableIdx;
        }
        return this.insertOvpCmd.executeUpdate();
    }

    private String editValuesPhrase(int size) {
        StringBuilder sb = new StringBuilder(" VALUES(");
        int i = 0;
        while (i < size) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public int execInsertColumnAndValue(Vector<String> items) throws SQLException {
        if (this.columnIdxOnTable.size() != items.size()) {
            throw new SQLException("\u898b\u51fa\u3057\u9805\u76ee\u6570:" + this.columnIdxOnTable.size() + "\u3000\u3068\u660e\u7d30\u9805\u76ee\u6570:" + items.size() + "\u3000\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        if (this.insertCavCmd == null) {
            this.insertCavCmd = new PrepareExecute();
            this.insertCavCmd.addStm("INSERT INTO " + this.tbl.getCompleteTableName() + " (");
            boolean first = true;
            for (Integer idx : this.columnIdxOnTable) {
                if (first) {
                    first = false;
                } else {
                    this.insertCavCmd.addStm(",");
                }
                this.insertCavCmd.addStm(this.columnInfoTables.get(idx).getColumnName());
            }
            this.insertCavCmd.addStm(")");
            this.insertCavCmd.addStm(this.editValuesPhrase(items.size()));
            this.insertCavCmd.prepare(this.con);
        }
        int i = 0;
        while (i < items.size()) {
            this.addItemValue(this.insertCavCmd, items.get(i), this.columnIdxOnTable.get(i));
            ++i;
        }
        return this.insertCavCmd.executeUpdate();
    }

    public int execUpdate(Vector<String> items) throws SQLException {
        int i;
        if (this.columnIdxOnTable.size() != items.size()) {
            throw new SQLException("\u898b\u51fa\u3057\u9805\u76ee\u6570:" + this.columnIdxOnTable.size() + "\u3000\u3068\u660e\u7d30\u9805\u76ee\u6570:" + items.size() + "\u3000\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        if (this.updateCmd == null) {
            this.updateCmd = new PrepareExecute();
            this.updateCmd.addStm("UPDATE " + this.tbl.getCompleteTableName() + " SET ");
            i = 0;
            while (i < items.size()) {
                if (i > 0) {
                    this.updateCmd.addStm(" ,");
                }
                this.updateCmd.addStm(this.columnInfoTables.get(this.columnIdxOnTable.get(i)) + "=?");
                ++i;
            }
            this.updateCmd.addStm(" WHERE ");
            boolean first = true;
            for (Integer idx : this.primeIdxOnCsv) {
                if (first) {
                    first = false;
                } else {
                    this.updateCmd.addStm(" AND ");
                }
                this.updateCmd.addStm(String.valueOf(this.lowHeader.get(idx)) + "=?");
            }
            this.updateCmd.prepare(this.con);
        }
        i = 0;
        while (i < items.size()) {
            this.addItemValue(this.updateCmd, items.get(i), this.columnIdxOnTable.get(i));
            ++i;
        }
        i = 0;
        while (i < this.primeIdxOnCsv.size()) {
            int primeIdx_csv = this.primeIdxOnCsv.get(i);
            int primeIdx_table = this.primeIdxOnTable.get(i);
            this.addItemValue(this.updateCmd, items.get(primeIdx_csv), primeIdx_table);
            ++i;
        }
        return this.updateCmd.executeUpdate();
    }

    public int querySelectCount(Vector<String> items) throws SQLException {
        if (this.selectCountCmd == null) {
            this.selectCountCmd = new PrepareExecute();
            this.selectCountCmd.addStm("SELECT COUNT(*) FROM " + this.tbl.getCompleteTableName());
            this.selectCountCmd.addStm(" WHERE ");
            boolean first = true;
            for (Integer idx : this.primeIdxOnCsv) {
                if (first) {
                    first = false;
                } else {
                    this.selectCountCmd.addStm(" AND ");
                }
                this.selectCountCmd.addStm(String.valueOf(this.lowHeader.get(idx)) + "=?");
            }
            this.selectCountCmd.prepare(this.con);
        }
        int i = 0;
        while (i < this.primeIdxOnCsv.size()) {
            int primeIdx_csv = this.primeIdxOnCsv.get(i);
            int primeIdx_table = this.primeIdxOnTable.get(i);
            this.addItemValue(this.selectCountCmd, items.get(primeIdx_csv), primeIdx_table);
            ++i;
        }
        ResultSet rs = this.selectCountCmd.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    private void addItemValue(PrepareExecute cmd, String item, int columnInfoTableIdx) {
        if (item.equals(JFrameMain.CSVNULLVALUE)) {
            cmd.addParm(null);
        } else if (Binary.isBinary(this.columnInfoTables.get(columnInfoTableIdx).getColumnType())) {
            cmd.addParm(new Binary(item));
        } else {
            cmd.addParm(item);
        }
    }
}

