/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.createdata;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import jdbcacsess.ColumnWidth;
import jdbcacsess.ComponentProperty;
import jdbcacsess.JTextAreaNoEdit;
import jdbcacsess.JTextFieldEdit;
import jdbcacsess.SettingFile;
import jdbcacsess.createdata.CellRendererColumns;
import jdbcacsess.createdata.ColumnsTableModel;
import jdbcacsess.createdata.JPanelCreateData;
import jdbcacsess.createdata.JPanelDateTime;
import jdbcacsess.createdata.JPanelDefault;
import jdbcacsess.createdata.JPanelFixList;
import jdbcacsess.createdata.JPanelSequence;
import jdbcacsess.csv.CsvExport;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvInputDataView;
import jdbcacsess.csv.CsvInputImportToDB;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.csv.JFrameImportHistory;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.sql.SchemaTableName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFrameCreateDataSetting
extends JFrame {
    private static final String CREATEDATA_VER = "Ver 1.0.1";
    private static final long serialVersionUID = -2532898130845637801L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private ColumnsTableModel columnsTableModel = null;
    private JPanel jPanel = null;
    private JComboBox jComboBox = null;
    private JButton jButtonApply = null;
    private JPanel jPanel1 = null;
    private JPanel jPanelCreateDataBase = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabelColumnName = null;
    private JPanelCreateData jPanelCreateDataCurrent;
    private Map<String, JPanelCreateData> createDataMap;
    private JPanel jPanel2 = null;
    private JButton jButtonCsvOutput = null;
    private JPanel jPanel3 = null;
    private SchemaTableName schemaTableName;
    private JButton jButtonRead = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanel4 = null;
    private JPanel jPanel5 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JTextAreaNoEdit jTextAreaNoEditSettingFileName = null;
    private JTextFieldEdit jTextFieldCreateCount = null;
    private JTextAreaNoEdit jTextAreaNoEditTableName = null;
    private JButton jButtonCsvImportHistory = null;
    private JButton jButtonDataView = null;
    private JButton jButtonCsvImport = null;
    private JLabel jLabel2 = null;
    private CsvInfo csvInfo;

    public JFrameCreateDataSetting(SchemaTableName name) {
        this.schemaTableName = name;
        this.createDataMap = new HashMap<String, JPanelCreateData>();
        JPanelCreateData cd = new JPanelSequence();
        this.createDataMap.put(cd.toString(), cd);
        cd = new JPanelFixList();
        this.createDataMap.put(cd.toString(), cd);
        cd = new JPanelDateTime();
        this.createDataMap.put(cd.toString(), cd);
        cd = new JPanelDefault();
        this.createDataMap.put(cd.toString(), cd);
        this.initialize();
    }

    private void initialize() {
        this.setTitle("\u30c7\u30fc\u30bf\u751f\u6210 " + this.schemaTableName.getCompleteTableName());
        this.setSize(new Dimension(600, 500));
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFrameCreateDataSetting.this.dialogClosing();
            }
        });
        ComponentProperty cp = new ComponentProperty(this.schemaTableName.getCompleteTableName());
        cp.restoreWindowPosition(this, 650, 500);
        Integer divider = cp.getToInteger(this.getClass(), "divider");
        if (divider != null) {
            this.jSplitPane.setDividerLocation(divider);
        }
        this.jTextAreaNoEditTableName.setText(this.schemaTableName.getCompleteTableName());
        this.jTextFieldCreateCount.setText("1");
        this.jTextAreaNoEditSettingFileName.setText(this.getSettingFileName());
        for (String str : this.createDataMap.keySet()) {
            this.jComboBox.addItem(str);
        }
        try {
            this.columnsTableModel = new ColumnsTableModel();
            this.columnsTableModel.setTableName(this.schemaTableName);
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u30c7\u30fc\u30bf\u751f\u6210\u3067\u30c6\u30fc\u30d6\u30eb\u60c5\u5831\u53d6\u5f97");
            return;
        }
        this.jTable.setModel(this.columnsTableModel);
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(new CellRendererColumns());
        if (this.isExistsSettingFine()) {
            this.createDataRead(this.getSettingFileName());
        }
        this.jTable.setRowSelectionInterval(0, 0);
        this.selectTableRow(0);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        ColumnWidth.setColumnWidthResizeOff(this.jTable);
        this.csvInfo = new CsvInfo();
        this.csvInfo.currentDataLoad();
    }

    private void createDataRead(String f) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            XMLDecoder d = new XMLDecoder(in);
            String version = (String)d.readObject();
            if (CREATEDATA_VER.equals(version)) {
                SchemaTableName tableName = (SchemaTableName)d.readObject();
                this.columnsTableModel.setCreateDataMap(this.readObject(d));
                this.jTextFieldCreateCount.setText(((JTextFieldEdit)d.readObject()).getText());
                System.out.println("\u30c6\u30fc\u30d6\u30eb\u751f\u6210\u624b\u9806\u8aad\u307f\u8fbc\u307f:" + tableName + " " + version);
            } else {
                JDialogMessage.infoDialog("\u65e7\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u751f\u6210\u624b\u9806\u306e\u305f\u3081\u3001\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30a8\u30e9\u30fc");
            }
            d.close();
            this.columnsTableModel.fireTableRowsUpdated(0, this.columnsTableModel.getRowCount() - 1);
        }
        catch (FileNotFoundException e1) {
            JDialogMessage.errorDialog(e1);
            e1.printStackTrace();
        }
    }

    private boolean isExistsSettingFine() {
        return new File(this.getSettingFileName()).isFile();
    }

    private Map<String, JPanelCreateData> readObject(XMLDecoder d) {
        return (Map)d.readObject();
    }

    private void selectTableRow(int rowIdx) {
        this.jLabelColumnName.setText((String)this.columnsTableModel.getValueAt(rowIdx, 0));
        JPanelCreateData jpcd = this.columnsTableModel.getJPanelCreateData(rowIdx);
        JPanelCreateData jpcdCopy = jpcd.copy();
        this.createDataMap.put(jpcd.toString(), jpcdCopy);
        this.jComboBox.setSelectedItem(jpcd.toString());
        this.changePanelCreateData(jpcdCopy);
    }

    private void changePanelCreateData(JPanelCreateData jpcd) {
        this.jPanelCreateDataBase.setVisible(false);
        this.jPanelCreateDataBase.removeAll();
        this.jPanelCreateDataBase.add((Component)jpcd, "Center");
        this.jPanelCreateDataBase.setVisible(true);
        this.getJContentPane().revalidate();
        this.jPanelCreateDataCurrent = jpcd;
    }

    protected void actionPerformedApply(ActionEvent e) {
        int[] indexs = this.jTable.getSelectedRows();
        int i = 0;
        while (i < indexs.length) {
            JPanelCreateData newJpcd = this.jPanelCreateDataCurrent.copy();
            if (newJpcd == null) {
                return;
            }
            this.columnsTableModel.setJPanelCreateData(indexs[i], newJpcd);
            ++i;
        }
    }

    private void actionPerformedRead() {
        JFileChooser jFileChooser = new JFileChooser(this.getSettingPathName());
        private class FileFilterEx
        extends FileFilter {
            private String extension;
            private String msg;

            public FileFilterEx(String extension, String msg) {
                this.extension = extension;
                this.msg = msg;
            }

            public boolean accept(File f) {
                return f.getName().endsWith(this.extension);
            }

            public String getDescription() {
                return this.msg;
            }
        }
        FileFilterEx ff = new FileFilterEx(".xml", "XML \u30d5\u30a1\u30a4\u30eb(*.xml)");
        jFileChooser.addChoosableFileFilter(ff);
        jFileChooser.setFileFilter(ff);
        jFileChooser.setMultiSelectionEnabled(false);
        int ans = jFileChooser.showOpenDialog(this);
        if (ans == 0) {
            this.createDataRead(jFileChooser.getSelectedFile().getPath());
        }
    }

    protected void actionPerformmedCsvOutput() {
        int creatCnt = 0;
        try {
            creatCnt = new Integer(this.jTextFieldCreateCount.getText());
        }
        catch (NumberFormatException e2) {
            JDialogMessage.errorDialog(e2);
            return;
        }
        JDialogCsv dlg = new JDialogCsv(CsvMode.CREATEDATA, this.csvInfo, this.schemaTableName);
        CsvInfo ci = dlg.getCsvInfo();
        if (ci == null) {
            return;
        }
        this.csvInfo = ci;
        this.columnsTableModel.removeAllQueryExecuteListener();
        this.columnsTableModel.addQueryExecuteListener(new CsvExport(this.csvInfo));
        try {
            this.columnsTableModel.output(creatCnt);
        }
        catch (IOException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.getSettingFileName()));
            XMLEncoder e = new XMLEncoder(out);
            e.writeObject(CREATEDATA_VER);
            e.writeObject(this.schemaTableName);
            e.writeObject(this.columnsTableModel.getCreateDataMap());
            e.writeObject(this.jTextFieldCreateCount);
            e.close();
        }
        catch (FileNotFoundException e1) {
            JDialogMessage.errorDialog(e1);
            e1.printStackTrace();
        }
    }

    private void actionPerformedCsvImport() {
        JDialogCsv dlg = new JDialogCsv(CsvMode.IMPORT, this.csvInfo, this.schemaTableName);
        CsvInfo ci = dlg.getCsvInfo();
        if (ci == null) {
            return;
        }
        this.csvInfo = ci;
        new Thread(new CsvInputImportToDB(this.csvInfo)).start();
    }

    private String getSettingPathName() {
        return SettingFile.getInstance().getFileName("createData");
    }

    private String getSettingFileName() {
        String userPath = this.getSettingPathName();
        File path = new File(userPath);
        if (!path.isDirectory()) {
            path.mkdir();
        }
        String s = String.valueOf(userPath) + System.getProperty("file.separator") + this.schemaTableName.getCompleteTableName() + ".xml";
        return s;
    }

    public void dialogClosing() {
        ComponentProperty cp = new ComponentProperty(this.schemaTableName.getCompleteTableName());
        cp.storeWindowPosition(this);
        cp.put(this.getClass(), "divider", this.jSplitPane.getDividerLocation());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel3(), "South");
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setAutoResizeMode(0);
            this.jTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        JFrameCreateDataSetting.this.selectTableRow(JFrameCreateDataSetting.this.jTable.rowAtPoint(e.getPoint()));
                    }
                }
            });
        }
        return this.jTable;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, "\u5404\u30ab\u30e9\u30e0\u306e\u30c7\u30fc\u30bf\u751f\u6210\u65b9\u6cd5", 0, 0, new Font("Dialog", 0, 12), Color.black));
            this.jPanel.add((Component)this.getJPanel1(), "North");
            this.jPanel.add((Component)this.getJPanelCreateDataBase(), "Center");
            this.jPanel.add((Component)this.getJPanel2(), "South");
        }
        return this.jPanel;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setName("jComboBox");
            this.jComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    JFrameCreateDataSetting.this.changePanelCreateData((JPanelCreateData)JFrameCreateDataSetting.this.createDataMap.get((String)e.getItem()));
                }
            });
        }
        return this.jComboBox;
    }

    private JButton getJButtonApply() {
        if (this.jButtonApply == null) {
            this.jButtonApply = new JButton();
            this.jButtonApply.setText("\u9069\u7528");
            this.jButtonApply.setToolTipText("\u9078\u629e\u3055\u308c\u3066\u3044\u308b\u30ab\u30e9\u30e0\u884c\u5168\u3066\u306b\u53cd\u6620\u3057\u307e\u3059");
            this.jButtonApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformedApply(e);
                }
            });
        }
        return this.jButtonApply;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.ipadx = 7;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.ipady = 5;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.ipadx = 11;
            gridBagConstraints1.ipady = 5;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 3, 5, 5);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.ipady = 5;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            this.jLabelColumnName = new JLabel();
            this.jLabelColumnName.setText(" ");
            this.jLabelColumnName.setFont(new Font("Monospaced", 1, 16));
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("\u30ab\u30e9\u30e0\u540d");
            this.jLabel1.setHorizontalTextPosition(4);
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel = new JLabel();
            this.jLabel.setText("\u751f\u6210\u624b\u9806");
            this.jLabel.setHorizontalAlignment(4);
            this.jLabel.setHorizontalTextPosition(4);
            this.jLabel.setName("jLabel");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setMinimumSize(new Dimension(0, 0));
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
            this.jPanel1.add((Component)this.jLabelColumnName, gridBagConstraints1);
            this.jPanel1.add((Component)this.jLabel, gridBagConstraints2);
            this.jPanel1.add((Component)this.getJComboBox(), gridBagConstraints3);
        }
        return this.jPanel1;
    }

    private JPanel getJPanelCreateDataBase() {
        if (this.jPanelCreateDataBase == null) {
            this.jPanelCreateDataBase = new JPanel();
            this.jPanelCreateDataBase.setLayout(new BorderLayout());
            this.jPanelCreateDataBase.setBorder(BorderFactory.createTitledBorder(null, "\u751f\u6210\u30d1\u30e9\u30e1\u30fc\u30bf", 0, 0, new Font("Dialog", 0, 12), Color.black));
        }
        return this.jPanelCreateDataBase;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.add((Component)this.getJButtonApply(), null);
        }
        return this.jPanel2;
    }

    private JButton getJButtonCsvOutput() {
        if (this.jButtonCsvOutput == null) {
            this.jButtonCsvOutput = new JButton();
            this.jButtonCsvOutput.setText("CSV\u51fa\u529b...");
            this.jButtonCsvOutput.setToolTipText("\u30c7\u30fc\u30bf\u751f\u6210\uff06\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u3092\u884c\u3044\u3001\u6210\u529f\u3057\u305f\u5834\u5408\u306f\u8a2d\u5b9a\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb\u306b\u81ea\u50cd\u30bb\u30fc\u30d6\u3057\u307e\u3059");
            this.jButtonCsvOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformmedCsvOutput();
                }
            });
        }
        return this.jButtonCsvOutput;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.add((Component)this.getJButtonRead(), null);
            this.jPanel3.add((Component)this.getJButtonCsvOutput(), null);
            this.jPanel3.add((Component)this.getJButtonDataView(), null);
            this.jPanel3.add((Component)this.getJButtonCsvImport(), null);
            this.jPanel3.add((Component)this.getJButtonCsvImportHistory(), null);
        }
        return this.jPanel3;
    }

    private JButton getJButtonRead() {
        if (this.jButtonRead == null) {
            this.jButtonRead = new JButton();
            this.jButtonRead.setText("\u624b\u9806\u306e\u30de\u30fc\u30b8\u53d6\u8fbc...");
            this.jButtonRead.setToolTipText("\u4ed6\u30c6\u30fc\u30d6\u30eb\u306e\u8a2d\u5b9a\u3092\u53d6\u308a\u8fbc\u307f\u3001\u30ab\u30e9\u30e0\u540d\u304c\u4e00\u81f4\u3057\u3066\u3044\u308b\u884c\u306e\u5168\u3066\u3092\u7f6e\u304d\u63db\u3048\u307e\u3059");
            this.jButtonRead.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformedRead();
                }
            });
        }
        return this.jButtonRead;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setDividerSize(7);
            this.jSplitPane.setDividerLocation(370);
            this.jSplitPane.setLeftComponent(this.getJPanel4());
            this.jSplitPane.setRightComponent(this.getJPanel());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("\u30ab\u30e9\u30e0\u884c\u3092\u30c0\u30d6\u30eb\u30af\u30ea\u30c3\u30af\u3059\u308c\u3070\u53f3\u306e\u753b\u9762\u3067\u7de8\u96c6\u3067\u304d\u307e\u3059");
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.add((Component)this.getJPanel5(), "North");
            this.jPanel4.add((Component)this.getJScrollPane(), "Center");
            this.jPanel4.add((Component)this.jLabel2, "South");
        }
        return this.jPanel4;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 1;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.fill = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridy = 2;
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("\u8a2d\u5b9a\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb");
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("\u751f\u6210\u884c\u6570");
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("\u30c6\u30fc\u30d6\u30eb\u540d");
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.add((Component)this.jLabel3, gridBagConstraints6);
            this.jPanel5.add((Component)this.jLabel4, gridBagConstraints5);
            this.jPanel5.add((Component)this.jLabel5, gridBagConstraints4);
            this.jPanel5.add((Component)this.getJTextAreaNoEditSettingFileName(), gridBagConstraints7);
            this.jPanel5.add((Component)this.getJTextFieldCreateCount(), gridBagConstraints8);
            this.jPanel5.add((Component)this.getJTextAreaNoEditTableName(), gridBagConstraints9);
        }
        return this.jPanel5;
    }

    private JTextAreaNoEdit getJTextAreaNoEditSettingFileName() {
        if (this.jTextAreaNoEditSettingFileName == null) {
            this.jTextAreaNoEditSettingFileName = new JTextAreaNoEdit();
        }
        return this.jTextAreaNoEditSettingFileName;
    }

    private JTextFieldEdit getJTextFieldCreateCount() {
        if (this.jTextFieldCreateCount == null) {
            this.jTextFieldCreateCount = new JTextFieldEdit();
        }
        return this.jTextFieldCreateCount;
    }

    private JTextAreaNoEdit getJTextAreaNoEditTableName() {
        if (this.jTextAreaNoEditTableName == null) {
            this.jTextAreaNoEditTableName = new JTextAreaNoEdit();
            this.jTextAreaNoEditTableName.setFont(new Font("Monospaced", 1, 16));
        }
        return this.jTextAreaNoEditTableName;
    }

    private JButton getJButtonDataView() {
        if (this.jButtonDataView == null) {
            this.jButtonDataView = new JButton();
            this.jButtonDataView.setText("\u30c7\u30fc\u30bf100\u4ef6\u53c2\u7167...");
            this.jButtonDataView.setToolTipText("<html>\u4f5c\u6210\u3057\u305f\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u3092\u6700\u9ad8\uff11\uff10\uff10\u4ef6\u8aad\u8fbc\u3057\u3001\u53c2\u7167\u753b\u9762\u306b\u8868\u793a\u3057\u307e\u3059<br>DB\u5b9a\u7fa9\u30c1\u30a7\u30c3\u30af\u3084DB\u66f4\u65b0\u306f\u884c\u308f\u306a\u3044\u306e\u3067\u3001\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u3068\u5185\u5bb9\u78ba\u8a8d\u306e\u307f\u304c\u51fa\u6765\u307e\u3059</html>");
            this.jButtonDataView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new CsvInputDataView(JFrameCreateDataSetting.this.csvInfo);
                }
            });
        }
        return this.jButtonDataView;
    }

    private JButton getJButtonCsvImport() {
        if (this.jButtonCsvImport == null) {
            this.jButtonCsvImport = new JButton();
            this.jButtonCsvImport.setText("CSV\u5165\u529b...");
            this.jButtonCsvImport.setToolTipText("\u4f5c\u6210\u3057\u305f\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u307e\u3059");
            this.jButtonCsvImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformedCsvImport();
                }
            });
        }
        return this.jButtonCsvImport;
    }

    private JButton getJButtonCsvImportHistory() {
        if (this.jButtonCsvImportHistory == null) {
            this.jButtonCsvImportHistory = new JButton();
            this.jButtonCsvImportHistory.setText("CSV\u5165\u529b\u5c65\u6b74...");
            this.jButtonCsvImportHistory.setToolTipText("<html>\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u5165\u529b\u306e\u5b9f\u884c\u5c65\u6b74\u753b\u9762\u3092\u8868\u793a\u3057\u307e\u3059<br>\u30a4\u30f3\u30dd\u30fc\u30c8\u306e\u518d\u5b9f\u884c\u3092\u6307\u793a\u3082\u3067\u304d\u307e\u3059</html>");
            this.jButtonCsvImportHistory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.getInstance();
                }
            });
        }
        return this.jButtonCsvImportHistory;
    }
}

