/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jdbcacsess.createdata.JDialogCreateDataSetting;
import jdbcacsess.gui.CellRendererDataBaseObject;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeDataBaseObjects
extends JTree
implements Observer {
    private static final long serialVersionUID = -294660305476207747L;
    private DefaultMutableTreeNode defaultMutableTreeNode;
    private TreePath currentSelectTreePath;
    private JTextPaneSqlStatement sqlStatement;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuItemOrderPrimeKey = null;
    private JMenuItem jMenuItemNoOrder = null;
    private JMenuItem jMenuItemTreeUpdate = null;
    private DefaultTreeModel treeModel;
    private JMenuItem jMenuItemCreateData = null;

    @Override
    public void update(Observable o, Object sqlStatement) {
        this.sqlStatement = (JTextPaneSqlStatement)sqlStatement;
    }

    public JTreeDataBaseObjects() {
        this.initialize();
    }

    private void initialize() {
        this.setRowHeight(13);
        this.setModel(null);
        this.setToggleClickCount(2);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                if (JTreeDataBaseObjects.this.isTableTreePath(e.getPath())) {
                    JTreeDataBaseObjects.this.expandColumnName(e.getPath());
                }
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JTreeDataBaseObjects.this.actionPerformedSelect(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                JTreeDataBaseObjects.this.actionPerformedPopuUp(e);
            }

            public void mousePressed(MouseEvent e) {
                JTreeDataBaseObjects.this.actionPerformedPopuUp(e);
            }
        });
        this.setCellRenderer(new CellRendererDataBaseObject());
        this.getJPopupMenu();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private void actionPerformedSelect(TreeSelectionEvent e) {
        this.currentSelectTreePath = e.getPath();
    }

    private void actionPerformedPopuUp(MouseEvent e) {
        TreePath treePath = this.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e, treePath);
            return;
        }
        if (e.getID() == 501) {
            return;
        }
        if (e.getButton() == 2) {
            String selectItem = "";
            if (this.isTableTreePath(treePath)) {
                selectItem = " " + this.getObjectName(treePath);
            }
            if (this.isColumnTreePath(treePath)) {
                selectItem = " " + this.getObjectNamePrefixParent(treePath);
            }
            if (this.sqlStatement != null) {
                this.sqlStatement.requestFocus();
                this.sqlStatement.insertCurrentPosition(selectItem);
                this.sqlStatement.requestFocus();
            }
        }
    }

    private String getObjectNamePrefixParent(TreePath treePath) {
        DefaultMutableTreeNode symbolParent = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 2);
        return String.valueOf(symbolParent.getUserObject().toString()) + "." + this.getObjectName(treePath);
    }

    private String getObjectName(TreePath treePath) {
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return symbol.getUserObject().toString();
    }

    private boolean isCatalogTreePath(TreePath treePath) {
        return treePath.getPathCount() == 1;
    }

    private boolean isSchemaTreePath(TreePath treePath) {
        return treePath.getPathCount() == 2;
    }

    private boolean isTableTreePath(TreePath treePath) {
        return treePath.getPathCount() == 3;
    }

    private boolean isColumnTreePath(TreePath treePath) {
        return treePath.getPathCount() == 4;
    }

    private void expandColumnName(TreePath treePath) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode dummyChild = (DefaultMutableTreeNode)symbol.getFirstChild();
        if (dummyChild.getUserObject() != null) {
            return;
        }
        SchemaTableName stn = new SchemaTableName(this.getObjectNamePrefixParent(treePath));
        try {
            ArrayList<String> primKeys = SqlExec.getPrimaryKeys(stn.getSchemaName(), stn.getTableName());
            for (ColumnInfoTable col : SqlExec.getColumnMames(stn.getSchemaName(), stn.getTableName())) {
                DefaultMutableTreeNode columnTreeNode = new DefaultMutableTreeNode(col);
                if (primKeys.contains(col.getColumnName())) {
                    col.setPrimaryKey(true);
                }
                symbol.add(columnTreeNode);
            }
            symbol.remove(dummyChild);
            this.treeModel.reload(symbol);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            JDialogMessage.sqlErrorDialog(e1, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
        }
    }

    private void showPopupMenu(MouseEvent e, TreePath treePath) {
        boolean flg = false;
        if (this.getSelectionPaths() != null) {
            TreePath[] treePathArray = this.getSelectionPaths();
            int n = 0;
            int n2 = treePathArray.length;
            while (n < n2) {
                TreePath tp = treePathArray[n];
                if (tp == treePath) {
                    flg = true;
                }
                ++n;
            }
        }
        if (!flg) {
            this.setSelectionPath(treePath);
        }
        if (this.isTableTreePath(treePath) && this.getSelectionCount() == 1) {
            this.jMenuItemCreateData.setVisible(true);
        } else {
            this.jMenuItemCreateData.setVisible(false);
        }
        this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void setTables() throws SQLException {
        this.defaultMutableTreeNode = new DefaultMutableTreeNode(SqlExec.getCatalog());
        for (String sch : SqlExec.getSchemaNames()) {
            DefaultMutableTreeNode schemaTreeNode = new DefaultMutableTreeNode(sch);
            for (String tbl : SqlExec.getSimpleTableNames(sch)) {
                DefaultMutableTreeNode tableTreeNode = new DefaultMutableTreeNode(tbl);
                tableTreeNode.add(new DefaultMutableTreeNode());
                schemaTreeNode.add(tableTreeNode);
            }
            if (schemaTreeNode.getChildCount() == 0) continue;
            this.defaultMutableTreeNode.add(schemaTreeNode);
        }
        this.treeModel = new DefaultTreeModel(this.defaultMutableTreeNode);
        this.setModel(this.treeModel);
    }

    private SchemaTableName getSchemaTable(TreePath tableTreePath) {
        SchemaTableName stn = new SchemaTableName(this.getObjectNamePrefixParent(tableTreePath));
        return stn;
    }

    private ArrayList<SchemaTableName> getSelectSchemaTables() {
        ArrayList<SchemaTableName> list = new ArrayList<SchemaTableName>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            DefaultMutableTreeNode symbol;
            ColumnInfoTable ci;
            SchemaTableName stn;
            TreePath tp = treePathArray[n];
            if (this.isColumnTreePath(tp) && list.indexOf(stn = (ci = (ColumnInfoTable)(symbol = (DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()).getSchemaTableName()) == -1) {
                list.add(stn);
            }
            if (this.isTableTreePath(tp) && list.indexOf(stn = this.getSchemaTable(tp)) == -1) {
                list.add(stn);
            }
            ++n;
        }
        return list;
    }

    private ArrayList<String> getSelectColumns() {
        ArrayList<String> list = new ArrayList<String>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath tp = treePathArray[n];
            if (this.isColumnTreePath(tp)) {
                list.add(this.getObjectNamePrefixParent(tp));
            }
            ++n;
        }
        return list;
    }

    private StringBuffer getSelColumsListPhrase(ArrayList<String> columns) {
        StringBuffer str = new StringBuffer("");
        if (columns.size() == 0) {
            str.append("*");
            return str;
        }
        boolean first = true;
        for (String column : columns) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(column);
        }
        return str;
    }

    private StringBuffer getFromPhrase(ArrayList<SchemaTableName> list) {
        if (list.size() > 2) {
            JOptionPane.showMessageDialog(null, "2\u3064\u4ee5\u4e0a\u306e\u30c6\u30fc\u30d6\u30eb\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f\u3002\nJOIN\u6761\u4ef6\u4f5c\u6210\u3067\u306f\u6700\u521d\u306e2\u30c6\u30fc\u30d6\u30eb\u304c\u6709\u52b9\u3067\u3059");
        }
        StringBuffer str = new StringBuffer("\nFROM ");
        boolean first = true;
        for (SchemaTableName stn : list) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(stn.getCompleteTableName());
        }
        return str;
    }

    private String getWherePhrase(ArrayList<SchemaTableName> list) {
        if (list.size() < 2) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        ArrayList<String> editKey = new ArrayList<String>();
        this.createPrimaryAndColumn(editKey, str, list.get(0), list.get(1));
        this.createPrimaryAndColumn(editKey, str, list.get(1), list.get(0));
        if (editKey.size() == 0) {
            return "";
        }
        return "\nWHERE " + str.substring(5);
    }

    private void createPrimaryAndColumn(ArrayList<String> editKey, StringBuffer str, SchemaTableName primStn, SchemaTableName colStn) {
        ArrayList<String> primList = null;
        ArrayList<ColumnInfoTable> colList = null;
        try {
            primList = SqlExec.getPrimaryKeys(primStn.getSchemaName(), primStn.getTableName());
            colList = SqlExec.getColumnMames(colStn.getSchemaName(), colStn.getTableName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (ColumnInfoTable col : colList) {
            for (String prim : primList) {
                if (!col.getColumnName().equals(prim) || editKey.contains(col.getColumnName())) continue;
                str.append(" AND " + primStn.getTableName() + "." + prim + " = " + colStn.getTableName() + "." + col.getColumnName());
                editKey.add(col.getColumnName());
            }
        }
    }

    private StringBuffer getOrdeByPhrase(ArrayList<SchemaTableName> list) {
        StringBuffer text = new StringBuffer();
        boolean first = true;
        for (SchemaTableName stn : list) {
            try {
                for (String key : SqlExec.getPrimaryKeys(stn.getSchemaName(), stn.getTableName())) {
                    if (first) {
                        first = false;
                        text.append("\nORDER BY ");
                    } else {
                        text.append(", ");
                    }
                    text.append(stn.getTableName()).append(".").append(key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return text;
    }

    private void actionPerformedSelect(boolean isOrderBy) {
        if (this.currentSelectTreePath == null) {
            return;
        }
        if (this.sqlStatement == null) {
            return;
        }
        ArrayList<SchemaTableName> schemaTables = this.getSelectSchemaTables();
        ArrayList<String> columns = this.getSelectColumns();
        StringBuffer text = new StringBuffer("SELECT ");
        text.append(this.getSelColumsListPhrase(columns));
        text.append(this.getFromPhrase(schemaTables));
        text.append(this.getWherePhrase(schemaTables));
        if (isOrderBy) {
            text.append(this.getOrdeByPhrase(schemaTables));
        }
        this.sqlStatement.clearAll();
        this.sqlStatement.insertCurrentPosition(text.toString());
        this.sqlStatement.requestFocus();
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuItemOrderPrimeKey());
            this.jPopupMenu.add(this.getJMenuItemNoOrder());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemCreateData());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemTreeUpdate());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemOrderPrimeKey() {
        if (this.jMenuItemOrderPrimeKey == null) {
            this.jMenuItemOrderPrimeKey = new JMenuItem();
            this.jMenuItemOrderPrimeKey.setText("\u5168\u4ef6\u691c\u7d22\uff08\u4e3b\u30ad\u30fc\u9806\uff09");
            this.jMenuItemOrderPrimeKey.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(true);
                }
            });
        }
        return this.jMenuItemOrderPrimeKey;
    }

    private JMenuItem getJMenuItemNoOrder() {
        if (this.jMenuItemNoOrder == null) {
            this.jMenuItemNoOrder = new JMenuItem();
            this.jMenuItemNoOrder.setText("\u5168\u4ef6\u691c\u7d22\uff08\u7121\u6307\u5b9a\u9806\uff09");
            this.jMenuItemNoOrder.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(false);
                }
            });
        }
        return this.jMenuItemNoOrder;
    }

    private JMenuItem getJMenuItemTreeUpdate() {
        if (this.jMenuItemTreeUpdate == null) {
            this.jMenuItemTreeUpdate = new JMenuItem();
            this.jMenuItemTreeUpdate.setText("\u5b9a\u7fa9\u518d\u53d6\u8fbc");
            this.jMenuItemTreeUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JTreeDataBaseObjects.this.setTables();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                        JDialogMessage.sqlErrorDialog(e1, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
                    }
                }
            });
        }
        return this.jMenuItemTreeUpdate;
    }

    private JMenuItem getJMenuItemCreateData() {
        if (this.jMenuItemCreateData == null) {
            this.jMenuItemCreateData = new JMenuItem();
            this.jMenuItemCreateData.setText("\u30c7\u30fc\u30bf\u751f\u6210\u2026(\u5b9f\u88c5\u4e2d)");
            this.jMenuItemCreateData.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedCreateData(e);
                }
            });
        }
        return this.jMenuItemCreateData;
    }

    private void actionPerformedCreateData(ActionEvent e) {
        JDialogCreateDataSetting dlg = new JDialogCreateDataSetting(this.getSchemaTable(this.getSelectionPath()));
        dlg.setVisible(true);
    }
}

