/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JFrameMain;

public class JTextPaneSqlStatement
extends JTextPane {
    private String[] SQLPHASE = new String[]{"ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};
    private static final long serialVersionUID = -287689674208777989L;
    private SimpleAttributeSet set;
    Pattern pattern;
    private SimpleAttributeSet sqlHigh;
    private StyledDocument doc;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuItemCopy = null;
    private JMenuItem jMenuItemCut = null;
    private JMenuItem jMenuItemPaste = null;
    private JMenuItem jMenuItemSelectAll = null;
    private JMenuItem jMenuItemDelete = null;

    public JTextPaneSqlStatement() {
        this.initialize();
        this.doc = this.getStyledDocument();
        this.doc.addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                JTextPaneSqlStatement.this.setAttr(JTextPaneSqlStatement.this.pattern, JTextPaneSqlStatement.this.sqlHigh);
            }

            public void insertUpdate(DocumentEvent e) {
                JTextPaneSqlStatement.this.setAttr(JTextPaneSqlStatement.this.pattern, JTextPaneSqlStatement.this.sqlHigh);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.set = new SimpleAttributeSet();
        StyleConstants.setFontSize(this.set, 12);
        StyleConstants.setForeground(this.set, Color.BLACK);
        StyleConstants.setFontFamily(this.set, JFrameMain.fontFamilyName);
        StyleConstants.setLineSpacing(this.set, -0.2f);
        this.sqlHigh = new SimpleAttributeSet();
        StyleConstants.setForeground(this.sqlHigh, Color.BLUE);
        StringBuffer sb = new StringBuffer("\\b(");
        int i = 0;
        while (i < this.SQLPHASE.length) {
            if (i != 0) {
                sb.append("|");
            }
            sb.append(this.SQLPHASE[i]);
            ++i;
        }
        sb.append(")\\b");
        this.pattern = Pattern.compile(sb.toString());
    }

    private void initialize() {
        this.setComponentPopupMenu(this.getJPopupMenu());
    }

    private void setAttr(final Pattern pattern, final SimpleAttributeSet sqlHigh) {
        new Thread(){

            public void run() {
                try {
                    JTextPaneSqlStatement.this.doc.setParagraphAttributes(0, JTextPaneSqlStatement.this.doc.getLength(), JTextPaneSqlStatement.this.set, false);
                    JTextPaneSqlStatement.this.doc.setCharacterAttributes(0, JTextPaneSqlStatement.this.doc.getLength(), JTextPaneSqlStatement.this.set, false);
                    Matcher m = pattern.matcher(JTextPaneSqlStatement.this.doc.getText(0, JTextPaneSqlStatement.this.doc.getLength()).toUpperCase());
                    m.reset();
                    while (m.find()) {
                        int i = 0;
                        while (i <= m.groupCount()) {
                            JTextPaneSqlStatement.this.doc.setCharacterAttributes(m.start(i), m.end(i) - m.start(i), sqlHigh, false);
                            ++i;
                        }
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void insertCurrentPosition(String str) {
        try {
            this.doc.insertString(this.getCaretPosition(), str, this.set);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
        }
    }

    public void clearAll() {
        this.setText("");
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuItemCut());
            this.jPopupMenu.add(this.getJMenuItemCopy());
            this.jPopupMenu.add(this.getJMenuItemPaste());
            this.jPopupMenu.add(this.getJMenuItemDelete());
            this.jPopupMenu.add(this.getJMenuItemSelectAll());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemCopy() {
        if (this.jMenuItemCopy == null) {
            this.jMenuItemCopy = new JMenuItem();
            this.jMenuItemCopy.setAction(this.getActionMap().get("copy-to-clipboard"));
            this.jMenuItemCopy.setText("\u30b3\u30d4\u30fc");
        }
        return this.jMenuItemCopy;
    }

    private JMenuItem getJMenuItemCut() {
        if (this.jMenuItemCut == null) {
            this.jMenuItemCut = new JMenuItem();
            this.jMenuItemCut.setAction(this.getActionMap().get("cut-to-clipboard"));
            this.jMenuItemCut.setText("\u5207\u308a\u53d6\u308a");
        }
        return this.jMenuItemCut;
    }

    private JMenuItem getJMenuItemPaste() {
        if (this.jMenuItemPaste == null) {
            this.jMenuItemPaste = new JMenuItem();
            this.jMenuItemPaste.setAction(this.getActionMap().get("paste-from-clipboard"));
            this.jMenuItemPaste.setText("\u8cbc\u308a\u4ed8\u3051");
        }
        return this.jMenuItemPaste;
    }

    private JMenuItem getJMenuItemSelectAll() {
        if (this.jMenuItemSelectAll == null) {
            this.jMenuItemSelectAll = new JMenuItem();
            this.jMenuItemSelectAll.setAction(this.getActionMap().get("select-all"));
            this.jMenuItemSelectAll.setText("\u5168\u3066\u9078\u629e");
        }
        return this.jMenuItemSelectAll;
    }

    private JMenuItem getJMenuItemDelete() {
        if (this.jMenuItemDelete == null) {
            this.jMenuItemDelete = new JMenuItem();
            this.jMenuItemDelete.setAction(this.getActionMap().get("delete-next"));
            this.jMenuItemDelete.setText("\u524a\u9664");
        }
        return this.jMenuItemDelete;
    }
}

