/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jdbcacsess.csv.CsvExport;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.csv.JDialogCsvMode;
import jdbcacsess.gui.ComanndBuffer;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JTableSql;
import jdbcacsess.gui.JTableSqlModel;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.TabWinManager;
import jdbcacsess.sql.QueryExecute;
import jdbcacsess.sql.QueryExecuteAdapter;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.SqlStatementCatgoly;

public class JPanelExecSql
extends JPanel {
    private static final long serialVersionUID = -2404983650883644746L;
    private ComanndBuffer cmdBuff;
    private JTableSqlModel jTablesqlModel;
    private JButton jButtonCsvExport = null;
    private JButton jButtonClear = null;
    private JButton jButtonExecSql = null;
    private JButton jButtonNext = null;
    private JButton jButtonPrev = null;
    private JButton jButtonSelectAbort = null;
    private JButton jButtonSelectContinue = null;
    private JLabel jLabelPageNo = null;
    private JPanel jPanelCommand = null;
    private JPanel jPanelSalStatement = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanelSqlInput = null;
    private JScrollPane jScrollPaneResults = null;
    private JTableSql jTableResults = null;
    private JTextPaneSqlStatement jTextPaneSqlStatement = null;
    private QueryExecute queryExecute;
    private JScrollPane jScrollPane = null;
    private JLabel jLabelMessage = null;
    private JButton jButtonClose = null;
    private TabWinManager parent = null;
    private Connection execSqlConnection;
    private JButton jButtonCommit = null;
    private JButton jButtonRollBack = null;
    private String paneName;
    private boolean autoCommit;
    private JPanel jPanel = null;
    private JLabel jLabelLocation = null;
    private JPanelExecSql myself = this;

    public JPanelExecSql(TabWinManager parent, boolean autoCommit) {
        this.parent = parent;
        this.autoCommit = autoCommit;
        this.myself = this;
        this.initialize();
        if (autoCommit) {
            this.jButtonCommit.setEnabled(false);
            this.jButtonRollBack.setEnabled(false);
        } else {
            this.jButtonCommit.setEnabled(true);
            this.jButtonRollBack.setEnabled(true);
        }
        this.paneName = "";
    }

    private void initialize() {
        this.getJSplitPane();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        this.add((Component)this.getJSplitPane(), "Center");
        this.add((Component)this.getJPanel(), "South");
        this.add((Component)this.getJPanelCommand(), "North");
        this.cmdBuff = new ComanndBuffer();
        this.displayIdx();
    }

    public JTextPaneSqlStatement getSqlStatement() {
        return this.jTextPaneSqlStatement;
    }

    private void setMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelExecSql.this.jLabelMessage.setText(msg);
            }
        });
    }

    private void resetButton() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelExecSql.this.jButtonSelectAbort.setEnabled(false);
                JPanelExecSql.this.jButtonSelectContinue.setEnabled(false);
                JPanelExecSql.this.jButtonExecSql.setEnabled(true);
            }
        });
    }

    private void displayIdx() {
        this.jLabelPageNo.setText("\u5c65\u6b74[" + (this.cmdBuff.getIdx() + 1) + "/" + this.cmdBuff.size() + "]");
    }

    void actionPerformedClear(ActionEvent e) {
        this.jTextPaneSqlStatement.setText("");
    }

    void actionPerformedExecSql(ActionEvent e) {
        this.execSqlConnection = this.checkConnect();
        if (this.execSqlConnection == null) {
            return;
        }
        this.setMessage(" ");
        SqlStatementCatgoly[] sql = new SqlStatementCatgoly[]{SqlStatementCatgoly.SELECT, SqlStatementCatgoly.INSERT, SqlStatementCatgoly.DELETE, SqlStatementCatgoly.UPDATE};
        SqlAnalyze sa = this.checkStatement(sql);
        if (sa == null) {
            return;
        }
        if (sa.getSqlStatementCatgoly() == SqlStatementCatgoly.SELECT) {
            this.jButtonExecSql.setEnabled(false);
            this.jTablesqlModel = new JTableSqlModel(this.execSqlConnection);
            this.queryExecute = new QueryExecute(sa, this.execSqlConnection);
            this.queryExecute.addQueryExecuteListener(new ReciveStatus());
            this.jTableResults.setModel(this.jTablesqlModel);
            this.queryExecute.addQueryExecuteListener(this.jTablesqlModel);
            this.queryExecute.addQueryExecuteListener(this.jTableResults.new JTableSql.registCellRendererAndEditor());
            this.jButtonSelectAbort.setEnabled(true);
            this.jButtonSelectContinue.setEnabled(true);
            new Thread(this.queryExecute).start();
        } else {
            int cnt = 0;
            try {
                cnt = SqlExec.execUpdate(sa.getSqlStatement(), this.execSqlConnection);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                JDialogMessage.sqlErrorDialog(ex, "RollBack\u3057\u307e\u3057\u305f\u3002\u691c\u7d22\u7cfb\u4ee5\u5916\u306e\u30b3\u30de\u30f3\u30c9\u5b9f\u884c");
                return;
            }
            if (cnt >= 0) {
                this.setMessage(String.valueOf(cnt) + "\u30ec\u30b3\u30fc\u30c9\u66f4\u65b0\u3057\u307e\u3057\u305f");
            }
        }
        this.cmdBuff.add(sa.getSqlStatement());
        this.displayIdx();
    }

    private Connection checkConnect() {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            this.execSqlConnection = null;
            return this.execSqlConnection;
        }
        if (this.execSqlConnection == null) {
            try {
                this.execSqlConnection = SqlExec.getNewConnection();
                this.execSqlConnection.setAutoCommit(this.autoCommit);
            }
            catch (SQLException e1) {
                JDialogMessage.sqlErrorDialog(e1, "connect\u5931\u6557");
                e1.printStackTrace();
                return null;
            }
        }
        return this.execSqlConnection;
    }

    private SqlAnalyze checkStatement(SqlStatementCatgoly[] sqlStatementCatgolys) {
        SqlAnalyze sa = new SqlAnalyze(this.jTextPaneSqlStatement.getText());
        boolean flg = false;
        int i = 0;
        while (i < sqlStatementCatgolys.length) {
            if (sqlStatementCatgolys[i].equals((Object)sa.getSqlStatementCatgoly())) {
                flg = true;
                break;
            }
            ++i;
        }
        if (!flg) {
            String str = "";
            int i2 = 0;
            while (i2 < sqlStatementCatgolys.length) {
                if (i2 != 0) {
                    str = String.valueOf(str) + ' ';
                }
                str = String.valueOf(str) + (Object)((Object)sqlStatementCatgolys[i2]);
                ++i2;
            }
            JDialogMessage.errorDialog(new Exception(String.valueOf(str) + " \u306e\u307f\u5b9f\u884c\u51fa\u6765\u307e\u3059"));
            return null;
        }
        return sa;
    }

    void actionPerformedCvsExport(ActionEvent e) {
        this.execSqlConnection = this.checkConnect();
        if (this.execSqlConnection == null) {
            return;
        }
        System.out.println("#actionPerformedCvsExport#:start");
        this.setMessage(" ");
        SqlStatementCatgoly[] sql = new SqlStatementCatgoly[]{SqlStatementCatgoly.SELECT};
        SqlAnalyze sa = this.checkStatement(sql);
        if (sa == null) {
            return;
        }
        JDialogCsv dlg = new JDialogCsv(JDialogCsvMode.EXPORT);
        dlg.setLocation(this.jPanelCommand.getLocationOnScreen());
        dlg.setModal(true);
        dlg.setVisible(true);
        CsvInfo cv = dlg.getCsvInfo();
        if (cv == null) {
            return;
        }
        cv.setPropTableName(sa.getSchemaTableName());
        QueryExecute queryExecuteCsv = null;
        queryExecuteCsv = new QueryExecute(sa, this.execSqlConnection);
        queryExecuteCsv.addQueryExecuteListener(new CsvExport(dlg.getCsvInfo()));
        queryExecuteCsv.addQueryExecuteListener(new ReciveStatus());
        new Thread(queryExecuteCsv).start();
        this.cmdBuff.add(sa.getSqlStatement());
        this.displayIdx();
    }

    void actionPerformedNext(ActionEvent e) {
        this.jTextPaneSqlStatement.setText(this.cmdBuff.next());
        this.displayIdx();
    }

    void actionPerformedPrev(ActionEvent e) {
        this.jTextPaneSqlStatement.setText(this.cmdBuff.prev());
        this.displayIdx();
    }

    void actionPerformedSelectAbort() {
        if (this.queryExecute != null) {
            this.queryExecute.setCalnel();
        }
        if (this.jTablesqlModel != null) {
            this.jTablesqlModel.nextSearch();
        }
    }

    void actionPerformedSelectContinue(ActionEvent e) {
        if (this.jTablesqlModel != null) {
            this.jTablesqlModel.nextSearch();
        }
    }

    public void selectCompleted() {
        this.jButtonSelectAbort.setEnabled(false);
        this.jButtonSelectContinue.setEnabled(false);
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setDividerSize(7);
            this.jSplitPane.setDividerLocation(120);
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setTopComponent(this.getJPanelSqlInput());
            this.jSplitPane.setBottomComponent(this.getJScrollPaneResults());
        }
        return this.jSplitPane;
    }

    private JButton getJButtonClear() {
        if (this.jButtonClear == null) {
            this.jButtonClear = new JButton();
            this.jButtonClear.setText("\u30af\u30ea\u30a2");
            this.jButtonClear.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonClear.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059");
            this.jButtonClear.setFont(new Font("Dialog", 0, 12));
            this.jButtonClear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedClear(e);
                }
            });
        }
        return this.jButtonClear;
    }

    private JButton getJButtonExecSql() {
        if (this.jButtonExecSql == null) {
            this.jButtonExecSql = new JButton();
            this.jButtonExecSql.setText("SQL\u5b9f\u884c");
            this.jButtonExecSql.setHorizontalAlignment(2);
            this.jButtonExecSql.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonExecSql.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002\u691c\u7d22\u306e\u5834\u5408\u306f\u7d50\u679c\u3092\u753b\u9762\u8868\u793a\u3057\u307e\u3059");
            this.jButtonExecSql.setFont(new Font("Dialog", 0, 12));
            this.jButtonExecSql.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedExecSql(e);
                }
            });
        }
        return this.jButtonExecSql;
    }

    private JButton getJButtonCsvExport() {
        if (this.jButtonCsvExport == null) {
            this.jButtonCsvExport = new JButton();
            this.jButtonCsvExport.setText("CSV\u51fa\u529b...");
            this.jButtonCsvExport.setHorizontalAlignment(10);
            this.jButtonCsvExport.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonCsvExport.setToolTipText("\u5165\u529b\u3055\u308c\u305f\u691c\u7d22SQL\u6587\u3092\u5b9f\u884c\u3057\u3001\u7d50\u679c\u3092CSV\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u307e\u3059\u3002\u753b\u9762\u306f\u66f4\u65b0\u3055\u308c\u307e\u305b\u3093");
            this.jButtonCsvExport.setFont(new Font("Dialog", 0, 12));
            this.jButtonCsvExport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedCvsExport(e);
                }
            });
        }
        return this.jButtonCsvExport;
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setText("\uff1e");
            this.jButtonNext.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonNext.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u3092\u672a\u6765\u65b9\u5411\u306b\u9032\u3081\u3066\u8868\u793a\u3057\u307e\u3059");
            this.jButtonNext.setFont(new Font("Dialog", 0, 12));
            this.jButtonNext.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedNext(e);
                }
            });
        }
        return this.jButtonNext;
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setText("\uff1c");
            this.jButtonPrev.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonPrev.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u3092\u904e\u53bb\u65b9\u5411\u306b\u9061\u3063\u3066\u8868\u793a\u3057\u307e\u3059");
            this.jButtonPrev.setFont(new Font("Dialog", 0, 12));
            this.jButtonPrev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedPrev(e);
                }
            });
        }
        return this.jButtonPrev;
    }

    private JButton getJButtonSelectAbort() {
        if (this.jButtonSelectAbort == null) {
            this.jButtonSelectAbort = new JButton();
            this.jButtonSelectAbort.setText("\u691c\u7d22\u4e2d\u6b62");
            this.jButtonSelectAbort.setFont(new Font("Dialog", 0, 12));
            this.jButtonSelectAbort.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonSelectAbort.setToolTipText("\u5927\u91cf\u691c\u7d22\u7d50\u679c\u306e\u70ba\u4e2d\u65ad\u3057\u3066\u3044\u308b\u6642\u306b\u4e2d\u6b62\u3057\u307e\u3059");
            this.jButtonSelectAbort.setEnabled(false);
            this.jButtonSelectAbort.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedSelectAbort();
                }
            });
        }
        return this.jButtonSelectAbort;
    }

    private JButton getJButtonSelectContinue() {
        if (this.jButtonSelectContinue == null) {
            this.jButtonSelectContinue = new JButton();
            this.jButtonSelectContinue.setText("\u7d99\u7d9a\u53d6\u5f97");
            this.jButtonSelectContinue.setFont(new Font("Dialog", 0, 12));
            this.jButtonSelectContinue.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonSelectContinue.setToolTipText("\u5927\u91cf\u691c\u7d22\u7d50\u679c\u306e\u70ba\u4e2d\u65ad\u3057\u3066\u3044\u308b\u6642\u306b\u7d9a\u304d\u3092\u53d6\u5f97\u3057\u307e\u3059");
            this.jButtonSelectContinue.setEnabled(false);
            this.jButtonSelectContinue.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedSelectContinue(e);
                }
            });
        }
        return this.jButtonSelectContinue;
    }

    private JLabel getJLabelPageNo() {
        if (this.jLabelPageNo == null) {
            this.jLabelPageNo = new JLabel();
            this.jLabelPageNo.setFont(new Font("Dialog", 0, 12));
            this.jLabelPageNo.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u306e\u73fe\u5728\u4f4d\u7f6e\u3067\u3059\u3002");
            this.jLabelPageNo.setText("");
        }
        return this.jLabelPageNo;
    }

    private JPanel getJPanelCommand() {
        if (this.jPanelCommand == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.jPanelCommand = new JPanel();
            this.jPanelCommand.setLayout(flowLayout);
            this.jPanelCommand.add((Component)this.getJButtonExecSql(), null);
            this.jPanelCommand.add((Component)this.getJLabelPageNo(), null);
            this.jPanelCommand.add((Component)this.getJButtonPrev(), null);
            this.jPanelCommand.add((Component)this.getJButtonNext(), null);
            this.jPanelCommand.add((Component)this.getJButtonSelectContinue(), null);
            this.jPanelCommand.add((Component)this.getJButtonSelectAbort(), null);
            this.jPanelCommand.add((Component)this.getJButtonCsvExport(), null);
            this.jPanelCommand.add((Component)this.getJButtonClear(), null);
            this.jPanelCommand.add((Component)this.getJButtonCommit(), null);
            this.jPanelCommand.add((Component)this.getJButtonRollBack(), null);
            this.jPanelCommand.add((Component)this.getJButtonClose(), null);
        }
        return this.jPanelCommand;
    }

    private JPanel getJPanelSqlInput() {
        if (this.jPanelSqlInput == null) {
            this.jPanelSqlInput = new JPanel();
            this.jPanelSqlInput.setLayout(new BorderLayout());
            this.jPanelSqlInput.add((Component)this.getJPanelSalStatement(), "Center");
        }
        return this.jPanelSqlInput;
    }

    private JScrollPane getJScrollPaneResults() {
        if (this.jScrollPaneResults == null) {
            this.jScrollPaneResults = new JScrollPane();
            this.jScrollPaneResults.setVerticalScrollBarPolicy(20);
            this.jScrollPaneResults.setHorizontalScrollBarPolicy(30);
            this.jScrollPaneResults.setViewportView(this.getJTableResults());
        }
        return this.jScrollPaneResults;
    }

    private JTableSql getJTableResults() {
        if (this.jTableResults == null) {
            this.jTableResults = new JTableSql();
            this.jTableResults.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    JPanelExecSql.this.jLabelLocation.setText(JPanelExecSql.this.getCurrentCellPosition());
                }
            });
            this.jTableResults.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    JPanelExecSql.this.jLabelLocation.setText(JPanelExecSql.this.getCurrentCellPosition());
                }
            });
        }
        return this.jTableResults;
    }

    private String getCurrentCellPosition() {
        return String.valueOf(this.jTableResults.getSelectedColumn() + 1) + " : " + (this.jTableResults.getSelectedRow() + 1) + "  ";
    }

    private JTextPaneSqlStatement getJTextPaneSqlStatement() {
        if (this.jTextPaneSqlStatement == null) {
            this.jTextPaneSqlStatement = new JTextPaneSqlStatement();
        }
        return this.jTextPaneSqlStatement;
    }

    private JPanel getJPanelSalStatement() {
        if (this.jPanelSalStatement == null) {
            this.jPanelSalStatement = new JPanel();
            this.jPanelSalStatement.setLayout(new BorderLayout());
            this.jPanelSalStatement.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanelSalStatement.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanelSalStatement;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setViewportView(this.getJTextPaneSqlStatement());
        }
        return this.jScrollPane;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setText("\u9589\u3058\u308b");
            this.jButtonClose.setFont(new Font("Dialog", 0, 12));
            this.jButtonClose.setToolTipText("SQL\u5b9f\u884c\u753b\u9762\u3092\u9589\u3058\u307e\u3059");
            this.jButtonClose.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedSelectClose();
                }
            });
        }
        return this.jButtonClose;
    }

    private void actionPerformedSelectClose() {
        this.disconnect();
        this.parent.disposePane(this);
    }

    public void disconnect() {
        this.actionPerformedSelectAbort();
        SqlExec.disconnect(this.execSqlConnection);
    }

    private JButton getJButtonCommit() {
        if (this.jButtonCommit == null) {
            this.jButtonCommit = new JButton();
            this.jButtonCommit.setText("Commit");
            this.jButtonCommit.setFont(new Font("Dialog", 0, 12));
            this.jButtonCommit.setToolTipText("commit\u3057\u307e\u3059\u3002\u4f46\u3057\u3001ManualCommit\u3067SQL\u5b9f\u884c\u753b\u9762\u3092\u958b\u3044\u305f\u6642\u306e\u307f\u6709\u52b9\u3067\u3059");
            this.jButtonCommit.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonCommit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedCommit();
                }
            });
        }
        return this.jButtonCommit;
    }

    private void actionPerformedCommit() {
        if (this.execSqlConnection != null) {
            this.setMessage("Commit\u3092\u958b\u59cb\u3057\u307e\u3059... ");
            new Thread(){

                public void run() {
                    try {
                        JPanelExecSql.this.execSqlConnection.commit();
                        JPanelExecSql.this.setMessage("Commit\u3057\u307e\u3057\u305f");
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "Commit\u3067\u30a8\u30e9\u30fc\u767a\u751f");
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void actionPerformedRollBack() {
        if (this.execSqlConnection != null) {
            this.setMessage("RollBack\u3092\u958b\u59cb\u3057\u307e\u3059... ");
            new Thread(){

                public void run() {
                    try {
                        JPanelExecSql.this.execSqlConnection.rollback();
                        JPanelExecSql.this.setMessage("RollBack\u3057\u307e\u3057\u305f");
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "RollBack\u3067\u30a8\u30e9\u30fc\u767a\u751f");
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private JButton getJButtonRollBack() {
        if (this.jButtonRollBack == null) {
            this.jButtonRollBack = new JButton();
            this.jButtonRollBack.setText("RollBack");
            this.jButtonRollBack.setFont(new Font("Dialog", 0, 12));
            this.jButtonRollBack.setToolTipText("rollback\u3057\u307e\u3059\u3002\u4f46\u3057\u3001ManualCommit\u3067SQL\u5b9f\u884c\u753b\u9762\u3092\u958b\u3044\u305f\u6642\u306e\u307f\u6709\u52b9\u3067\u3059");
            this.jButtonRollBack.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonRollBack.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedRollBack();
                }
            });
        }
        return this.jButtonRollBack;
    }

    public void setPaneName(String paneName) {
        this.paneName = paneName;
    }

    public String getTitleName() {
        if (this.jTablesqlModel != null) {
            return "(" + this.paneName + ")" + this.jTablesqlModel.getTableName().getTableName();
        }
        return "(" + this.paneName + ")";
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabelLocation = new JLabel();
            this.jLabelLocation.setText("");
            this.jLabelMessage = new JLabel();
            this.jLabelMessage.setText(" ");
            this.jLabelMessage.setFont(new Font("Dialog", 0, 14));
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.jLabelLocation, "West");
            this.jPanel.add((Component)this.jLabelMessage, "Center");
        }
        return this.jPanel;
    }

    class ReciveStatus
    extends QueryExecuteAdapter {
        ReciveStatus() {
        }

        private String msg(QueryExecuteStatus breakStatus) {
            JPanelExecSql.this.parent.setTitle(JPanelExecSql.this.myself, JPanelExecSql.this.getTitleName());
            if (breakStatus.getSqlAnalyze().isSelectUpdatable()) {
                return "\u7d50\u679c\u66f4\u65b0\u53ef\u80fd\uff1a";
            }
            return String.valueOf(breakStatus.getSqlAnalyze().getErrorReasonMsg()) + "\uff1a";
        }

        public void completeQuery(QueryExecuteStatus breakStatus) {
            System.out.println("BreakStatus\u53d7\u4fe1" + breakStatus.toString());
            if (breakStatus.isComplete()) {
                JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + breakStatus.getCnt() + "\u30ec\u30b3\u30fc\u30c9\u691c\u7d22\u3057\u307e\u3057\u305f");
            } else {
                JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + breakStatus.getCnt() + "\u30ec\u30b3\u30fc\u30c9\u3067\u691c\u7d22\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f");
            }
            JPanelExecSql.this.resetButton();
        }

        public void status(QueryExecuteStatus breakStatus) {
            System.out.println("BreakStatus\u53d7\u4fe1" + breakStatus.toString());
            JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + "\u691c\u7d22\u4e2d..." + breakStatus.getCnt() + "\u4ef6");
        }

        public void errorException(Exception obj) {
            if (obj instanceof SQLException) {
                JDialogMessage.sqlErrorDialog((SQLException)obj, "\u691c\u7d22\u7d50\u679c\u53d6\u5f97");
            } else {
                JDialogMessage.errorDialog(obj);
            }
            JPanelExecSql.this.resetButton();
        }
    }
}

