/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import jdbcacsess.csv.CSVTokenizer;
import jdbcacsess.csv.CsvImportSqlExecute;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.DupliKeyActionMode;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.sql.PrepareExecUpdate;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImport
implements Runnable {
    private CsvInfo csvInfo;
    private BufferedReader in;
    private Connection con;
    private int inputCnt;
    private int resultCntUpdate;
    private int resultCntInsert;
    private int resultCntDelete;

    public CsvImport(CsvInfo info) {
        this.csvInfo = info;
    }

    @Override
    public void run() {
        block7: {
            this.inputCnt = 0;
            this.resultCntUpdate = 0;
            this.resultCntInsert = 0;
            this.resultCntDelete = 0;
            this.in = null;
            this.con = null;
            try {
                try {
                    this.openInputFile();
                    this.connectDataBase();
                    this.allDelete();
                    CsvImportSqlExecute cise = this.headerCheck();
                    this.fileImport(cise);
                    JDialogMessage.infoDialog(this.msg(), "Import\u6210\u529f");
                }
                catch (CsvImportException cie) {
                    if (this.con == null) break block7;
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        JDialogMessage.sqlErrorDialog(e, "RollBack\u306b\u5931\u6557" + this.msg());
                    }
                }
            }
            finally {
                this.closeInputFile();
                SqlExec.disconnect(this.con);
            }
        }
    }

    private String msg() {
        return "\n" + this.csvInfo.getPropTableName().getCompleteTableName() + " \u306eImport\u7d42\u4e86" + "\n  INFILE: " + this.inputCnt + " \u30ec\u30b3\u30fc\u30c9" + "\n  UPDATE: " + this.resultCntUpdate + " \u884c" + "\n  INSERT: " + this.resultCntInsert + " \u884c" + "\n  DELETE: " + this.resultCntDelete + " \u884c" + "\n";
    }

    private void openInputFile() throws CsvImportException {
        try {
            FileInputStream fos = new FileInputStream(this.csvInfo.getFileName());
            this.in = new BufferedReader(new InputStreamReader((InputStream)fos, this.csvInfo.getEncoding()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new CsvImportException();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new CsvImportException();
        }
    }

    private void closeInputFile() {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
        }
    }

    private Vector<String> readFile() throws IOException {
        Vector<String> v = new Vector<String>();
        String rec = this.in.readLine();
        if (rec == null) {
            return null;
        }
        ++this.inputCnt;
        CSVTokenizer csvt = new CSVTokenizer(rec);
        csvt.setToken(this.csvInfo.getColumnDelimiter());
        while (csvt.hasMoreTokens()) {
            v.add(this.enquoteJdbc(csvt.nextToken()));
        }
        return v;
    }

    private String enquoteJdbc(String str) {
        boolean prevEscapChar = false;
        StringBuffer rtnBuff = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\'') {
                prevEscapChar = !prevEscapChar;
            } else if (prevEscapChar) {
                rtnBuff.append('\'');
                prevEscapChar = false;
            }
            rtnBuff.append(c);
            ++i;
        }
        return rtnBuff.toString();
    }

    private void connectDataBase() throws CsvImportException {
        try {
            this.con = SqlExec.getNewConnection();
            if (this.csvInfo.getCommitCnt() == 0) {
                this.con.setAutoCommit(true);
            } else {
                this.con.setAutoCommit(false);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JDialogMessage.sqlErrorDialog(ex, "DB\u63a5\u7d9a\u3067\u30a8\u30e9\u30fc" + this.msg());
            throw new CsvImportException();
        }
    }

    private void allDelete() throws CsvImportException {
        if (this.csvInfo.getDuplicateKeyAction() == DupliKeyActionMode.ALLDELETE) {
            PrepareExecUpdate peu = new PrepareExecUpdate();
            peu.addStm("DELETE FROM " + this.csvInfo.getPropTableName().getCompleteTableName());
            try {
                this.resultCntDelete = peu.prepareExecuteUpdate(this.con);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                JDialogMessage.sqlErrorDialog(ex, "\u5168\u4ef6\u524a\u9664\u3067\u30a8\u30e9\u30fc" + peu.getStm() + this.msg());
                throw new CsvImportException();
            }
        }
    }

    private CsvImportSqlExecute headerCheck() throws CsvImportException {
        CsvImportSqlExecute cise;
        Vector<String> header = new Vector();
        if (this.csvInfo.hasItemHeader()) {
            try {
                header = this.readFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImportException();
            }
            if (header == null) {
                Exception e = new Exception("\u898b\u51fa\u3057\u6709\u308a\u306a\u306e\u306b\u3001\u7a7a\u30d5\u30a1\u30a4\u30eb\u3067\u3059" + this.msg());
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImportException();
            }
        }
        try {
            cise = new CsvImportSqlExecute(this.con, this.csvInfo.getPropTableName(), header);
        }
        catch (SQLException e) {
            e.printStackTrace();
            JDialogMessage.sqlErrorDialog(e, "DB\u5b9a\u7fa9\u78ba\u8a8d\u4e2d\u306b\u30a8\u30e9\u30fc" + this.msg());
            throw new CsvImportException();
        }
        if (this.csvInfo.hasItemHeader()) {
            String str = cise.hasAllColumn();
            if (!str.equals("")) {
                Exception e = new Exception("CSV\u306e\u898b\u51fa\u3057\u30ab\u30e9\u30e0\u304c\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u306b\u7121\u3044\n" + str + this.msg());
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImportException();
            }
            if (!(this.csvInfo.getDuplicateKeyAction() != DupliKeyActionMode.UPDATE && this.csvInfo.getDuplicateKeyAction() != DupliKeyActionMode.NONE || (str = cise.hasPrimeKey()).equals(""))) {
                Exception e = new Exception("\u4e3b\u30ad\u30fc\u5b9a\u7fa9\u30ab\u30e9\u30e0\u304cCSV\u306e\u898b\u51fa\u3057\u306b\u7121\u3044\n" + str + this.msg());
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImportException();
            }
        }
        return cise;
    }

    private void fileImport(CsvImportSqlExecute cise) throws CsvImportException {
        int commitCnt = 1;
        try {
            Vector<String> rowData = this.readFile();
            while (rowData != null) {
                switch (this.csvInfo.getDuplicateKeyAction()) {
                    case UPDATE: {
                        int updateCnt = cise.execUpdate(rowData);
                        if (updateCnt == 0) {
                            this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                            break;
                        }
                        this.resultCntUpdate += updateCnt;
                        break;
                    }
                    case NONE: {
                        if (cise.querySelectCount(rowData) != 0) break;
                        this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                        break;
                    }
                    default: {
                        if (this.csvInfo.hasItemHeader()) {
                            this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                            break;
                        }
                        this.resultCntInsert += cise.execInsertOnlyValuePhrase(rowData);
                    }
                }
                if (this.csvInfo.getCommitCnt() == 100 && ++commitCnt > 100) {
                    this.con.commit();
                    commitCnt = 1;
                }
                rowData = this.readFile();
            }
            if (this.csvInfo.getCommitCnt() != 0) {
                this.con.commit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new CsvImportException();
        }
        catch (SQLException e) {
            e.printStackTrace();
            JDialogMessage.sqlErrorDialog(e, "DB\u66f4\u65b0\u4e2d\u306b\u30a8\u30e9\u30fc" + this.msg());
            throw new CsvImportException();
        }
    }

    class CsvImportException
    extends Exception {
        private static final long serialVersionUID = 99816268936681456L;

        CsvImportException() {
        }
    }
}

