/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.Binary;
import jdbcacsess.sql.JDialogPrepareStatementLog;

public class PrepareExecUpdate {
    ArrayList<Object> parmList;
    private PreparedStatement pstmt = null;
    StringBuffer statement = new StringBuffer();

    public PrepareExecUpdate() {
        this.parmList = new ArrayList();
    }

    public int getParmSize() {
        return this.parmList.size();
    }

    public void addParm(Object value) {
        if (value instanceof Binary) {
            this.parmList.add(((Binary)value).getValue());
        } else {
            this.parmList.add(value);
        }
    }

    public void addStm(String stm) {
        this.statement.append(stm);
    }

    public void clearParm() {
        this.parmList.clear();
    }

    public int execute() throws SQLException {
        int i = 0;
        while (i < this.parmList.size()) {
            if (this.parmList.get(i) == null) {
                this.pstmt.setNull(i + 1, 0);
            } else {
                this.pstmt.setObject(i + 1, this.parmList.get(i));
            }
            ++i;
        }
        if (JFrameMain.debugMode) {
            StringBuilder sb = new StringBuilder("PrepareExecUpdate:" + this.statement + "#");
            for (Object o : this.parmList) {
                sb.append(o == null ? "null" : o.toString());
                sb.append("$");
            }
            sb.append("\n");
            JDialogPrepareStatementLog a = JDialogPrepareStatementLog.getInstance();
            a.appendLog(sb);
        }
        this.clearParm();
        return this.pstmt.executeUpdate();
    }

    public void prepare(Connection con) throws SQLException {
        System.out.println(con + " " + this.statement.toString());
        this.pstmt = con.prepareStatement(this.statement.toString());
    }

    public int prepareExecute(Connection con) throws SQLException {
        this.prepare(con);
        return this.execute();
    }

    public String getStm() {
        return this.statement.toString();
    }
}

