/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.gui.CellInfo;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.RowInsertValueMode;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.PrepareExecUpdate;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlAnalyze;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableSqlModel
extends AbstractTableModel
implements QueryExecuteListener {
    private static final long serialVersionUID = 1L;
    private List<String> headerList;
    private List<List<CellInfo>> detailList;
    private Vector<ColumnInfoResult> columnInfoResults;
    private SqlAnalyze sqlAnalyze;
    private int insertRowIndex = -1;
    private Connection con;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public JTableSqlModel(Connection con) {
        this.init();
        this.con = con;
    }

    @Override
    public void init() {
        this.headerList = Collections.synchronizedList(new ArrayList());
        this.detailList = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void setResultHeader(Vector<ColumnInfoResult> headerData, SqlAnalyze sqlAnalyze) {
        this.columnInfoResults = headerData;
        for (ColumnInfoResult info : headerData) {
            this.headerList.add(info.getColumnName());
        }
        this.sqlAnalyze = sqlAnalyze;
        this.fireTableStructureChanged();
    }

    public ColumnInfoResult getColumnInfo(int idx) {
        return this.columnInfoResults.get(idx);
    }

    @Override
    public synchronized void setResultDetail(Vector detailData) {
        List<CellInfo> columnList = Collections.synchronizedList(new ArrayList());
        int i = 0;
        while (i < detailData.size()) {
            CellInfo cellInfo = new CellInfo();
            cellInfo.setValue(detailData.get(i));
            columnList.add(cellInfo);
            ++i;
        }
        this.detailList.add(columnList);
        int cnt = this.detailList.size() % 5000;
        if (cnt == 0) {
            System.out.println("wait\u3057\u307e\u3059");
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                System.out.println("\u518d\u958b\u3057\u307e\u3059");
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public void completeQuery(QueryExecuteStatus breakStatus) {
        if (breakStatus.isErr()) {
            return;
        }
        if (this.detailList.isEmpty()) {
            List<CellInfo> newColumnList = Collections.synchronizedList(new ArrayList());
            newColumnList = Collections.synchronizedList(new ArrayList());
            int i = 0;
            while (i < this.columnInfoResults.size()) {
                CellInfo ci = new CellInfo();
                ci.setValue("");
                ci.setMode(CellMode.CELL_DELETE);
                newColumnList.add(ci);
                ++i;
            }
            this.detailList.add(newColumnList);
            this.fireTableDataChanged();
        }
    }

    public SchemaTableName getTableName() {
        return this.sqlAnalyze.getSchemaTableName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnInfoResults.get(columnIndex).getColumnClass();
    }

    @Override
    public String getColumnName(int column) {
        return this.headerList.get(column);
    }

    @Override
    public int getColumnCount() {
        if (this.columnInfoResults == null) {
            return 0;
        }
        return this.columnInfoResults.size();
    }

    @Override
    public int getRowCount() {
        return this.detailList.size();
    }

    private CellInfo getCellInfo(int rowIndex, int columnIndex) {
        List<CellInfo> columnList = this.detailList.get(rowIndex);
        return columnList.get(columnIndex);
    }

    private void setCellInfo(int rowIdx, int colIdx, CellMode cellMode) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        cellInfo.setMode(cellMode);
    }

    private void setCellInfo(int rowIdx, int colIdx, CellMode cellMode, Object aValue) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        cellInfo.setValue(aValue);
        cellInfo.setMode(cellMode);
        cellInfo.setDefaultInsert(false);
    }

    @Override
    public Object getValueAt(int rowIdx, int colIdx) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        return cellInfo.getValue();
    }

    public CellMode getMode(int rowIndex, int columnIndex) {
        return this.getCellInfo(rowIndex, columnIndex).getMode();
    }

    public boolean isDefaultInsert(int rowIndex, int columnIndex) {
        return this.getCellInfo(rowIndex, columnIndex).isDefaultInsert();
    }

    public void setDefaultInsert(boolean defaultInsert, int rowIndex, int columnIndex) {
        this.getCellInfo(rowIndex, columnIndex).setDefaultInsert(defaultInsert);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.sqlAnalyze.isSelectUpdatable()) {
            return false;
        }
        return this.getCellInfo(rowIndex, columnIndex).isCellEditable();
    }

    @Override
    public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
        if (this.getMode(rowIndex, columnIndex) == CellMode.CELL_INSERT) {
            this.setCellInfo(rowIndex, columnIndex, CellMode.CELL_INSERT, aValue);
            return;
        }
        final PrepareExecUpdate peu = new PrepareExecUpdate();
        peu.addStm("UPDATE " + this.sqlAnalyze.getSchemaTableName());
        peu.addStm(" SET " + this.columnInfoResults.get(columnIndex).getColumnName() + " = ?");
        peu.addParm(aValue);
        this.editWherePhrase(peu, rowIndex);
        this.setCellInfo(rowIndex, columnIndex, CellMode.CELL_UPDATE);
        this.fireTableCellUpdated(rowIndex, columnIndex);
        new Thread(){

            public void run() {
                try {
                    peu.prepareExecute(JTableSqlModel.this.con);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JDialogMessage.sqlErrorDialog(e, "\u30ab\u30e9\u30e0\u66f4\u65b0");
                    return;
                }
                JTableSqlModel.this.setCellInfo(rowIndex, columnIndex, CellMode.CELL_UPDATE_COMPLETE, aValue);
                JTableSqlModel.this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }.start();
    }

    private void editWherePhrase(PrepareExecUpdate peu, int rowIndex) {
        peu.addStm(" WHERE ");
        boolean isFirst = true;
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            ColumnInfoResult colInfo = this.columnInfoResults.get(i);
            if (colInfo.isPrimaryKey()) {
                if (isFirst) {
                    peu.addStm(" ");
                    isFirst = false;
                } else {
                    peu.addStm(" AND ");
                }
                peu.addStm(String.valueOf(colInfo.getColumnName()) + " = ?");
                peu.addParm(this.getCellInfo(rowIndex, i).getValue());
            }
            ++i;
        }
    }

    public void rowDelete(final int[] rowIndexs) {
        new Thread(){

            public void run() {
                int[] nArray = rowIndexs;
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    int rowIndex = nArray[n];
                    switch (JTableSqlModel.this.getMode(rowIndex, 0)) {
                        case CELL_INSERT: {
                            JTableSqlModel.this.insertRowIndex = -1;
                            JTableSqlModel.this.detailList.remove(rowIndex);
                            break;
                        }
                        case CELL_DELETE: 
                        case CELL_DELETE_COMPLETE: {
                            break;
                        }
                        default: {
                            for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(rowIndex)) {
                                cellInfo.setMode(CellMode.CELL_DELETE);
                            }
                            PrepareExecUpdate peu = new PrepareExecUpdate();
                            peu.addStm("DELETE FROM " + JTableSqlModel.this.sqlAnalyze.getSchemaTableName());
                            JTableSqlModel.this.editWherePhrase(peu, rowIndex);
                            try {
                                peu.prepareExecute(JTableSqlModel.this.con);
                            }
                            catch (SQLException e) {
                                JDialogMessage.sqlErrorDialog(e, "\u884c\u524a\u9664");
                                e.printStackTrace();
                                return;
                            }
                            for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(rowIndex)) {
                                cellInfo.setMode(CellMode.CELL_DELETE_COMPLETE);
                            }
                        }
                    }
                    JTableSqlModel.this.fireTableRowsDeleted(rowIndex, rowIndex);
                    ++n;
                }
            }
        }.start();
    }

    public void rowCopy(int orgRowIndex, RowInsertValueMode insertMode) {
        if (this.insertRowIndex != -1) {
            return;
        }
        List<CellInfo> newColumnList = Collections.synchronizedList(new ArrayList());
        switch (insertMode) {
            case VALUEROWNEW: {
                this.createInsertRowData(newColumnList);
                break;
            }
            case ALLNULLROWNEW: {
                this.createInsertRowNull(newColumnList);
                break;
            }
            case ROWCOPY: {
                for (CellInfo cellInfo : this.detailList.get(orgRowIndex)) {
                    newColumnList.add(cellInfo.copy());
                }
                break;
            }
        }
        this.insertRowIndex = orgRowIndex;
        this.detailList.add(this.insertRowIndex, newColumnList);
        this.fireTableDataChanged();
    }

    private void createInsertRowData(List<CellInfo> newColumnList) {
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            CellInfo ci = new CellInfo();
            Class<?> c = this.getColumnClass(i);
            try {
                if (String.class.isAssignableFrom(c)) {
                    ci.setValue(this.getColumnInfo(i).isNullable() ? null : "a");
                } else if (Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
                    ci.setValue(c.getConstructor(String.class).newInstance("0"));
                } else if (Date.class.isAssignableFrom(c)) {
                    ci.setValue(c.getConstructor(Long.TYPE).newInstance(new Long(new Date().getTime())));
                } else if (Object.class == c) {
                    ci.setValue(null);
                } else {
                    ci.setValue(c.newInstance());
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            ci.setMode(CellMode.CELL_INSERT);
            newColumnList.add(ci);
            ++i;
        }
    }

    private void createInsertRowNull(List<CellInfo> newColumnList) {
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            CellInfo ci = new CellInfo();
            ci.setValue(null);
            ci.setMode(CellMode.CELL_INSERT);
            newColumnList.add(ci);
            ++i;
        }
    }

    public void rowInsert(int selectRowIndex) {
        if (this.insertRowIndex == -1) {
            return;
        }
        System.out.println("Insert\u5bfe\u8c61\u884c:" + this.insertRowIndex + " " + "\u9078\u629e\u884c:" + selectRowIndex);
        if (selectRowIndex == this.insertRowIndex) {
            return;
        }
        final PrepareExecUpdate peu = new PrepareExecUpdate();
        peu.addStm("INSERT INTO " + this.sqlAnalyze.getSchemaTableName() + "(");
        int cnt = 0;
        int i = 0;
        while (i < this.columnInfoResults.size()) {
            if (!this.isDefaultInsert(this.insertRowIndex, i)) {
                if (cnt != 0) {
                    peu.addStm(",");
                }
                peu.addStm(this.columnInfoResults.get(i).getColumnName());
                ++cnt;
            }
            ++i;
        }
        peu.addStm(") VALUES(");
        List<CellInfo> cellInfoList = this.detailList.get(this.insertRowIndex);
        cnt = 0;
        int i2 = 0;
        while (i2 < cellInfoList.size()) {
            if (!this.isDefaultInsert(this.insertRowIndex, i2)) {
                if (cnt != 0) {
                    peu.addStm(",");
                }
                peu.addStm("?");
                peu.addParm(cellInfoList.get(i2).getValue());
                ++cnt;
            }
            ++i2;
        }
        peu.addStm(")");
        new Thread(){

            public void run() {
                try {
                    peu.prepareExecute(JTableSqlModel.this.con);
                }
                catch (SQLException e) {
                    JDialogMessage.sqlErrorDialog(e, "\u884c\u633f\u5165");
                    e.printStackTrace();
                    return;
                }
                for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(JTableSqlModel.this.insertRowIndex)) {
                    cellInfo.setMode(CellMode.CELL_INSERT_COMPLETE);
                }
                JTableSqlModel.this.insertRowIndex = -1;
                JTableSqlModel.this.fireTableDataChanged();
            }
        }.start();
    }

    public synchronized void nextSearch() {
        this.notify();
    }

    public boolean isAllCellEdit() {
        return this.sqlAnalyze.isSelectUpdatable();
    }

    @Override
    public void status(QueryExecuteStatus breakStatus) {
    }

    @Override
    public void errorException(Exception ex) {
    }
}

