/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.sql.SQLException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.xml.transform.TransformerException;
import jdbcacsess.SettingFile;
import jdbcacsess.csv.CsvImport;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.csv.JDialogCsvMode;
import jdbcacsess.csv.JDialogImportHistory;
import jdbcacsess.dbconnect.JDialogConnect;
import jdbcacsess.gui.ComponentProperty;
import jdbcacsess.gui.JDialogAboutBox;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JPanelEditButton;
import jdbcacsess.gui.JTreeDataBaseObjects;
import jdbcacsess.gui.SqlStatementObserver;
import jdbcacsess.gui.TabWinManager;
import jdbcacsess.gui.TabWinMode;
import jdbcacsess.sql.SqlExec;

public class JFrameMain
extends JFrame {
    private static final long serialVersionUID = -398926768714658758L;
    private JPanel jContentPane = null;
    private JLabel jLabelStatusBar = null;
    private JPanel jPanel = null;
    private JPanelEditButton jPanelEditButton = null;
    private JTreeDataBaseObjects jTreeDataBaseObjects = null;
    private JMenuBar jMenuBarBase = null;
    private JMenu jMenuFile = null;
    private JMenu jMenuHelp1 = null;
    private JMenuItem jMenuItemFileConnect = null;
    private JMenuItem jMenuItemFileDisConnect = null;
    private JMenuItem jMenuItemFileCvsImport = null;
    private JMenuItem jMenuItemFileExit = null;
    private JMenuItem jMenuItemHelpAbout = null;
    private JScrollPane jScrollPane = null;
    private JSplitPane jSplitPaneBase = null;
    private TabWinManager tabWinManager;
    private SqlStatementObserver sqlStatementObserver;
    private JMenu jMenuNew = null;
    private JMenuItem jMenuItemAutoCommit = null;
    private JMenuItem jMenuItemManualCommit = null;
    private JMenu jMenuTab = null;
    private JMenu jMenuWin = null;
    private JMenuItem jMenuItemChangeWin = null;
    private JMenuItem jMenuItemChangeTab = null;
    private JMenuItem jMenuItemWinSort = null;
    private JMenuItem jMenuItemCsvImportHistory = null;
    private JDialogImportHistory jDialogImportHistory;
    private JCheckBoxMenuItem jCheckBoxMenuItemDebug = null;
    public static String fontFamilyName = "Monospaced";
    public static String CSVNULLVALUE = "#$%&NULL&%$#";
    public static boolean debugMode = false;

    public JFrameMain() {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            if (fonts[i].equals("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af")) {
                fontFamilyName = "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af";
                break;
            }
            ++i;
        }
        ComponentProperty.restoreWindowPosition(this, 800, 600);
        this.actionPerformedConnect();
        this.initialize();
        this.setVisible(true);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(this.getJMenuBarBase());
        this.setTitle("JdbcAcsess");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFrameMain.this.actionPerformedExit();
            }
        });
        this.setDefaultCloseOperation(3);
        Integer divider = ComponentProperty.getToInteger(this, "divider");
        if (divider != null) {
            this.jSplitPaneBase.setDividerLocation(divider);
        }
        this.sqlStatementObserver = new SqlStatementObserver();
        this.sqlStatementObserver.addObserver(this.jTreeDataBaseObjects);
        this.sqlStatementObserver.addObserver(this.jPanelEditButton);
        this.tabWinManager = new TabWinManager(TabWinMode.TAB, this.sqlStatementObserver);
        this.jSplitPaneBase.setRightComponent(this.tabWinManager.getPane());
        if (SqlExec.isConnect()) {
            try {
                this.jTreeDataBaseObjects.setTables();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                JDialogMessage.sqlErrorDialog(ex, "TABLE\u4e00\u89a7");
            }
        }
        this.setMessage(SqlExec.getConnectString());
    }

    private void actionPerformedExit() {
        if (SqlExec.isConnect()) {
            SqlExec.disconnect();
        }
        this.tabWinManager.allPaneClosed();
        ComponentProperty.storeWindowPosition(this);
        ComponentProperty.put((Object)this, "divider", this.jSplitPaneBase.getDividerLocation());
        if (this.jDialogImportHistory != null) {
            this.jDialogImportHistory.dialogClosing();
        }
        this.dispose();
        SettingFile xml = SettingFile.getInstance();
        try {
            xml.save();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void actionPerformedNewWindow(boolean antoCommit) {
        this.tabWinManager.newPane(antoCommit);
    }

    private void actionPerformedTabWin(TabWinMode tw) {
        if (this.tabWinManager.getTabWin() == tw) {
            return;
        }
        int size = this.jSplitPaneBase.getDividerLocation();
        Component c = this.jSplitPaneBase.getRightComponent();
        if (c != null) {
            this.jSplitPaneBase.remove(c);
        }
        this.jSplitPaneBase.setRightComponent(this.tabWinManager.changeTabWin(tw));
        this.jSplitPaneBase.setDividerLocation(size);
        this.jSplitPaneBase.validate();
    }

    private void actionPerformedSort() {
        this.tabWinManager.sortWindow();
    }

    private void actionPerformedConnect() {
        this.setMessage(" ");
        JDialogConnect dlg = new JDialogConnect();
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        this.setMessage(SqlExec.getConnectString());
    }

    private void actionPerformedDisConnect(ActionEvent e) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        this.setMessage(" ");
        this.tabWinManager.allPaneClosed();
        SqlExec.disconnect();
        if (!SqlExec.isConnect()) {
            this.setMessage("DB\u5207\u65ad\u3057\u307e\u3057\u305f");
        }
    }

    private void actionPerformedCvsImport(ActionEvent e) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        this.setMessage(" ");
        JDialogCsv dlg = new JDialogCsv(JDialogCsvMode.IMPORT);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
        CsvInfo csvInfo = dlg.getCsvInfo();
        if (csvInfo == null) {
            return;
        }
        new CsvImport(csvInfo).start();
        csvInfo.currentDataSave();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelStatusBar = new JLabel();
            this.jLabelStatusBar.setFont(new Font("Dialog", 0, 14));
            this.jLabelStatusBar.setText(" ");
            this.jLabelStatusBar.setName("statusBar");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPaneBase(), "Center");
            this.jContentPane.add((Component)this.jLabelStatusBar, "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJPanelEditButton(), "North");
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel;
    }

    private JPanelEditButton getJPanelEditButton() {
        if (this.jPanelEditButton == null) {
            this.jPanelEditButton = new JPanelEditButton();
        }
        return this.jPanelEditButton;
    }

    private JTreeDataBaseObjects getJTreeDataBaseObjects() {
        if (this.jTreeDataBaseObjects == null) {
            this.jTreeDataBaseObjects = new JTreeDataBaseObjects();
        }
        return this.jTreeDataBaseObjects;
    }

    private JSplitPane getJSplitPaneBase() {
        if (this.jSplitPaneBase == null) {
            this.jSplitPaneBase = new JSplitPane();
            this.jSplitPaneBase.setDividerLocation(150);
            this.jSplitPaneBase.setOneTouchExpandable(true);
            this.jSplitPaneBase.setDividerSize(10);
            this.jSplitPaneBase.setLeftComponent(this.getJPanel());
        }
        return this.jSplitPaneBase;
    }

    private void actionPerformedHelpAbout(ActionEvent e) {
        JDialogAboutBox dlg = new JDialogAboutBox();
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public void setMessage(String msg) {
        if (this.jLabelStatusBar != null) {
            this.jLabelStatusBar.setText(msg);
        }
    }

    private JMenuBar getJMenuBarBase() {
        if (this.jMenuBarBase == null) {
            this.jMenuBarBase = new JMenuBar();
            this.jMenuBarBase.add(this.getJMenuFile());
            this.jMenuBarBase.add(this.getJMenuTab());
            this.jMenuBarBase.add(this.getJMenuWin());
            this.jMenuBarBase.add(this.getJMenuHelp1());
        }
        return this.jMenuBarBase;
    }

    private JMenu getJMenuFile() {
        if (this.jMenuFile == null) {
            this.jMenuFile = new JMenu();
            this.jMenuFile.setText("\u30d5\u30a1\u30a4\u30eb(F)");
            this.jMenuFile.setFont(new Font("Dialog", 0, 12));
            this.jMenuFile.add(this.getJMenuNew());
            this.jMenuFile.add(this.getJMenuItemFileConnect());
            this.jMenuFile.add(this.getJMenuItemFileDisConnect());
            this.jMenuFile.add(this.getJMenuItemFileCvsImport());
            this.jMenuFile.add(this.getJMenuItemCsvImportHistory());
            this.jMenuFile.add(this.getJMenuItemFileExit());
        }
        return this.jMenuFile;
    }

    private JMenu getJMenuHelp1() {
        if (this.jMenuHelp1 == null) {
            this.jMenuHelp1 = new JMenu();
            this.jMenuHelp1.setText("\u30d8\u30eb\u30d7(H)");
            this.jMenuHelp1.setFont(new Font("Dialog", 0, 12));
            this.jMenuHelp1.add(this.getJCheckBoxMenuItemDebug());
            this.jMenuHelp1.add(this.getJMenuItemHelpAbout());
        }
        return this.jMenuHelp1;
    }

    private JMenuItem getJMenuItemFileConnect() {
        if (this.jMenuItemFileConnect == null) {
            this.jMenuItemFileConnect = new JMenuItem();
            this.jMenuItemFileConnect.setText("\u63a5\u7d9a...(C)");
            this.jMenuItemFileConnect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedConnect();
                    if (SqlExec.isConnect()) {
                        try {
                            JFrameMain.this.jTreeDataBaseObjects.setTables();
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                            JDialogMessage.sqlErrorDialog(ex, "TABLE\u4e00\u89a7");
                        }
                    }
                }
            });
        }
        return this.jMenuItemFileConnect;
    }

    private JMenuItem getJMenuItemFileDisConnect() {
        if (this.jMenuItemFileDisConnect == null) {
            this.jMenuItemFileDisConnect = new JMenuItem();
            this.jMenuItemFileDisConnect.setText("\u5207\u65ad(D)");
            this.jMenuItemFileDisConnect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedDisConnect(e);
                }
            });
        }
        return this.jMenuItemFileDisConnect;
    }

    private JMenuItem getJMenuItemFileCvsImport() {
        if (this.jMenuItemFileCvsImport == null) {
            this.jMenuItemFileCvsImport = new JMenuItem();
            this.jMenuItemFileCvsImport.setText("CVS\u5165\u529b...(I)");
            this.jMenuItemFileCvsImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedCvsImport(e);
                }
            });
        }
        return this.jMenuItemFileCvsImport;
    }

    private JMenuItem getJMenuItemFileExit() {
        if (this.jMenuItemFileExit == null) {
            this.jMenuItemFileExit = new JMenuItem();
            this.jMenuItemFileExit.setText("\u7d42\u4e86(X)");
            this.jMenuItemFileExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedExit();
                }
            });
        }
        return this.jMenuItemFileExit;
    }

    private JMenuItem getJMenuItemHelpAbout() {
        if (this.jMenuItemHelpAbout == null) {
            this.jMenuItemHelpAbout = new JMenuItem();
            this.jMenuItemHelpAbout.setText("\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306b\u3064\u3044\u3066");
            this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedHelpAbout(e);
                }
            });
        }
        return this.jMenuItemHelpAbout;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(32);
            this.jScrollPane.setVerticalScrollBarPolicy(22);
            this.jScrollPane.setViewportView(this.getJTreeDataBaseObjects());
        }
        return this.jScrollPane;
    }

    private JMenu getJMenuNew() {
        if (this.jMenuNew == null) {
            this.jMenuNew = new JMenu();
            this.jMenuNew.setText("\u65b0\u898f(N)");
            this.jMenuNew.add(this.getJMenuItemAutoCommit());
            this.jMenuNew.add(this.getJMenuItemManualCommit());
        }
        return this.jMenuNew;
    }

    private JMenuItem getJMenuItemAutoCommit() {
        if (this.jMenuItemAutoCommit == null) {
            this.jMenuItemAutoCommit = new JMenuItem();
            this.jMenuItemAutoCommit.setText("AutoCommit");
            this.jMenuItemAutoCommit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedNewWindow(true);
                }
            });
        }
        return this.jMenuItemAutoCommit;
    }

    private JMenuItem getJMenuItemManualCommit() {
        if (this.jMenuItemManualCommit == null) {
            this.jMenuItemManualCommit = new JMenuItem();
            this.jMenuItemManualCommit.setText("ManualCommit");
            this.jMenuItemManualCommit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedNewWindow(false);
                }
            });
        }
        return this.jMenuItemManualCommit;
    }

    private JMenu getJMenuTab() {
        if (this.jMenuTab == null) {
            this.jMenuTab = new JMenu();
            this.jMenuTab.setText("\u30bf\u30d6(T)");
            this.jMenuTab.add(this.getJMenuItemChangeTab());
        }
        return this.jMenuTab;
    }

    private JMenu getJMenuWin() {
        if (this.jMenuWin == null) {
            this.jMenuWin = new JMenu();
            this.jMenuWin.setText("\u30a6\u30a3\u30f3\u30c9\u30a6(W)");
            this.jMenuWin.add(this.getJMenuItemChangeWin());
            this.jMenuWin.add(this.getJMenuItemWinSort());
        }
        return this.jMenuWin;
    }

    private JMenuItem getJMenuItemChangeTab() {
        if (this.jMenuItemChangeWin == null) {
            this.jMenuItemChangeWin = new JMenuItem();
            this.jMenuItemChangeWin.setText("\u30bf\u30d6\u306b\u5207\u66ff");
            this.jMenuItemChangeWin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedTabWin(TabWinMode.TAB);
                }
            });
        }
        return this.jMenuItemChangeWin;
    }

    private JMenuItem getJMenuItemChangeWin() {
        if (this.jMenuItemChangeTab == null) {
            this.jMenuItemChangeTab = new JMenuItem();
            this.jMenuItemChangeTab.setText("\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u5207\u66ff");
            this.jMenuItemChangeTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedTabWin(TabWinMode.WIN);
                }
            });
        }
        return this.jMenuItemChangeTab;
    }

    private JMenuItem getJMenuItemWinSort() {
        if (this.jMenuItemWinSort == null) {
            this.jMenuItemWinSort = new JMenuItem();
            this.jMenuItemWinSort.setText("\u6574\u5217");
            this.jMenuItemWinSort.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedSort();
                }
            });
        }
        return this.jMenuItemWinSort;
    }

    private JMenuItem getJMenuItemCsvImportHistory() {
        if (this.jMenuItemCsvImportHistory == null) {
            this.jMenuItemCsvImportHistory = new JMenuItem();
            this.jMenuItemCsvImportHistory.setText("CVS\u5165\u529b\u5c65\u6b74...(H)");
            this.jMenuItemCsvImportHistory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedHistory();
                }
            });
        }
        return this.jMenuItemCsvImportHistory;
    }

    private void actionPerformedHistory() {
        if (this.jDialogImportHistory == null) {
            this.jDialogImportHistory = new JDialogImportHistory();
            this.jDialogImportHistory.setVisible(true);
        } else {
            this.jDialogImportHistory.toFront();
            this.jDialogImportHistory.setVisible(true);
            this.jDialogImportHistory.reLoad();
        }
    }

    private JCheckBoxMenuItem getJCheckBoxMenuItemDebug() {
        if (this.jCheckBoxMenuItemDebug == null) {
            this.jCheckBoxMenuItemDebug = new JCheckBoxMenuItem();
            this.jCheckBoxMenuItemDebug.setText("\u30c7\u30d0\u30c3\u30af\u30e2\u30fc\u30c9");
            this.jCheckBoxMenuItemDebug.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    debugMode = e.getStateChange() == 1;
                }
            });
        }
        return this.jCheckBoxMenuItemDebug;
    }
}

