/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import jdbcacsess.InfoListSetting;
import jdbcacsess.csv.DupliKeyActionMode;
import jdbcacsess.sql.SchemaTableName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvInfo
extends InfoListSetting<CsvInfo> {
    private String fileName = new String("");
    private SchemaTableName tableName = new SchemaTableName("");
    private String propColumnDelimiter = new String("");
    private String propLineSeparator = new String("");
    private String propEncoding = new String("");
    private String propItemHeader = new String("");
    private String propDuplicateKeyAction = new String("");
    private String propCommitCnt = new String("");
    private char columnDelimiter;
    private String lineSeparator;
    private String encoding;
    private boolean hasItemHeader;
    private DupliKeyActionMode duplicateKeyAction;
    private int commitCnt;

    public String toString() {
        return "[CsvInfo]fileName=" + this.fileName + "tableName=" + this.tableName + "columnDelimiter=" + this.columnDelimiter + "lineSeparator=" + this.lineSeparator + "encoding=" + this.encoding + "hasItemHeader=" + this.hasItemHeader + "duplicateKeyAction=" + (Object)((Object)this.duplicateKeyAction) + "commitCnt=" + this.commitCnt;
    }

    @Override
    public String getKeyValue() {
        return this.getFileName();
    }

    @Override
    public void setKeyValue(String key) {
        this.setFileName(key);
    }

    @Override
    public String getBaseTagName() {
        return "csvinfo";
    }

    @Override
    public CsvInfo getInstance() {
        return new CsvInfo();
    }

    @Override
    public void setFromElement(Element cvsInfoNode) {
        this.setPropTableName(new SchemaTableName(cvsInfoNode.getAttribute("TableName")));
        this.setPropColumnDelimiter(cvsInfoNode.getAttribute("ColumnDelimiter"));
        this.setPropLineSeparator(cvsInfoNode.getAttribute("LineSeparator"));
        this.setPropEncoding(cvsInfoNode.getAttribute("Encoding"));
        this.setPropItemHeader(cvsInfoNode.getAttribute("ItemHeader"));
        this.setPropDuplicateKeyAction(cvsInfoNode.getAttribute("DuplicateKeyAction"));
        this.setPropCommitCnt(cvsInfoNode.getAttribute("CommitCnt"));
    }

    @Override
    public void addToElement(Element cvsInfoNode) {
        cvsInfoNode.setAttribute("TableName", this.getPropTableName().getCompleteTableName());
        cvsInfoNode.setAttribute("ColumnDelimiter", this.getPropColumnDelimiter());
        cvsInfoNode.setAttribute("LineSeparator", this.getPropLineSeparator());
        cvsInfoNode.setAttribute("Encoding", this.getPropEncoding());
        cvsInfoNode.setAttribute("ItemHeader", this.getPropItemHeader());
        cvsInfoNode.setAttribute("DuplicateKeyAction", this.getPropDuplicateKeyAction());
        cvsInfoNode.setAttribute("CommitCnt", this.getPropCommitCnt());
    }

    public Vector<String> getHeader() {
        Vector<String> list = new Vector<String>();
        list.add("\u30d5\u30a1\u30a4\u30eb\u540d");
        list.add("\u30c6\u30fc\u30d6\u30eb\u540d");
        list.add("\u533a\u5207\u308a\u6587\u5b57");
        list.add("\u6539\u884c\u6587\u5b57");
        list.add("\u6587\u5b57\u30b3\u30fc\u30c9");
        list.add("\u898b\u51fa\u3057\u6709\u7121");
        list.add("\u91cd\u8907\u30c7\u30fc\u30bf");
        list.add("commit\u65b9\u6cd5");
        return list;
    }

    public String getData(int index) {
        String rtn = "";
        switch (index) {
            case 0: {
                rtn = this.getFileName();
                break;
            }
            case 1: {
                rtn = this.getPropTableName().getCompleteTableName();
                break;
            }
            case 2: {
                rtn = this.getPropColumnDelimiter();
                break;
            }
            case 3: {
                rtn = this.getPropLineSeparator();
                break;
            }
            case 4: {
                rtn = this.getPropEncoding();
                break;
            }
            case 5: {
                rtn = this.getPropItemHeader();
                break;
            }
            case 6: {
                rtn = this.getPropDuplicateKeyAction();
                break;
            }
            case 7: {
                rtn = this.getPropCommitCnt();
                break;
            }
        }
        return rtn;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPropTableName(SchemaTableName stn) {
        this.tableName = stn;
    }

    public SchemaTableName getPropTableName() {
        return this.tableName;
    }

    public DefaultComboBoxModel getModelColumnDelimiter() {
        DefaultComboBoxModel<String> modelColumnDelimiter = new DefaultComboBoxModel<String>();
        modelColumnDelimiter.addElement("\u30ab\u30f3\u30de");
        modelColumnDelimiter.addElement("\u30bf\u30d6");
        return modelColumnDelimiter;
    }

    public void setPropColumnDelimiter(String propColumndelimiter) {
        this.propColumnDelimiter = propColumndelimiter;
        if (propColumndelimiter.equals("\u30ab\u30f3\u30de")) {
            this.columnDelimiter = (char)44;
        }
        if (propColumndelimiter.equals("\u30bf\u30d6")) {
            this.columnDelimiter = (char)9;
        }
    }

    public String getPropColumnDelimiter() {
        return this.propColumnDelimiter;
    }

    public char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public DefaultComboBoxModel getModelLineSeparator() {
        DefaultComboBoxModel<String> modelLineSeparator = new DefaultComboBoxModel<String>();
        modelLineSeparator.addElement("\u5b9f\u884c\u74b0\u5883\u30c7\u30d5\u30a9\u30eb\u30c8");
        modelLineSeparator.addElement("CRLF");
        modelLineSeparator.addElement("LF");
        modelLineSeparator.addElement("CR");
        return modelLineSeparator;
    }

    public void setPropLineSeparator(String propLineSeparator) {
        this.propLineSeparator = propLineSeparator;
        if (propLineSeparator.equals("\u5b9f\u884c\u74b0\u5883\u30c7\u30d5\u30a9\u30eb\u30c8")) {
            this.lineSeparator = System.getProperty("line.separator");
        }
        if (propLineSeparator.equals("CRLF")) {
            this.lineSeparator = "\r\n";
        }
        if (propLineSeparator.equals("LF")) {
            this.lineSeparator = "\n";
        }
        if (propLineSeparator.equals("CR")) {
            this.lineSeparator = "\r";
        }
    }

    public String getPropLineSeparator() {
        return this.propLineSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public DefaultComboBoxModel getModelEncoding() {
        DefaultComboBoxModel<String> modelEncoding = new DefaultComboBoxModel<String>();
        modelEncoding.addElement("\u5b9f\u884c\u74b0\u5883\u30c7\u30d5\u30a9\u30eb\u30c8");
        modelEncoding.addElement("UTF-8");
        modelEncoding.addElement("EUC_JP");
        modelEncoding.addElement("Shift_JIS");
        modelEncoding.addElement("Windows-31J");
        return modelEncoding;
    }

    public void setPropEncoding(String propEncode) {
        this.propEncoding = propEncode;
        if (propEncode.equals("\u5b9f\u884c\u74b0\u5883\u30c7\u30d5\u30a9\u30eb\u30c8")) {
            this.encoding = System.getProperty("file.encoding");
        }
        if (propEncode.equals("Shift_JIS")) {
            this.encoding = "Shift_JIS";
        }
        if (propEncode.equals("Windows-31J")) {
            this.encoding = "Windows-31J";
        }
        if (propEncode.equals("EUC_JP")) {
            this.encoding = "EUC_JP";
        }
        if (propEncode.equals("UTF-8")) {
            this.encoding = "UTF-8";
        }
    }

    public String getPropEncoding() {
        return this.propEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public DefaultComboBoxModel getModelItemHeader() {
        DefaultComboBoxModel<String> modelItemHeader = new DefaultComboBoxModel<String>();
        modelItemHeader.addElement("\u6709\u308a");
        modelItemHeader.addElement("\u7121\u3057");
        return modelItemHeader;
    }

    public void setPropItemHeader(String propItemHeader) {
        this.propItemHeader = propItemHeader;
        if (propItemHeader.equals("\u6709\u308a")) {
            this.hasItemHeader = true;
        }
        if (propItemHeader.equals("\u7121\u3057")) {
            this.hasItemHeader = false;
        }
    }

    public String getPropItemHeader() {
        return this.propItemHeader;
    }

    public boolean hasItemHeader() {
        return this.hasItemHeader;
    }

    public int getAllWayInsert() {
        return 0;
    }

    public DefaultComboBoxModel getModelDuplicateKeyAction() {
        DefaultComboBoxModel<String> modelDuplicateKeyAction = new DefaultComboBoxModel<String>();
        modelDuplicateKeyAction.addElement("\u5e38\u306bINSERT");
        modelDuplicateKeyAction.addElement("UPDATE\u3059\u308b");
        modelDuplicateKeyAction.addElement("\u5168\u4ef6DELETE\u5f8cINSERT");
        return modelDuplicateKeyAction;
    }

    public void setPropDuplicateKeyAction(String propDuplicateKeyAction) {
        this.propDuplicateKeyAction = propDuplicateKeyAction;
        if (propDuplicateKeyAction.equals("\u5e38\u306bINSERT")) {
            this.duplicateKeyAction = DupliKeyActionMode.ALLWAYINSERT;
        }
        if (propDuplicateKeyAction.equals("UPDATE\u3059\u308b")) {
            this.duplicateKeyAction = DupliKeyActionMode.UPDATE;
        }
        if (propDuplicateKeyAction.equals("\u5168\u4ef6DELETE\u5f8cINSERT")) {
            this.duplicateKeyAction = DupliKeyActionMode.ALLDELETE;
        }
    }

    public String getPropDuplicateKeyAction() {
        return this.propDuplicateKeyAction;
    }

    public DupliKeyActionMode getDuplicateKeyAction() {
        return this.duplicateKeyAction;
    }

    public DefaultComboBoxModel getModelCommitCnt() {
        DefaultComboBoxModel<String> modelCommitCnt = new DefaultComboBoxModel<String>();
        modelCommitCnt.addElement("\u6700\u5f8c\u306b1\u56de");
        modelCommitCnt.addElement("100\u4ef6\u6bce\u3067\u6700\u5f8c\u306b1\u56de");
        modelCommitCnt.addElement("AutoCommit");
        return modelCommitCnt;
    }

    public void setPropCommitCnt(String propCommitCnt) {
        this.propCommitCnt = propCommitCnt;
        if (propCommitCnt.equals("\u6700\u5f8c\u306b1\u56de")) {
            this.commitCnt = 1;
        }
        if (propCommitCnt.equals("AutoCommit")) {
            this.commitCnt = 0;
        }
        if (propCommitCnt.equals("100\u4ef6\u6bce\u3067\u6700\u5f8c\u306b1\u56de")) {
            this.commitCnt = 100;
        }
    }

    public String getPropCommitCnt() {
        return this.propCommitCnt;
    }

    public int getCommitCnt() {
        return this.commitCnt;
    }
}

