/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.io.ByteArrayOutputStream;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import jdbcacsess.sql.Binary;

public class CellEditorBinary
extends DefaultCellEditor {
    private static final long serialVersionUID = 2461482951031111945L;

    public CellEditorBinary(final JTextField textField) {
        super(textField);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){

            public void setValue(Object value) {
                if (value != null && value instanceof Binary) {
                    textField.setText(value.toString());
                } else {
                    textField.setText("");
                }
            }

            public Object getCellEditorValue() {
                return new Binary(this.HexToBin(textField.getText()));
            }

            private byte[] HexToBin(String source) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = 0;
                while (i < source.length()) {
                    int b = Integer.parseInt(source.substring(i, i + 2), 16);
                    baos.write(b);
                    i += 2;
                }
                return baos.toByteArray();
            }
        };
        textField.addActionListener(this.delegate);
    }
}

