/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SchemaTableName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExec {
    private static Connection _con;
    private static String _userId;
    private static String _passWord;
    private static String _url;
    private static String _classPath;
    private static boolean lower;
    private static boolean upper;
    static Map<String, ArrayList<String>> tableNamesMap;

    static {
        tableNamesMap = new HashMap<String, ArrayList<String>>();
    }

    public static boolean isConnect() {
        if (_con == null) {
            return false;
        }
        try {
            return !_con.isClosed();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void connect(String userId, String passWord, String url, String classPath) throws SQLException, ClassNotFoundException {
        _userId = userId;
        _passWord = passWord;
        _url = url;
        _classPath = classPath;
        SqlExec.disconnect();
        Class.forName(classPath);
        _con = DriverManager.getConnection(url, userId, passWord);
        _con.setAutoCommit(true);
        lower = _con.getMetaData().storesLowerCaseIdentifiers();
        upper = _con.getMetaData().storesUpperCaseIdentifiers();
        tableNamesMap.clear();
    }

    public static void setAutoCommit(boolean flg) throws SQLException {
        if (SqlExec.isConnect()) {
            _con.setAutoCommit(flg);
        }
    }

    public static String getConnectString() {
        return String.valueOf(_url) + " [User=" + _userId + "]" + " " + _classPath;
    }

    public static void disconnect() {
        if (SqlExec.isConnect()) {
            try {
                _con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        _con = null;
    }

    public static void disconnect(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void commit() throws SQLException {
        if (SqlExec.isConnect()) {
            System.out.println("SqlExec.commit()");
            _con.commit();
        }
    }

    public static void rollback() throws SQLException {
        if (SqlExec.isConnect()) {
            System.out.println("SqlExec.rollback()");
            _con.rollback();
        }
    }

    public static void rollbackError() {
        try {
            if (SqlExec.isConnect()) {
                System.out.println("SqlExec.rollbackError()");
                _con.rollback();
            }
        }
        catch (SQLException err) {
            System.out.println("\u30a8\u30e9\u30fc\u767a\u751f\u6642\u306e\u5f37\u5236RollBack\u3067\u30a8\u30e9\u30fc\u3001\u7121\u8996\u3057\u307e\u3059\u3002");
        }
    }

    public static int execUpdate(String sqlCommand, Connection con) throws SQLException {
        con.clearWarnings();
        System.out.println("SqlExec.execUpdate " + sqlCommand);
        Statement stmtUpdate = con.createStatement();
        int cnt = 0;
        try {
            stmtUpdate.executeUpdate(sqlCommand);
            cnt = stmtUpdate.getUpdateCount();
        }
        finally {
            stmtUpdate.close();
        }
        return cnt;
    }

    public static String getCatalog() throws SQLException {
        tableNamesMap = new HashMap<String, ArrayList<String>>();
        String catalog = _con.getCatalog().toString();
        if (catalog == null) {
            return "\u30ab\u30bf\u30ed\u30b0\u7121\u3057";
        }
        return catalog;
    }

    public static ArrayList<String> getPrimaryKeys(String schemaName, String tableName) throws SQLException {
        TreeMap<Short, String> columnNamesMap = new TreeMap<Short, String>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getPrimaryKeys(null, schemaName, tableName);
        while (rs.next()) {
            columnNamesMap.put(rs.getShort(5), rs.getString(4));
        }
        rs.close();
        ArrayList<String> currentTablePrimkeys = new ArrayList<String>();
        for (Short idx : columnNamesMap.keySet()) {
            currentTablePrimkeys.add((String)columnNamesMap.get(idx));
        }
        return currentTablePrimkeys;
    }

    public static ArrayList<String> getSchemaNames() throws SQLException {
        ArrayList<String> schemaNames = new ArrayList<String>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getSchemas();
        while (rs.next()) {
            String schema = rs.getString(1);
            schemaNames.add(schema);
        }
        rs.close();
        if (schemaNames.isEmpty()) {
            schemaNames.add(" ");
        }
        return schemaNames;
    }

    public static ArrayList<String> getSimpleTableNames(String schema) throws SQLException {
        ArrayList<String> tableNames = tableNamesMap.get(schema);
        if (tableNames != null) {
            return tableNames;
        }
        tableNames = new ArrayList();
        DatabaseMetaData md = _con.getMetaData();
        String[] tableType = new String[]{"TABLE", "VIEW"};
        ResultSet rs = md.getTables(null, schema, null, tableType);
        while (rs.next()) {
            tableNames.add(rs.getString(3));
        }
        rs.close();
        tableNamesMap.put(schema, tableNames);
        return tableNames;
    }

    public static ArrayList<SchemaTableName> getCompleteTableNames(String schema) throws SQLException {
        ArrayList<SchemaTableName> completeTableNames = new ArrayList<SchemaTableName>();
        for (String table : SqlExec.getSimpleTableNames(schema)) {
            completeTableNames.add(new SchemaTableName(schema, table));
        }
        return completeTableNames;
    }

    public static ArrayList<ColumnInfoTable> getColumnMames(SchemaTableName schemaTable) throws SQLException {
        return SqlExec.getColumnMames(schemaTable.getSchemaName(), schemaTable.getTableName());
    }

    public static ArrayList<ColumnInfoTable> getColumnMames(String schema, String tableName) throws SQLException {
        TreeMap<Integer, ColumnInfoTable> columnNamesMap = new TreeMap<Integer, ColumnInfoTable>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getColumns(null, schema, tableName, null);
        int no = 0;
        while (rs.next()) {
            ColumnInfoTable ci = new ColumnInfoTable(new SchemaTableName(schema, rs.getString(3)), rs.getString(4), rs.getInt(5), rs.getString(6), rs.getInt(7), rs.getInt(9), rs.getInt(11) == 1, rs.getString(12), ++no);
            columnNamesMap.put(rs.getInt(17), ci);
        }
        rs.close();
        ArrayList<ColumnInfoTable> columnNames = new ArrayList<ColumnInfoTable>();
        for (Integer idx : columnNamesMap.keySet()) {
            columnNames.add((ColumnInfoTable)columnNamesMap.get(idx));
        }
        return columnNames;
    }

    public static String convertStoresIdentifiers(String str) {
        if (lower) {
            return str.toLowerCase();
        }
        if (upper) {
            return str.toUpperCase();
        }
        return str;
    }

    public static Connection getNewConnection() throws SQLException {
        Connection con = DriverManager.getConnection(_url, _userId, _passWord);
        con.setAutoCommit(_con.getAutoCommit());
        if (con.getMetaData().getDatabaseProductName().equals("Oracle")) {
            Statement stmt = con.createStatement();
            stmt.execute("ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'");
            stmt.execute("ALTER SESSION SET NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF6'");
            stmt.close();
        }
        return con;
    }

    public static Connection getCon() {
        return _con;
    }
}

