/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Observable;
import java.util.Vector;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.BreakStatus;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.JDialogResultSetMD;
import jdbcacsess.sql.OracleDate;
import jdbcacsess.sql.OutputResultble;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlExec;

public class QueryExecute
extends Observable
implements Runnable {
    private volatile boolean runner;
    private volatile int cnt;
    private int notifyCnt;
    private ResultSet rs = null;
    private Statement stmt = null;
    private OutputResultble outputResult;
    private SqlAnalyze sqlAnalyze;
    private Connection con = null;
    private Vector<ColumnInfoResult> selectColmunInfos;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public QueryExecute(OutputResultble outputResult, SqlAnalyze sqlAnalyze, Connection con) throws FileNotFoundException, IOException {
        this.outputResult = outputResult;
        this.sqlAnalyze = sqlAnalyze;
        this.con = con;
        this.runner = true;
        this.cnt = 0;
        this.notifyCnt = 0;
        this.outputResult.init();
    }

    public void run() {
        try {
            try {
                this.openSqlCursor(this.sqlAnalyze.getSqlStatement());
                this.sqlAnalyze.setSelectColmunInfo(this.selectColmunInfos);
                this.outputResult.setUpdatable(this.sqlAnalyze.isSelectUpdatable());
                this.outputResult.setTableName(this.sqlAnalyze.getSchemaTableName());
                this.outputResult.setResultHeader(this.selectColmunInfos);
                while (this.runner) {
                    if (!this.hasQueryNext()) {
                        break;
                    }
                    ++this.notifyCnt;
                    this.outputResult.setResultDetail(this.getQueryReslut());
                    if (this.notifyCnt <= 99) continue;
                    this.notifyCnt = 0;
                    this.setChanged();
                    this.notifyObservers(new BreakStatus(this.cnt, this.runner, true, this.sqlAnalyze));
                }
            }
            catch (SQLException sqlException) {
                sqlException.printStackTrace();
                SqlExec.rollbackError();
                this.setChanged();
                this.notifyObservers(sqlException);
                this.outputResult.completeQuery();
                try {
                    this.closeSqlCursor();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.setChanged();
                this.notifyObservers(exception);
                this.outputResult.completeQuery();
                try {
                    this.closeSqlCursor();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        finally {
            this.outputResult.completeQuery();
            try {
                this.closeSqlCursor();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.setChanged();
        this.notifyObservers(new BreakStatus(this.cnt, this.runner, false, this.sqlAnalyze));
    }

    public void setCalnel() {
        this.runner = false;
    }

    private void openSqlCursor(String sqlStatement) throws SQLException, IOException {
        this.selectColmunInfos = new Vector();
        this.stmt = this.con.createStatement();
        this.rs = this.stmt.executeQuery(sqlStatement);
        int col = this.rs.getMetaData().getColumnCount();
        ResultSetMetaData rsm = this.rs.getMetaData();
        int i = 1;
        while (i <= col) {
            Class<Object> columnClass;
            if (this.isOracleBinary(i)) {
                try {
                    columnClass = Class.forName("[B");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    columnClass = Object.class;
                }
            } else if (this.isOracleDate(i)) {
                columnClass = OracleDate.class;
            } else {
                try {
                    columnClass = Class.forName(rsm.getColumnClassName(i));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    columnClass = Object.class;
                }
            }
            ColumnInfoResult colInfo = new ColumnInfoResult(columnClass, rsm.getColumnDisplaySize(i), rsm.getColumnLabel(i), rsm.getColumnType(i), rsm.getColumnTypeName(i), rsm.getPrecision(i), rsm.getScale(i), rsm.isNullable(i) == 1);
            this.selectColmunInfos.add(colInfo);
            ++i;
        }
    }

    public boolean hasQueryNext() throws SQLException {
        if (this.rs == null) {
            return false;
        }
        if (this.rs.next()) {
            return true;
        }
        this.rs.close();
        return false;
    }

    private boolean isOracleDate(int i) throws SQLException {
        return this.rs.getMetaData().getColumnType(i) == 91 && this.rs.getMetaData().getColumnClassName(i).equals("java.sql.Timestamp");
    }

    private boolean isOracleBinary(int i) throws SQLException {
        String name = this.rs.getMetaData().getColumnClassName(i);
        return name.equals("byte[]") || name.equals("oracle.sql.BLOB");
    }

    public Vector getQueryReslut() throws SQLException {
        ++this.cnt;
        Vector<Object> rowData = new Vector<Object>();
        int i = 1;
        while (i <= this.rs.getMetaData().getColumnCount()) {
            if (JFrameMain.debugMode && this.cnt == 1) {
                JDialogResultSetMD a = JDialogResultSetMD.getInstance();
                a.setData(this.rs);
            }
            if (this.isOracleDate(i)) {
                Timestamp ts = this.rs.getTimestamp(i);
                if (ts == null) {
                    rowData.add(null);
                } else {
                    rowData.add(new OracleDate(this.rs.getTimestamp(i).getTime()));
                }
            } else if (this.rs.getMetaData().getColumnType(i) == 2004) {
                Blob blob = this.rs.getBlob(i);
                rowData.add(blob.getBytes(1L, (int)blob.length()));
            } else if (this.rs.getMetaData().getColumnType(i) == 2005) {
                Clob clob = this.rs.getClob(i);
                rowData.add(clob.getSubString(1L, (int)clob.length()));
            } else {
                rowData.add(this.rs.getObject(i));
            }
            ++i;
        }
        return rowData;
    }

    private void closeSqlCursor() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }
}

