/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingFile {
    private static SettingFile _instance = new SettingFile();
    private final String folderName = ".jdbcacsess";
    private Document doc;
    private Element root;
    private File file;

    private SettingFile() {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            this.getFile();
            this.doc = this.file.exists() ? builder.parse(this.file) : builder.getDOMImplementation().createDocument("", "root", null);
            this.root = this.doc.getDocumentElement();
            this.save();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static SettingFile getInstance() {
        return _instance;
    }

    private void getFile() {
        String userHome = System.getProperty("user.home");
        String userPath = String.valueOf(userHome) + System.getProperty("file.separator") + ".jdbcacsess";
        String fileName = String.valueOf(userPath) + System.getProperty("file.separator") + "setting.xml";
        System.out.println("settingXML\u30d5\u30a1\u30a4\u30eb\u540d:" + fileName);
        File path = new File(userPath);
        if (!path.isDirectory()) {
            path.mkdir();
        }
        this.file = new File(fileName);
    }

    public void save() throws TransformerException, FileNotFoundException {
        TransformerFactory tff = TransformerFactory.newInstance();
        Transformer tf = tff.newTransformer();
        tf.setOutputProperty("method", "xml");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        tf.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource();
        src.setNode(this.doc);
        StreamResult target = new StreamResult();
        target.setOutputStream(new FileOutputStream(this.file));
        tf.transform(src, target);
    }

    public Element getRootElement(String tagName) {
        return this.getElement(this.root, tagName);
    }

    public Element getElement(Element node, String tagName) {
        NodeList childNodes = node.getChildNodes();
        Element resultElement = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node order = childNodes.item(i);
            if (order.getNodeType() == 1 && order.getNodeName().equals(tagName)) {
                resultElement = (Element)order;
                break;
            }
            ++i;
        }
        if (resultElement == null) {
            resultElement = this.doc.createElement(tagName);
            node.appendChild(resultElement);
        }
        return resultElement;
    }

    public Document getDoc() {
        return this.doc;
    }
}

