#include once "windows.bi"
#include once "win/commctrl.bi"
#include once "kogaion_gui_standards.bas"
#include once "kogaion_gui_ex_sysutils.bi"

dim shared as string sAddress(11)
dim shared as integer iAddress(11)

dim shared as string wDir

wDir=mid(Command(0),1,inStrRev(Command(0),"/"))

open wDir & "plugin_data" for binary access read as #1
   dim as integer i
   while not EOF(1)
        Line Input #1,sAddress(i)
        i+=1
   wend
   Close #1
   
'kill "plugin_data"

for i as integer=0 to 10
    iAddress(i)=valint(sAddress(i))
next

dim shared as PForm Form

dim shared as hmenu Menu
dim shared as hmenu PluginMenu,ClassMenu,CodeIt
dim shared as hwnd App,Main,ToolBar,Panel

/'dim shared as dword App'/

dim shared as QStrings List,Names

dim shared as function stdcall(v as zstring ptr) as any ptr newEditor
dim shared as sub stdcall(v as any ptr) freePage
dim shared as function stdcall as any ptr GetActivePage
dim shared as sub stdcall (byref v as pobject) inspect

newEditor=cast(function stdcall(v as zstring ptr) as any ptr,iaddress(0))
freePage=cast(sub stdcall(v as any ptr),iaddress(1))
getActivePage=cast(function stdcall as any ptr,iaddress(2))
inspect=cast(sub stdcall (byref v as pobject),iaddress(10))

Panel=cast(hwnd,iaddress(8))

sub DesignerInserting(sender as QDesigner,ByRef c as string,ByRef es as integer,ByRef s as integer,ByRef id as integer )
    if Form then
       if lcase(c)="qcheckbox" then s=bs_autocheckbox
       if lcase(c)="qradiobutton" then s=bs_autoradiobutton
       if lcase(c)="qgroupbox" then s=bs_groupbox
       if lcase(c)="qcombobox" then s=cbs_dropdownlist
    end if
end sub

sub DesignerSelection(sender as QDesigner,c as hwnd)
    if isWindow(c) then
       dim as PFrame F=W_Frame(c)
       if inspect then inspect(F)
    end if
end sub

sub FormActivate(sender as QObject)
    Form=Q_Form(sender)
    if Form then
          Form->Designer.OnInsertingControl=@DesignerInserting
          Form->Designer.onChangeSelection=@DesignerSelection
    end if
end sub

function Hook stdcall(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
    static as any ptr Page
    select case msg
    case wm_command
         select case loword(wparam)
         case 499
              MessageBox(Main,"FreeBasic Designer Plugin"+chr(10)+"copyright (c)2020 vasile eodor nastasa"+chr(10)+"mail: nastasa.eodor@gmail.com, web: http://www.rqwork.de","Plugin",mb_iconinformation or mb_taskmodal or mb_applmodal)
         case 501
              dim as hwnd h=createwindowex(0,"qform","",ws_overlappedwindow or ws_clipchildren or ws_clipsiblings,0,0,0,0,iif(Panel,Panel,App),0,GetModuleHandle(0),0)
              if iswindow(h) then
                 setparent(h,panel)
                 moveWindow(h,0,0,400,250,true)
                 ShowWindow(h,sw_show)
                 BringWindowToTop(h)
                 Form=w_Form(h)
                 Form->onActivate=@FormActivate
                 Form->Designer.Dialog=Form->Handle
                 Form->Designer.Active=true
                 Names.add("QForm",h)
                 Form->name="Form"& Names.occurencies("QForm")
              end if
         case 502
              if Page then
                 freePage(Page)
                 Page=0
              end if
         case 503
              List.Clear
              if Form=0 then
                 messageDlg("Add Dialog first.","Plugin",mb_iconwarning)
                 exit select
              end if
              List.add("' do not forget to set de compiler swith in order to get include's")
              List.add("")
              List.add("dim shared as " & ClassNameIs(Form->Handle) & " " & Form->name)
              for i as integer=0 to Form->Designer.ChildCount-1
                 if ClassNameIs(Form->Designer.Child(i))<>"Dot" then
                    Names.add(ClassNameIs(Form->Designer.Child(i)),Form->Designer.Child(i))
                    w_Frame(Form->Designer.Child(i)).Name=ClassNameIs(Form->Designer.Child(i)) & Names.occurencies(ClassNameIs(Form->Designer.Child(i)))
                    List.add("dim shared as " & ClassNameIs(Form->Designer.Child(i))) & " " & w_Frame(Form->Designer.Child(i)).Name
                 end if
              next
              List.add("")
              for i as integer=0 to Form->Designer.ChildCount-1
                 if ClassNameIs(Form->Designer.Child(i))<>"Dot" then
                    dim as PFrame P=w_Frame(GetParent(Form->Designer.Child(i)))
                    dim as PFrame C=w_Frame(Form->Designer.Child(i))
                    if (P>0) and (C>0) then
                       List.add(C->Name & ".Parent=" & P->name)
                       List.add(C->Name & ".SetBounds(" & C->Left &"," & C->Top & "," & C->Width & "," & C->Height & ")")
                    end if
                 end if
              next
              List.add("")
              List.add(Form->Name & ".SetBounds(" & Form->Left &"," & Form->Top & "," & Form->Width & "," & Form->Height & ")")
              List.add(Form->name & ".Parent=0")
              List.Add("application.run")
              if @NewEditor then
                 dim as string s=List.Text
                 Page=NewEditor(strptr(s))
              end if
         case 504
              List.Clear
              if Form=0 then
                 messageDlg("Add Dialog first.","Plugin",mb_iconwarning)
                 exit select
              end if
              dim as rect wr
              dim as integer x,y,cx,cy
              GetWindowRect(Form->Handle,@wr)
              MapWindowPoints(0,GetParent(Form->Handle),cast(point ptr,@wr),2)
              WIN2DUI(Form->Handle,x,y,cx,cy)
              List.add("")
              List.add(Form->name & " DIALOGEX " & wr.left & "," & wr.Top & "," & wr.right & "," & wr.bottom)
              List.add("CLASS """ & ClassNameIs(Form->Handle) & """")
              List.add("CAPTION """ & Form->Text & """")
              List.add("STYLE " & GetWindowLong(Form->Handle,gwl_style))
              List.add("EXSTYLE " & GetWindowLong(Form->Handle,gwl_exstyle))
              List.add("BEGIN")
              for i as integer=0 to Form->Designer.ChildCount-1
                 if ClassNameIs(Form->Designer.Child(i))<>"Dot" then
                    GetWindowRect(Form->Designer.Child(i),@wr)
                    MapWindowPoints(0,GetParent(Form->Designer.Child(i)),cast(point ptr,@wr),2)
                    x=wr.left
                    y=wr.top
                    cx=wr.right-wr.left
                    cy=wr.bottom-wr.top
                    Names.add(ClassNameIs(Form->Designer.Child(i)),Form->Designer.Child(i))
                    w_Frame(Form->Designer.Child(i)).Name=ClassNameIs(Form->Designer.Child(i)) & Names.occurencies(ClassNameIs(Form->Designer.Child(i)))
                    WIN2DUI(Form->Designer.Child(i),x,y,cx,cy)
                    List.add("CONTROL """  & w_Frame(Form->Designer.Child(i)).Name & """," & GetWindowLong(Form->Designer.Child(i),gwl_id) & "," & """" & ClassNameIs(Form->Designer.Child(i)) & """," & GetWindowLong(Form->Designer.Child(i),gwl_style) &"," & X & "," & Y & "," & CX & "," & CY & "," & GetWindowLong(Form->Designer.Child(i),gwl_exstyle))
                 end if
              next
              List.add("END")
              if @NewEditor then
                 dim as string s=List.Text
                 Page=NewEditor(strptr(s))
              end if
         case 505
              List.Clear
              if Form=0 then
                 messageDlg("Add Dialog first.","Plugin",mb_iconwarning)
                 exit select
              end if
         case 600
              if Form then Form->Designer.ClassName=""
         case 601
              if Form then
                Form->Designer.ClassName="QLabel"
                Names.Add("QLabel",Form->Designer.SelControl)
              else
                messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 602
              if Form then
                 Form->Designer.ClassName="QButton"
                 Names.Add("QButton",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 603
              if Form then
                 Form->Designer.ClassName="QGroupBox"
                 Names.Add("QGroupBox",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 604
              if Form then
                 Form->Designer.ClassName="QCheckBox"
                 Names.Add("QCheckBox",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 605
              if Form then
                 Form->Designer.ClassName="QRadioButton"
                 Names.Add("QRadioButton",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 606
              if Form then
                 Form->Designer.ClassName="QEdit"
                 Names.Add("QEdit",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 607
              if Form then
                 Form->Designer.ClassName="QComboBox"
                 Names.Add("QCoboBox",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 608
              if Form then
                 Form->Designer.ClassName="QListBox"
                 Names.Add("QListBox",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         case 609
              if Form then
                 Form->Designer.ClassName="QScrollBar"
                 Names.Add("QScrollBar",Form->Designer.SelControl)
              else
                 messageDlg("Add dialog first.","Designer",mb_iconwarning)
              end if
         end select
         return CallWindowProc(GetProp(dlg,"@@@_proc"),dlg,msg,wparam,lparam)
    end select
    return CallWindowProc(GetProp(dlg,"@@@_proc"),dlg,msg,wparam,lparam)
end function

Main=FindWindow("TMain","Shrimp")
Menu=GetMenu(Main)

if not isWindow(Main) then     '''for delphi ide
   Main=cast(hwnd,iaddress(3))
   Menu=cast(hmenu,iaddress(4))
end if

sub CreatePluginMenu
   PluginMenu=CreatePopupMenu

   AppendMenu(pluginMenu,mf_bycommand or mf_string,499,"About")
   AppendMenu(pluginMenu,mf_separator,-1,"-")
   AppendMenu(pluginMenu,mf_bycommand or mf_string,501,"NewDialog")
   AppendMenu(pluginMenu,mf_separator,-1,"-")
   ClassMenu=CreatePopupMenu
   AppendMenu(pluginMenu,mf_popup,cint(ClassMenu),"Classes")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,600,"Null")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,601,"Label")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,602,"Button")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,603,"GroupBox")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,604,"CheckBox")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,605,"RadioButton")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,606,"Edit")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,607,"ComboBox")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,608,"ListBox")
   AppendMenu(ClassMenu,mf_bycommand or mf_string,609,"ScrollBar")
   AppendMenu(pluginMenu,mf_separator,-1,"-")
   CodeIt=CreatePopupMenu
   AppendMenu(pluginMenu,mf_popup,cint(CodeIt),"Code It...")
   AppendMenu(CodeIt,mf_bycommand or mf_string,503,"as GUI")
   AppendMenu(CodeIt,mf_bycommand or mf_string,504,"as Resorce Script")
   AppendMenu(CodeIt,mf_bycommand or mf_string,505,"as API")
   AppendMenu(pluginMenu,mf_separator,-1,"-")
   AppendMenu(pluginMenu,mf_bycommand or mf_string,502,"Free Page")
   if isMenu(menu) then
      AppendMenu(Menu,mf_popup,cint(PluginMenu),"Plugin")
   else
      messageDlg("The mainmenu is missing.","Plugin",mb_iconwarning)
   end if
end sub

function EnumChildsProc(dlg as hwnd,ldata as lparam) as boolean  '''another way to search for ToolBar
    dim as string*256 cn
    dim as string className=""
    GetCLassName(dlg,cn,256)
    if trim(cn)="TToolBar" then
       ToolBar=dlg
       return false
    else
       return true
    end if
end function

sub Initialize
    if isWindow(Main) then
       SetProp(Main,"@@@_proc",cast(wndproc,SetWindowLongPtr(Main,gwlp_wndproc,cint(@Hook))))
    end if
    CreatePluginMenu
    EnumChildWindows(Main,cast(wndenumproc,@EnumChildsProc),cint(@ToolBar))
    messagedlg("Success.Plugin was accepted by Hrimp.","Shrimp-Plugin v1.5",mb_iconinformation)
end sub

Initialize

sub Initialization constructor
end sub

sub Finalization destructor
    if isMenu(PluginMenu) then
       DestroyMenu(PluginMenu)
       PluginMenu=0
    end if
end sub