/'
This is an FreeBasic GUI Application
Generated by Skeleton 1.0
Nastasa Eodor
nastasa.eodor@gmail.com
http://rqwork.de

'/

#include once "windows.bi"
#include once "win/commctrl.bi"
#include once "win/commdlg.bi"

#define instance GetModuleHandle(0)

common shared as HWND hAppHandle

#include once "designer.bi"

dim shared as TDesigner Designer = hAppHandle

sub MouseMove(Sender as TDesigner, X as integer, Y as integer, ByRef Over as HWND)
    dim as string s = "TinyDesigner [X: " & X & ", Y: " & Y & " Control: " & Over & "]"
    SetWindowText(hAppHandle, s)
end sub

Designer.OnMouseMove = @MouseMove

function myFBApplication_WindowProc(hDlg as HWND, Msg as UINT, wParam as WPARAM, lParam as LPARAM) as LRESULT
   select case Msg
        case WM_CREATE
           var hMenu   = CreateMenu
           var hFile   = CreatePopupMenu
           AppendMenu(hFile, MF_STRING, 10001, @"DesignTime Mode")
           AppendMenu(hFile, MF_STRING, 10002, @"RunTime Mode")
           AppendMenu(hFile, MF_SEPARATOR, -1, @"-")
           AppendMenu(hFile, MF_STRING, 10003, @"Snap To Grid")
           AppendMenu(hFile, MF_STRING, 10004, @"Show/Hide Grid")
           var hColor = CreatePopupMenu
           AppendMenu(hColor, MF_STRING, 101, @"Red")
           AppendMenu(hColor, MF_STRING, 102, @"Blue")
           AppendMenu(hColor, MF_STRING, 103, @"Gren")
           AppendMenu(hColor, MF_STRING, 104, @"Black")
           AppendMenu(hFile, MF_POPUP, cint(hColor), @"Dot Color")
           var hSize = CreatePopupMenu
           AppendMenu(hSize, MF_STRING, 105, @"3 x 3")
           AppendMenu(hSize, MF_STRING, 106, @"4 x 4")
           AppendMenu(hSize, MF_STRING, 107, @"6 x 6")
           AppendMenu(hSize, MF_STRING, 108, @"8 x 8")
           AppendMenu(hFile, MF_POPUP, cint(hSize), @"Grid Size")
           AppendMenu(hFile, MF_SEPARATOR, -1, @"-")
           AppendMenu(hFile, MF_STRING, 10005, @"Exit")
           var hEdit   = CreatePopupMenu
           AppendMenu(hEdit, MF_STRING, 10006, @"Button")
           AppendMenu(hEdit, MF_STRING, 10007, @"EditBox")
           AppendMenu(hEdit, MF_STRING, 10008, @"ComboBox")
           AppendMenu(hEdit, MF_STRING, 10009, @"TrackBar")
           AppendMenu(hEdit, MF_STRING, 10010, @"ToolBar")
           AppendMenu(hEdit, MF_STRING, 10011, @"TabControl")
           var hHelp   = CreatePopupMenu
           AppendMenu(hHelp, MF_STRING, 10012, @"About..")
           AppendMenu(hMenu, MF_POPUP, cint(hFile), @"Action")
           AppendMenu(hMenu, MF_POPUP, cint(hEdit), @"Classes")
           AppendMenu(hMenu, MF_POPUP, cint(hHelp), @"Help")
           SetMenu(hDlg, hMenu)
           DrawMenuBar(hDlg)
           CreateWindowEx(0,"BUTTON","Button",WS_CHILD OR WS_VISIBLE OR WS_CLIPSIBLINGS,10,10,75,35,hDlg,cast(HMENU,1001),instance,0)
           CreateWindowEx(512,"EDIT","Edit",WS_CHILD OR WS_VISIBLE OR WS_CLIPSIBLINGS,10,50,125,25,hDlg,cast(HMENU,1002),instance,0)
           CreateWindowEx(0,"SCROLLBAR","",WS_CHILD OR WS_VISIBLE OR WS_CLIPSIBLINGS,10,100,175,19,hDlg,cast(HMENU,1003),instance,0)
           return 0
        case WM_CLOSE
           select case MessageBox(hDlg,"Really close ?","myFBApplication",MB_YESNO OR MB_ICONERROR OR MB_TOPMOST OR MB_TASKMODAL)
               case IDYES
                   PostQuitMessage(0)
               case IDNO
                   return 1
           end select
           return 0
        case WM_COMMAND
           select case loword(wParam)
               case 10001
                   Designer.Dialog = hAppHandle
                   Designer.Active = true
               case 10002
                   Designer.Active = false
               case 10003
                   if Designer.SnapToGrid then
                       Designer.SnapToGrid = false
                   else
                       Designer.SnapToGrid = true
                   end if
               case 10004
                   if Designer.ShowGrid then
                       Designer.ShowGrid = false
                   else
                       Designer.ShowGrid = true
                   end if
               case 101 ' @"Red"
                   Designer.DotColor = &H0000FF
               case 102 ' @"Blue"
                   Designer.DotColor = &HFF0000
               case 103 ' @"Gren"
                   Designer.DotColor = &H00FF00
               case 104 ' @"Black"
                   Designer.DotColor = &H000000
               case 105 ' @"3 x 3"
                   Designer.StepX = 3
                   Designer.StepY = 3
               case 106 ' @"4 x 4"
                   Designer.StepX = 4
                   Designer.StepY = 4
               case 107 ' @"6 x 6"
                   Designer.StepX = 6
                   Designer.StepY = 6
               case 108 ' @"7 x 7"
                   Designer.StepX = 8
                   Designer.StepY = 8   
               case 10005
                   return SendMessage(hDlg,WM_CLOSE,0,0)
               case 10006
                   Designer.ClassName = "Button"
               case 10007
                   Designer.ClassName = "Edit"
               case 10008
                   Designer.ClassName = "ComboBox"
               case 10009
                   Designer.ClassName = "msctls_trackbar32"
               case 10010
                   Designer.ClassName = "ToolBarWindow32"   
               case 10011
                   Designer.ClassName = "SysTabControl32"
               case 10012   
                   MessageBox(hDlg,"TinyDesigner v 0.0"&chr(10)&_
                                   "This program was created for educational purposes to support the novice in the API and FreeBASIC."&chr(10)&_
                                   " You can change and improve to meet your needs."&chr(10)&_
                                   "(c)2013 Nastase Eodor"&chr(10)&_
                                   "http://rqwork.xhost.ro"&chr(10)&_
                                   "nastasa.eodor@gmail.com","Designer",_
                                   MB_ICONINFORMATION)
               case 1001 'Button Control
                   MessageBox(hDlg, "Hello ! I'm an tiny Designer.", "Designer", MB_ICONWARNING)
           end select
           return 0
   end select
   return DefWindowProc(hDlg, Msg, wParam, lParam)
end function

sub myFBApplication_CreateWindow
    hAppHandle = CreateWindowEx(WS_EX_APPWINDOW,"myFBApplication","myFBApplication",WS_OVERLAPPEDWINDOW OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS,200,200,500,350,0,0,instance,0)
    if IsWindow(hAppHandle) then
        ShowWindow(hAppHandle, SW_SHOW)
        UpdateWindow(hAppHandle)
    end if
end sub

sub myFBApplication_RegisterClass
    dim as WNDCLASSEX wcls
    wcls.cbSize        = sizeof(WNDCLASSEX)
    wcls.hInstance     = instance
    wcls.lpszClassName = @"myFBApplication"
    wcls.lpfnWndProc   = @myFBApplication_WindowProc
    wcls.hbrBackground = cast(HBRUSH, 16)
    wcls.hIcon         = LoadIcon(instance, "MAIN")
    wcls.hCursor       = LoadCursor(0, IDC_ARROW)
    wcls.lpszMenuName  = 0
    if RegisterClassEx(@wcls) = 0 then
        MessageBox(0,"Failed to register myFBApplication.","Application Error",MB_ICONERROR OR MB_TOPMOST OR MB_TASKMODAL)
    end if
end sub

/' Main  '/
myFBApplication_RegisterClass
myFBApplication_CreateWindow


dim as MSG uMsg   
while GetMessage(@uMsg, 0, 0, 0) > 0
    TranslateMessage(@uMsg)
    DispatchMessage(@uMsg)
wend

/'  Module  '/
sub Initialization constructor
    InitCommonControls
end sub

sub Finalization destructor
    UnregisterClass("myFBApplication", instance)
    ExitProcess(0)
end sub