#define XSynEdit_RegisterClasses "XSynEdit"
'#include once "DelphiPack.bi"

#define XSynEdit_VirtualClass true

#define Q_SynEdit(__ptr__) *cast(PXSynEdit,__ptr__)

#include once "C:\Users\nasta\Desktop\IDE7\gui\richedit\QFont.bi"

type PXSynEdit as XSynEdit ptr
type XSynEdit extends QFrame
    private:
    as any ptr Obj
    protected:
    Create as function stdcall(as zstring ptr,byref as hwnd,as integer,as integer,as integer,as integer,byref as any ptr) as hwnd
    declare virtual sub CreateHandle
    declare virtual sub Dispatch(byref as QMessage)
    declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
    public:
    as QFont Font
    declare virtual sub Free
    declare operator cast as any ptr
    declare constructor
end type

sub XSynEdit.CreateHandle
    if Dll then
       Create=dylibsymbol(Dll,"Create")
       if Create then
          fHandle=fParentWindow
          Create(@"TSynEdit",fHandle,fx,fy,fcx,fcy,obj)
          if isWindow(fHandle) then
              SetProp(fHandle,"@@@_proc",cast(wndproc,SetWindowLong(fHandle,gwl_wndproc,cint(@DlgProc))))
              SetWindowLong(fHandle,gwl_userdata,cint(@this))
          end if
       end if
    end if
end sub

sub XSynEdit.Free
    dim as sub stdcall(c as hwnd) FreeInstance
    FreeInstance=dylibsymbol(Dll,"DestroyInstance")
    if FreeInstance then FreeInstance(fHandle)
end sub

sub XSynEdit.Dispatch(byref m as QMessage)
    Base.Dispatch(m)
    select case m.msg
    case wm_char
         print m.wparam
    end select
end sub

function XSynEdit.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
     dim as PClassObject obj=cast(PClassObject,GetWindowLong(dlg,gwl_userdata))
     dim as QMessage m=type(dlg,msg,wparam,lparam,0,obj,0)
     if obj then
         obj->fHandle=dlg
         obj->Dispatch(m)
         return CallWindowProc(cast(wndproc,GetProp(dlg,"@@@_proc")),dlg,msg,wparam,lparam)
     else
       obj=new XSynEdit
       if obj then
           obj->fHandle=dlg
           obj->Dispatch(m)
           return CallWindowProc(cast(wndproc,GetProp(dlg,"@@@_proc")),dlg,msg,wparam,lparam)
       end if
    end if
    return CallWindowProc(cast(wndproc,GetProp(dlg,"@@@_proc")),dlg,msg,wparam,lparam)
end function

operator XSynEdit.cast as any ptr
    return @this
end operator

constructor XSynEdit
    ClassName="XSynEdit"
    ClassAncestor="TSynEdit"
    fcx=400
    fcy=200
    Font.Parent=this
end constructor

#IFDEF LOCALINITIALIZATION

sub XSynEdit_initialization constructor
    Dll=dylibload("DelphiClasses.dll")
end sub

sub XSynEdit_finalization destructor
    dim as sub stdcall() FreeAll
    FreeAll=dylibsymbol(Dll,"DestroyInstances")
    if FreeAll then FreeAll()
end sub

#ENDIF