#define XColorGrid_RegisterClasses "XColorGrid"
'#include once "DelphiPack.bi"

#define XColorGrid_VirtualClass true

#define Q_ColorGrid(__ptr__) *cast(PXColorGrid,__ptr__)

type QMethod
     Code as any ptr
     Data as any ptr ''object from dll
end type

type PXColorGrid as XColorGrid ptr
type XColorGrid extends QFrame
    private:
    as any ptr Obj
    SetPropDLL as sub stdcall(as hwnd,as zstring ptr,as zstring ptr)
    GetPropDLL as function stdcall(as hwnd,as zstring ptr) as zstring ptr
    protected:
    as integer fFG,fBG,fIndexFG,fIndexBG
    as integer fKind
    Create as function stdcall(as zstring ptr,byref as hwnd,as integer,as integer,as integer,as integer,byref as any ptr) as hwnd
    declare virtual sub CreateHandle
    declare virtual sub Dispatch(byref as QMessage)
    declare static function DlgProc(as hwnd,as uint,as wparam,as lparam) as lresult
    public:
    declare virtual sub Free
    declare operator cast as any ptr
    declare constructor
end type

sub XColorGrid.CreateHandle
    if debuginfo then debug("dll=" & dll)
    if Dll then
       SetPropDLL=dylibsymbol(dll,"SetPropVal") :? @SetPropDLL
       GetPropDLL=dylibsymbol(dll,"GetPropVal") :? @GetPropDLL
       Create=dylibsymbol(Dll,"Create")
       if Create then
          if debuginfo then debug("dll create entry point=" & @create)
          fHandle=fParentWindow
          Create(@"TColorGrid",fHandle,fx,fy,fcx,fcy,obj)
          if isWindow(fHandle) then
              if debuginfo then  debug("window from dll=" & fhandle & " last error was =" & SysErrorMessage )
              SetProp(fHandle,STP_WNDPROC,cast(wndproc,SetWindowLong(fHandle,gwl_wndproc,cint(@DlgProc))))
              SetWindowLong(fHandle,gwl_userdata,cint(@this))
              'dim as QMethod M
              'M.Data=obj
              'if onClick then M.Code=OnClick
              'SetPropDLL(fHandle,"onClick",@M)
          end if
       end if
    end if
end sub

sub XColorGrid.Free
    dim as sub stdcall(c as hwnd) FreeInstance
    FreeInstance=dylibsymbol(Dll,"DestroyInstance")
    if FreeInstance then FreeInstance(fHandle)
end sub

sub XColorGrid.Dispatch(byref m as QMessage)
    Base.Dispatch(m)
    select case m.msg
    case wm_char
         print m.wparam
    case wm_destroy
         Free
    end select
end sub

function XColorGrid.DlgProc(dlg as hwnd,msg as uint,wparam as wparam,lparam as lparam) as lresult
     dim as PClassObject obj=cast(PClassObject,GetWindowLong(dlg,gwl_userdata))
     dim as QMessage m=type(dlg,msg,wparam,lparam,0,obj,0)
     if obj then
         obj->fHandle=dlg
         obj->Dispatch(m)
         return CallWindowProc(cast(wndproc,GetProp(dlg,STP_WNDPROC)),dlg,msg,wparam,lparam)
     else
       obj=new XColorGrid
       if obj then
           obj->fHandle=dlg
           obj->Dispatch(m)
           return CallWindowProc(cast(wndproc,GetProp(dlg,STP_WNDPROC)),dlg,msg,wparam,lparam)
       end if
    end if
    return 0
end function

operator XColorGrid.cast as any ptr
    return @this
end operator

constructor XColorGrid
    ClassName="XColorGrid"
    ClassAncestor="TColorGrid"
    fcx=400
    fcy=200

end constructor

#IFDEF LOCALINITIALIZATION

sub XColorGrid_initialization constructor
    Dll=dylibload("DelphiClasses.dll")
end sub

sub XColorGrid_finalization destructor
    dim as sub stdcall() FreeAll
    FreeAll=dylibsymbol(Dll,"DestroyInstances")
    if FreeAll then FreeAll()
end sub

#ENDIF