/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * OGDL実行コンテキストのシンプル実装を提供します。
 */
class SimpleOgdlContext implements OgdlContext {

    private final OgdlContextMixIn mixIn;

    /**
     * 初期化します。
     */
    SimpleOgdlContext() {
        this(new HashMap(0));
    }

    /**
     * 値を格納するマップを格納して初期化します。
     * 
     * @param values
     *            値を格納するマップ
     */
    SimpleOgdlContext(Map values) {
        this(values, new HashMap(0));
    }

    /**
     * 値を格納するマップとクラス参照を格納するマップを格納して初期化します。
     * 
     * @param values
     *            値を格納するマップ
     * @param classes
     *            クラス参照を格納するマップ
     */
    SimpleOgdlContext(Map values, Map classes) {
        this(values, classes, new HashMap(0));
    }

    /**
     * 値を格納するマップとクラス参照を格納するマップ、組込み関数を格納するマップを格納して初期化します。
     * 
     * @param values
     *            値を格納するマップ
     * @param classes
     *            クラス参照を格納するマップ
     * @param functions
     *            組込み関数を格納するマップ
     */
    SimpleOgdlContext(Map values, Map classes, Map functions) {
        this.mixIn = new OgdlContextMixIn(values, classes, functions);
    }

    public boolean addImport(Class clazz) {
        return mixIn.addImport(clazz);
    }

    public Class forImport(String shortName) {
        return mixIn.forImport(shortName);
    }

    public void addFunctionsMap(String prefix, Map functionsMap) {
        mixIn.addFunctionsMap(prefix, functionsMap);
    }

    public Collection forFunctions(String name) {
        return mixIn.forFunctions(name);
    }

    public Iterator attributeNames() {
        return mixIn.attributeNames();
    }

    public Object getAttribute(String name) {
        return mixIn.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        mixIn.setAttribute(name, value);
    }

    public Object removeAttribute(String name) {
        return mixIn.removeAttribute(name);
    }

    public boolean containsAttribute(String name) {
        return mixIn.containsAttribute(name);
    }

    public ClassLoader getClassLoader() {
        return mixIn.getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mixIn.setClassLoader(classLoader);
    }

}
