/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

/**
 * 単項演算子の構文解析機能を提供します。
 */
class OgdlUnaryOperatorParser {

    /* ビット否定演算を実行して返却します。 */
    static Object evaluateBitwiseComplement(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        final Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.bitwiseNot(o);
        } catch (final ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }

    /* 論理否定演算を実行して返却します。 */
    static Object evaluateLogicalComplement(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        final Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.logicalNot(o);
        } catch (final ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }

    /* 単項プラス演算を実行して返却します。 */
    static Object evaluateUnaryPlus(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        final Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.plus(o);
        } catch (final ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }

    /* 単項マイナス演算を実行して返却します。 */
    static Object evaluateUnaryMinus(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        final Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.minus(o);
        } catch (final ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }

}
