/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * 拡張関数の構文解析機能を提供します。
 */
class OgdlFunctionParser {

    /* 関数を実行して結果を返却します。 */
    static Object evaluateFunction(OgdlEvent ev) {
        final String name = OgdlSyntax.cutFunctionName(ev);
        final Collection fs = ev.context.forFunctions(name);
        if (fs == null) {
            throw new OgdlSyntaxException(ev, Utils.log("no such function. funcName=", name));
        }
        final List args = (List) OgdlParser.evaluateEncloseCollection(ev.get('(', ')', new ArrayList(8)));
        final Object[] values = args.toArray();
        final Class[] types = BeanIntrospectHelper.toClassArray(values);
        for (final Iterator i = fs.iterator(); i.hasNext();) {
            final Method m = (Method) i.next();
            if (BeanIntrospectHelper.isAssignmentCompatible(m.getParameterTypes(), types)) {
                try {
                    return m.invoke(null, values);
                } catch (final Exception e) {
                    final OgdlFunctionException fe = new OgdlFunctionException(Utils.log("method invocation err. ", m, types, values), e);
                    throw fe.throwFor(ev, name, args);
                }
            }
        }
        throw new OgdlSyntaxException(ev, Utils.log("no such function. func=", name, args));
    }

}
