/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/**
 * 
 */
package shohaku.ogdl;

import java.util.List;

/**
 * OGDLの組込み関数の実行時例外を提供します。
 */
public class OgdlFunctionException extends OgdlSyntaxException {

    /* serialVersionUID */
    private static final long serialVersionUID = 5137910581054819991L;

    /* 関数の完全名 */
    private String _name;

    /* 関数の引数 */
    private List _arguments;

    /**
     * デフォルトコンストラクタ。
     */
    public OgdlFunctionException() {
        super();
    }

    /**
     * エラーメッセージを設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     */
    public OgdlFunctionException(String message) {
        super(message);
    }

    /**
     * エラーメッセージと起因例外を設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public OgdlFunctionException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * イベントとエラーメッセージを設定して初期化します。
     * 
     * @param event
     *            解析イベント
     * @param message
     *            エラーメッセージ
     */
    public OgdlFunctionException(OgdlEvent event, String message) {
        super(event, message);
    }

    /**
     * イベントとエラーメッセージと起因例外を設定して初期化します。
     * 
     * @param event
     *            解析イベント
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public OgdlFunctionException(OgdlEvent event, String message, Throwable cause) {
        super(event, message, cause);
    }

    /**
     * 関数の引数を返却します。
     * 
     * @return 関数の引数
     */
    public List getArguments() {
        return this._arguments;
    }

    /**
     * 関数の引数を格納します。
     * 
     * @param args
     *            関数の引数
     */
    public void setArguments(List args) {
        this._arguments = args;
    }

    /**
     * 関数の完全名を返却します。
     * 
     * @return 関数の完全名
     */
    public String getName() {
        return this._name;
    }

    /**
     * 関数の完全名を格納します。
     * 
     * @param name
     *            関数の完全名
     */
    public void setName(String name) {
        this._name = name;
    }

    /**
     * プロパティを設定して自身の参照を返却します。
     * 
     * @param event
     *            イベント
     * @param name
     *            関数の完全名
     * @param args
     *            関数の引数
     * @return 自身の参照
     */
    OgdlFunctionException throwFor(OgdlEvent event, String name, List args) {
        this.setEvent(event);
        this.setName(name);
        this.setArguments(args);
        return this;
    }

    /**
     * super.toString(), function={name=getName(),args=getArguments()} の表現で返却します。
     * 
     * @return このオブジェクトの文字列表現
     * @see java.lang.Object#toString()
     */
    public String toString() {
        final StringBuffer msg = new StringBuffer();
        msg.append(super.toString());
        msg.append(", function=");
        msg.append("{");
        msg.append("name=");
        msg.append(_name);
        msg.append(",args=");
        msg.append(_arguments);
        msg.append("}");
        return msg.toString();
    }

}
