/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

class OgdlBlockOperatorParser {

    /* 演算式を実行します。 */
    static Object evaluateOperator(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev)) {
            return evaluateEncloseOperator(ev);
        } else {
            throw new OgdlSyntaxException(ev, "is not enclose literal.");
        }
    }

    /* コンマ区切りの式のグループとして解析して末尾の結果を返却します。 */
    private static Object evaluateEncloseOperator(OgdlEvent ev) {
        final int close = OgdlSyntax.getEncloseCloseChar(ev);
        ev.shiftAndShiftSpace();

        Object output = null;
        if (ev.isNotCharAt(close)) {
            while (ev.hasNext()) {
                output = OgdlRuntime.evaluate(ev);// 末尾のデータを返却する
                if (ev.isCharAt(close)) {
                    break;
                }
                if (ev.isNotSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                ev.shift();// + ','
            }
            ev.shiftSpace();
            if (ev.isNotCharAt(close)) {
                throw new OgdlSyntaxException(ev, "is not close literal.");
            }
        }

        ev.shift();// next index
        return output;
    }

}
