/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.proxy;

import shohaku.shoin.ResourceSet;
import shohaku.shoin.ResourceSetCreationException;

/**
 * 常に同一のリソース集合を返却する生成プロキシを提供します。
 */
public class StaticResourceSetFactoryProxy extends AbstractResourceSetFactoryProxy {

    /**
     * プロパティを初期値で初期化します。
     */
    public StaticResourceSetFactoryProxy() {
        super();
    }

    /**
     * 常に同一のリソース集合を返却します。<br>
     * create フラグは無視されます。
     * 
     * @param create
     *            常に無視されます。
     * @return リソース集合
     * @throws ResourceSetCreationException
     *             リソース集合の生成に失敗した場合
     * @see shohaku.shoin.ResourceSetFactoryProxy#getResourceSet(boolean)
     */
    public ResourceSet getResourceSet(boolean create) throws ResourceSetCreationException {
        synchronized (this) {
            if (resourceSet == null) {
                resourceSet = createResourceSet();
            }
            return resourceSet;
        }
    }

}
