/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.shoin.factory;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import shohaku.core.helpers.HBeans;
import shohaku.core.lang.Concat;
import shohaku.core.lang.Eval;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ginkgo.ContainTag;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.ValueNode;
import shohaku.shoin.ResourceSet;
import shohaku.shoin.resourceset.MapResourceSet;

/**
 * 複数のクラスと対応付けられたXMLファイルから、’/’ で区切られた階層名を持つプロパティセットを生成するファクトリを提供します。
 */
public class ClassMappingXMLProperties extends AbstractGinkgoResourceSetFactory {

    /**
     * プロパティを初期値で初期化します。
     */
    public ClassMappingXMLProperties() {
        super();
    }

    protected void initValues(Map lookup, TagNode root, int index) {
        for (Iterator i = root.getTagContext().elementIterator("class"); i.hasNext();) {
            TagNode classTag = (TagNode) i.next();

            try {

                Class clazz = (Class) HBeans.getProperty(classTag, "type");
                if (null == clazz) {
                    throw new GinkgoException("null is class type.");
                }
                ResourceSet resources = initClassProperties(classTag);
                lookup.put(clazz, resources);

            } catch (IntrospectionBeansException e) {
                throw new GinkgoException("tag introspection error.", e);
            }

        }
    }

    /* クラス名単位でリソースを生成します。 */
    private ResourceSet initClassProperties(TagNode classTag) {
        Map output = new LinkedHashMap();
        initClassProperties(classTag, "", output, ".");
        return new MapResourceSet(output);
    }

    /* クラス名単位のリソースを再帰的に初期化および登録をします。 */
    private void initClassProperties(TagNode parent, String parentName, Map output, String separator) {
        for (Iterator i = parent.getTagContext().ownerIterator(); i.hasNext();) {
            TagNode t = (TagNode) i.next();
            if (t instanceof ValueNode) {
                String name = t.getName();
                if (!Eval.isBlank(name)) {
                    output.put(Concat.get(parentName, name), ((ValueNode) t).getNodeValue());
                }
            } else if (t instanceof ContainTag) {
                if ("constants".equals(t.getTagContext().getTagName())) {
                    initClassProperties(t, parentName, output, "_");
                } else {
                    String name = t.getName();
                    if (!Eval.isBlank(name)) {
                        initClassProperties(t, Concat.get(parentName, name, separator), output, separator);
                    }
                }
            }
        }
    }
}
