/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.shoin.factory;

import java.util.Iterator;
import java.util.Map;

import shohaku.core.lang.Concat;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.ContainTag;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.ValueNode;
import shohaku.shoin.ResourceKeyPrefixSupport;

/**
 * クラスと１対１で対応付けられたXMLファイルから、’/’ で区切られた階層名を持つプロパティセットを生成するファクトリを提供します。
 */
public class ClassBindXMLProperties extends AbstractGinkgoResourceSetFactory implements ResourceKeyPrefixSupport {

    /* ResourceKeyPrefixSupport Mix-in */
    private final ResourceKeyPrefixMixIn prefixsMixIn = new ResourceKeyPrefixMixIn();

    /**
     * プロパティを初期値で初期化します。
     */
    public ClassBindXMLProperties() {
        super();
    }

    protected void initValues(Map lookup, TagNode root, int index) {
        initValues(root, prefixsMixIn.findPrefix(index), "", lookup, ".");
    }

    /* 再起的にリソースを登録します。 */
    private void initValues(TagNode parent, String prefix, String parentsName, Map output, String separator) {
        for (Iterator i = parent.getTagContext().ownerIterator(); i.hasNext();) {
            TagNode tag = (TagNode) i.next();
            initValue(tag, prefix, parentsName, output, separator);
        }
    }

    /* リソースを評価して登録します。 */
    private void initValue(TagNode tag, String prefix, String parentsName, Map output, String separator) {
        if (tag instanceof ValueNode) {
            String name = tag.getName();
            if (!Eval.isBlank(name)) {
                output.put(Concat.get(prefix, parentsName, name), ((ValueNode) tag).getNodeValue());
            }
        } else if (tag instanceof ContainTag) {
            if ("constants".equals(tag.getTagContext().getTagName())) {
                initValues(tag, prefix, parentsName, output, "_");
            } else {
                String name = tag.getName();
                if (!Eval.isBlank(name)) {
                    initValues(tag, prefix, Concat.get(parentsName, name, separator), output, separator);
                }
            }
        }
    }

    /*
     * ResourceKeyPrefixSupport
     */

    public String getPrefix() {
        return prefixsMixIn.getPrefix();
    }

    public void setPrefix(String prefix) {
        prefixsMixIn.setPrefix(prefix);
    }

    public String[] getSourcesPrefix() {
        return prefixsMixIn.getSourcesPrefix();
    }

    public void setSourcesPrefix(String[] prefixs) {
        prefixsMixIn.setSourcesPrefix(prefixs);
    }
}
