/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.bundle;

import shohaku.core.resource.IOResource;
import shohaku.shoin.ResourceSet;
import shohaku.shoin.ResourceSetCreationException;
import shohaku.shoin.factory.XMLProperties;

class XMLResourceBundleCreater extends AbstractGinkgoXResourceBundleCreater {

    protected AbstractGinkgoXResourceBundle createGinkgoResourceBundle(GinkgoXResourceBundleEvent event) {

        XMLProperties props = new XMLProperties();
        props.setClassLoader(event.getClassLoader());
        props.setParentDocument(event.getTargetParentDocument());
        props.setDocumentCompositeRule(event.getTargetDocumentCompositeRule());
        props.setNodeCompositeRule(event.getTargetNodeCompositeRule());
        props.setIOResources(new IOResource[] { event.getTargetIOResource() });

        try {

            ResourceSet resources = props.getResourceSet();
            return new XMLResourceBundle(event.getTargetParent(), event.getTargetBundleBase(), resources, props.getParseDocument());

        } catch (ResourceSetCreationException e) {
            e.printStackTrace();
            return null;
        }

    }

    protected Class getGinkgoResourceBundleClass() {
        return XMLResourceBundle.class;
    }
}