/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.bundle;

import java.util.MissingResourceException;

import shohaku.core.resource.IOResourceLoader;
import shohaku.ginkgo.Document;
import shohaku.shoin.ResourceSet;
import shohaku.shoin.XResourceBundle;
import shohaku.shoin.XResourceBundleBase;
import shohaku.shoin.XResourceBundleCache;

/**
 * {@link shohaku.shoin.factory.ClassBindXMLProperties} を用いた階層化リソースバンドルを提供します。
 */
public class ClassBindResourceBundle extends AbstractGinkgoXResourceBundle {

    /* 拡張リソースバンドルのキャッシュ機能のシングルトンインスタンスを格納します。 */
    static final class ClassBindResourceBundleCache {
        // new Singleton Instance
        static final XResourceBundleCache instance = new XResourceBundleCache(new ClassBindResourceBundleCreater());
    }

    /**
     * 拡張リソースバンドルを初期化します。
     * 
     * @param parent
     *            親バンドル
     * @param bundleBase
     *            束縛基準
     * @param resources
     *            リソース集合
     * @param document
     *            ドキュメント
     */
    ClassBindResourceBundle(XResourceBundle parent, XResourceBundleBase bundleBase, ResourceSet resources, Document document) {
        super(parent, bundleBase, resources, document);
    }

    /*
     * static
     */

    /* キャッシュ機能のインスタンスを返却します。 */
    static XResourceBundleCache getXResourceBundleCache() {
        return ClassBindResourceBundleCache.instance;
    }

    /*
     * factory
     */

    /**
     * 指定された基底名、束縛基準、および呼び出し側のクラスローダを使用して、リソースバンドルを取得します。 <br>
     * このメソッドを呼び出すことは、以下を呼び出すことと同じです。 <br>
     * getBundle(baseName, bundleBase, getDefaultLoader())
     * 
     * @param baseName
     *            基底名
     * @param bundleBase
     *            束縛基準
     * @return 指定された基底名と束縛基準の拡張リソースバンドル
     * @throws MissingResourceException
     *             指定された基底名のリソースバンドルが見つからない場合
     */
    public static ClassBindResourceBundle getBundle(String baseName, XResourceBundleBase bundleBase) {
        return getBundle(baseName, bundleBase, null, null);
    }

    /**
     * 指定された基底名、束縛基準、クラスローダを使用して、拡張リソースバンドルを取得します。
     * 
     * @param baseName
     *            基底名
     * @param bundleBase
     *            束縛基準
     * @param irLoader
     *            IOリソース生成機能
     * @param classLoader
     *            クラスローダ
     * @return 指定された基底名と束縛基準の拡張リソースバンドル
     * @throws MissingResourceException
     *             指定された基底名のリソースバンドルが見つからない場合
     */
    public static ClassBindResourceBundle getBundle(String baseName, XResourceBundleBase bundleBase, IOResourceLoader irLoader, ClassLoader classLoader) {
        GinkgoXResourceBundleEvent bundleEvent = new GinkgoXResourceBundleEvent(ClassBindResourceBundle.class);
        bundleEvent.setBaseName(baseName);
        bundleEvent.setBundleBase(bundleBase);
        bundleEvent.setIOResourceLoader(irLoader);
        bundleEvent.setClassLoader(classLoader);
        return (ClassBindResourceBundle) getXResourceBundleCache().getBundle(bundleEvent);
    }

}
